/*
 * Decompiled with CFR 0.152.
 */
package tyrex.resource.jdbc.xa;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Map;
import tyrex.resource.jdbc.xa.TyrexCallableStatementImpl;
import tyrex.resource.jdbc.xa.TyrexPreparedStatementImpl;
import tyrex.resource.jdbc.xa.TyrexStatementImpl;

public abstract class TyrexConnection
implements Connection {
    public synchronized Statement createStatement() throws SQLException {
        try {
            return new TyrexStatementImpl(this.getUnderlyingConnection().createStatement(), this);
        }
        catch (SQLException sQLException) {
            this.notifyError(sQLException);
            throw sQLException;
        }
    }

    public synchronized Statement createStatement(int n, int n2) throws SQLException {
        try {
            return new TyrexStatementImpl(this.getUnderlyingConnection().createStatement(n, n2), this);
        }
        catch (SQLException sQLException) {
            this.notifyError(sQLException);
            throw sQLException;
        }
    }

    public synchronized PreparedStatement prepareStatement(String string) throws SQLException {
        try {
            return new TyrexPreparedStatementImpl(this.getUnderlyingConnection().prepareStatement(string), this);
        }
        catch (SQLException sQLException) {
            this.notifyError(sQLException);
            throw sQLException;
        }
    }

    public synchronized PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        try {
            return new TyrexPreparedStatementImpl(this.getUnderlyingConnection().prepareStatement(string, n, n2), this);
        }
        catch (SQLException sQLException) {
            this.notifyError(sQLException);
            throw sQLException;
        }
    }

    public synchronized CallableStatement prepareCall(String string) throws SQLException {
        try {
            return new TyrexCallableStatementImpl(this.getUnderlyingConnection().prepareCall(string), this);
        }
        catch (SQLException sQLException) {
            this.notifyError(sQLException);
            throw sQLException;
        }
    }

    public synchronized CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        try {
            return new TyrexCallableStatementImpl(this.getUnderlyingConnection().prepareCall(string, n, n2), this);
        }
        catch (SQLException sQLException) {
            this.notifyError(sQLException);
            throw sQLException;
        }
    }

    public synchronized String nativeSQL(String string) throws SQLException {
        try {
            return this.getUnderlyingConnection().nativeSQL(string);
        }
        catch (SQLException sQLException) {
            this.notifyError(sQLException);
            throw sQLException;
        }
    }

    public synchronized DatabaseMetaData getMetaData() throws SQLException {
        try {
            return this.getUnderlyingConnection().getMetaData();
        }
        catch (SQLException sQLException) {
            this.notifyError(sQLException);
            throw sQLException;
        }
    }

    public synchronized void setCatalog(String string) throws SQLException {
        try {
            this.getUnderlyingConnection().setCatalog(string);
        }
        catch (SQLException sQLException) {
            this.notifyError(sQLException);
            throw sQLException;
        }
    }

    public synchronized String getCatalog() throws SQLException {
        try {
            return this.getUnderlyingConnection().getCatalog();
        }
        catch (SQLException sQLException) {
            this.notifyError(sQLException);
            throw sQLException;
        }
    }

    public synchronized SQLWarning getWarnings() throws SQLException {
        try {
            return this.getUnderlyingConnection().getWarnings();
        }
        catch (SQLException sQLException) {
            this.notifyError(sQLException);
            throw sQLException;
        }
    }

    public synchronized void clearWarnings() throws SQLException {
        try {
            this.getUnderlyingConnection().clearWarnings();
        }
        catch (SQLException sQLException) {
            this.notifyError(sQLException);
            throw sQLException;
        }
    }

    public synchronized Map getTypeMap() throws SQLException {
        try {
            return this.getUnderlyingConnection().getTypeMap();
        }
        catch (SQLException sQLException) {
            this.notifyError(sQLException);
            throw sQLException;
        }
    }

    public synchronized void setTypeMap(Map map) throws SQLException {
        try {
            this.getUnderlyingConnection().setTypeMap(map);
        }
        catch (SQLException sQLException) {
            this.notifyError(sQLException);
            throw sQLException;
        }
    }

    public synchronized void setAutoCommit(boolean bl) throws SQLException {
        try {
            this.getUnderlyingConnection().setAutoCommit(bl);
        }
        catch (SQLException sQLException) {
            this.notifyError(sQLException);
            throw sQLException;
        }
    }

    public synchronized boolean getAutoCommit() throws SQLException {
        try {
            return this.getUnderlyingConnection().getAutoCommit();
        }
        catch (SQLException sQLException) {
            this.notifyError(sQLException);
            throw sQLException;
        }
    }

    public synchronized void commit() throws SQLException {
        try {
            this.getUnderlyingConnection().commit();
        }
        catch (SQLException sQLException) {
            this.notifyError(sQLException);
            throw sQLException;
        }
    }

    public synchronized void rollback() throws SQLException {
        try {
            this.getUnderlyingConnection().rollback();
        }
        catch (SQLException sQLException) {
            this.notifyError(sQLException);
            throw sQLException;
        }
    }

    public synchronized void setReadOnly(boolean bl) throws SQLException {
        try {
            this.getUnderlyingConnection().setReadOnly(bl);
        }
        catch (SQLException sQLException) {
            this.notifyError(sQLException);
            throw sQLException;
        }
    }

    public synchronized boolean isReadOnly() throws SQLException {
        try {
            return this.getUnderlyingConnection().isReadOnly();
        }
        catch (SQLException sQLException) {
            this.notifyError(sQLException);
            throw sQLException;
        }
    }

    public synchronized void setTransactionIsolation(int n) throws SQLException {
        try {
            this.getUnderlyingConnection().setTransactionIsolation(n);
        }
        catch (SQLException sQLException) {
            this.notifyError(sQLException);
            throw sQLException;
        }
    }

    public synchronized int getTransactionIsolation() throws SQLException {
        try {
            return this.getUnderlyingConnection().getTransactionIsolation();
        }
        catch (SQLException sQLException) {
            this.notifyError(sQLException);
            throw sQLException;
        }
    }

    protected void notifyError(SQLException sQLException) {
    }

    public synchronized void close() throws SQLException {
        try {
            this.internalClose();
        }
        catch (SQLException sQLException) {
            this.notifyError(sQLException);
            throw sQLException;
        }
    }

    protected abstract void internalClose() throws SQLException;

    public abstract boolean isClosed();

    protected void finalize() throws Throwable {
        if (!this.isClosed()) {
            this.close();
        }
    }

    private Connection getUnderlyingConnection() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("The connection is closed.");
        }
        return this.internalGetUnderlyingConnection();
    }

    protected abstract Connection internalGetUnderlyingConnection() throws SQLException;
}

