/*
 * Decompiled with CFR 0.152.
 */
package tyrex.tm.impl;

import javax.naming.Context;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;
import tyrex.naming.MemoryBinding;
import tyrex.naming.MemoryContext;
import tyrex.tm.RuntimeContext;
import tyrex.tm.XAResourceCallback;
import tyrex.tm.impl.TransactionImpl;
import tyrex.tm.impl.XAResourceHolder;

public class ThreadContext
extends RuntimeContext {
    protected TransactionImpl _tx;
    protected InternalXAResourceHolder _xaResourceHolder;
    private final Subject _subject;
    private final MemoryBinding _bindings;
    private static ThreadEntry[] _table = new ThreadEntry[1103];
    private static final int TABLE_SIZE = 1103;
    static /* synthetic */ Class class$tyrex$naming$MemoryContextFactory;

    public ThreadContext(Subject subject) {
        this._bindings = new MemoryBinding();
        this._subject = subject;
    }

    public ThreadContext(Context context, Subject subject) throws NamingException {
        if (context == null) {
            this._bindings = new MemoryBinding();
        } else {
            if (!(context instanceof MemoryContext)) {
                throw new NamingException("The context was not created from " + (class$tyrex$naming$MemoryContextFactory == null ? (class$tyrex$naming$MemoryContextFactory = ThreadContext.class$("tyrex.naming.MemoryContextFactory")) : class$tyrex$naming$MemoryContextFactory).getName());
            }
            this._bindings = ((MemoryContext)context).getBindings();
            if (!this._bindings.isRoot()) {
                throw new NamingException("The context is not a root context");
            }
        }
        this._subject = subject;
    }

    public static ThreadContext getThreadContext() {
        ThreadContext threadContext;
        Thread thread = Thread.currentThread();
        int n = (thread.hashCode() & Integer.MAX_VALUE) % _table.length;
        ThreadEntry threadEntry = _table[n];
        while (threadEntry != null) {
            if (threadEntry._thread == thread) {
                return threadEntry._context;
            }
            threadEntry = threadEntry._nextEntry;
        }
        ThreadEntry[] threadEntryArray = _table;
        synchronized (threadEntryArray) {
            threadContext = new ThreadContext(null);
            threadEntry = new ThreadEntry(threadContext, thread, null);
            threadEntry._nextEntry = _table[n];
            ThreadContext._table[n] = threadEntry;
        }
        return threadContext;
    }

    public static ThreadContext getThreadContext(Thread thread) {
        ThreadContext threadContext;
        int n = (thread.hashCode() & Integer.MAX_VALUE) % _table.length;
        ThreadEntry threadEntry = _table[n];
        while (threadEntry != null) {
            if (threadEntry._thread == thread) {
                return threadEntry._context;
            }
            threadEntry = threadEntry._nextEntry;
        }
        ThreadEntry[] threadEntryArray = _table;
        synchronized (threadEntryArray) {
            threadContext = new ThreadContext(null);
            threadEntry = new ThreadEntry(threadContext, thread, null);
            threadEntry._nextEntry = _table[n];
            ThreadContext._table[n] = threadEntry;
        }
        return threadContext;
    }

    public static void setThreadContext(ThreadContext threadContext) {
        if (threadContext == null) {
            throw new IllegalArgumentException("Argument context is null");
        }
        ThreadEntry[] threadEntryArray = _table;
        synchronized (threadEntryArray) {
            Thread thread = Thread.currentThread();
            int n = (thread.hashCode() & Integer.MAX_VALUE) % _table.length;
            ThreadEntry threadEntry = _table[n];
            if (threadEntry != null && threadEntry._thread == thread) {
                ThreadContext._table[n] = threadEntry = new ThreadEntry(threadContext, thread, threadEntry);
                return;
            }
            ThreadEntry threadEntry2 = threadEntry != null ? threadEntry._nextEntry : null;
            while (threadEntry2 != null) {
                if (threadEntry2._thread == thread) {
                    threadEntry._nextEntry = threadEntry2 = new ThreadEntry(threadContext, thread, threadEntry2);
                    return;
                }
                threadEntry = threadEntry2;
                threadEntry2 = threadEntry2._nextEntry;
            }
            threadEntry = new ThreadEntry(threadContext, thread, null);
            threadEntry._nextEntry = _table[n];
            ThreadContext._table[n] = threadEntry;
        }
    }

    public static ThreadContext unsetThreadContext() {
        ThreadEntry[] threadEntryArray = _table;
        synchronized (threadEntryArray) {
            Thread thread = Thread.currentThread();
            int n = (thread.hashCode() & Integer.MAX_VALUE) % _table.length;
            ThreadEntry threadEntry = _table[n];
            if (threadEntry == null) {
                ThreadContext threadContext = null;
                return threadContext;
            }
            if (threadEntry._thread == thread) {
                ThreadEntry threadEntry2 = threadEntry._previous;
                if (threadEntry2 == null) {
                    ThreadContext._table[n] = threadEntry._nextEntry;
                } else {
                    threadEntry2._nextEntry = threadEntry._nextEntry;
                    ThreadContext._table[n] = threadEntry2;
                }
                ThreadContext threadContext = threadEntry._context;
                return threadContext;
            }
            ThreadEntry threadEntry3 = threadEntry._nextEntry;
            while (threadEntry3 != null) {
                if (threadEntry3._thread == thread) {
                    ThreadEntry threadEntry4 = threadEntry3._previous;
                    if (threadEntry4 == null) {
                        threadEntry._nextEntry = threadEntry3._nextEntry;
                    } else {
                        threadEntry4._nextEntry = threadEntry3._nextEntry;
                        threadEntry._nextEntry = threadEntry4;
                    }
                    ThreadContext threadContext = threadEntry3._context;
                    return threadContext;
                }
                threadEntry = threadEntry3;
                threadEntry3 = threadEntry3._nextEntry;
            }
        }
        return null;
    }

    public static void cleanup(Thread thread) {
        if (thread == null) {
            throw new IllegalArgumentException("Argument thread is null");
        }
        ThreadEntry[] threadEntryArray = _table;
        synchronized (threadEntryArray) {
            int n = (thread.hashCode() & Integer.MAX_VALUE) % _table.length;
            ThreadEntry threadEntry = _table[n];
            if (threadEntry == null) {
                return;
            }
            if (threadEntry._thread == thread) {
                ThreadContext._table[n] = threadEntry._nextEntry;
                return;
            }
            ThreadEntry threadEntry2 = threadEntry._nextEntry;
            while (threadEntry2 != null) {
                if (threadEntry2._thread == thread) {
                    threadEntry._nextEntry = threadEntry2._nextEntry;
                    return;
                }
                threadEntry = threadEntry2;
                threadEntry2 = threadEntry2._nextEntry;
            }
        }
    }

    public Context getEnvContext() {
        return this._bindings.getContext();
    }

    public Transaction getTransaction() {
        return this._tx;
    }

    public Subject getSubject() {
        return this._subject;
    }

    public void cleanup() {
        this._tx = null;
        this._xaResourceHolder = null;
    }

    public MemoryBinding getMemoryBinding() {
        return this._bindings;
    }

    protected void add(XAResource xAResource, XAResourceCallback xAResourceCallback) {
        if (xAResource == null) {
            throw new IllegalArgumentException("Argument xaResource is null");
        }
        if (this._xaResourceHolder == null) {
            this._xaResourceHolder = new InternalXAResourceHolder(xAResource, xAResourceCallback);
        } else {
            InternalXAResourceHolder internalXAResourceHolder = this._xaResourceHolder;
            do {
                if (xAResource != internalXAResourceHolder._xaResource) continue;
                return;
            } while (null != (internalXAResourceHolder = internalXAResourceHolder._next));
            internalXAResourceHolder = new InternalXAResourceHolder(xAResource, xAResourceCallback);
            internalXAResourceHolder._next = this._xaResourceHolder;
            this._xaResourceHolder = internalXAResourceHolder;
        }
    }

    protected boolean remove(XAResource xAResource) {
        if (this._xaResourceHolder != null) {
            InternalXAResourceHolder internalXAResourceHolder = this._xaResourceHolder;
            InternalXAResourceHolder internalXAResourceHolder2 = null;
            do {
                if (xAResource == internalXAResourceHolder._xaResource) {
                    if (null == internalXAResourceHolder2) {
                        this._xaResourceHolder = internalXAResourceHolder._next;
                    } else {
                        internalXAResourceHolder2._next = internalXAResourceHolder._next;
                    }
                    return true;
                }
                internalXAResourceHolder2 = internalXAResourceHolder;
            } while (null != (internalXAResourceHolder = internalXAResourceHolder._next));
        }
        return false;
    }

    protected XAResourceHolder[] getXAResourceHolders() {
        int n = 0;
        if (this._xaResourceHolder == null) {
            return null;
        }
        InternalXAResourceHolder internalXAResourceHolder = this._xaResourceHolder;
        do {
            ++n;
        } while (null != (internalXAResourceHolder = internalXAResourceHolder._next));
        XAResourceHolder[] xAResourceHolderArray = new XAResourceHolder[n];
        n = 0;
        internalXAResourceHolder = this._xaResourceHolder;
        do {
            xAResourceHolderArray[n++] = internalXAResourceHolder;
        } while (null != (internalXAResourceHolder = internalXAResourceHolder._next));
        return xAResourceHolderArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class InternalXAResourceHolder
    extends XAResourceHolder {
        private InternalXAResourceHolder _next;

        InternalXAResourceHolder(XAResource xAResource, XAResourceCallback xAResourceCallback) {
            super(xAResource, xAResourceCallback);
        }
    }

    private static final class ThreadEntry {
        final Thread _thread;
        ThreadContext _context;
        ThreadEntry _previous;
        ThreadEntry _nextEntry;

        ThreadEntry(ThreadContext threadContext, Thread thread, ThreadEntry threadEntry) {
            this._context = threadContext;
            this._thread = thread;
            if (threadEntry != null) {
                this._previous = threadEntry;
                this._nextEntry = threadEntry._nextEntry;
            }
        }
    }
}

