/*
 * Decompiled with CFR 0.152.
 */
package tyrex.tm.xid;

import javax.transaction.xa.Xid;
import tyrex.services.UUID;
import tyrex.tm.xid.BaseXid;

public final class LocalXid
extends BaseXid {
    private final byte[] _branch;
    private static final char[] XID_PREFIX_ARRAY = BaseXid.createPrefix(-2132738098);
    public static final int LOCAL_FORMAT_ID = -2132738098;

    public LocalXid() {
        byte[] byArray = UUID.createBinary();
        StringBuffer stringBuffer = new StringBuffer(46);
        stringBuffer.append(XID_PREFIX_ARRAY).append('-');
        int n = byArray.length;
        while (n-- > 0) {
            stringBuffer.append(BaseXid.HEX_DIGITS[(byArray[n] & 0xF0) >> 4]);
            stringBuffer.append(BaseXid.HEX_DIGITS[byArray[n] & 0xF]);
        }
        this._branch = byArray;
        this._string = stringBuffer.toString();
    }

    LocalXid(String string, byte[] byArray) {
        this._string = string;
        this._branch = byArray;
    }

    public int getFormatId() {
        return -2132738098;
    }

    public byte[] getGlobalTransactionId() {
        return BaseXid.EMPTY_ARRAY;
    }

    public byte[] getBranchQualifier() {
        return this._branch;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof LocalXid) {
            return this._string.equals(((LocalXid)object)._string);
        }
        if (object instanceof Xid) {
            Xid xid = (Xid)object;
            if (xid.getFormatId() != -2132738098) {
                return false;
            }
            byte[] byArray = xid.getGlobalTransactionId();
            if (byArray != null && byArray.length != 0) {
                return false;
            }
            byArray = xid.getBranchQualifier();
            if (byArray == null || byArray.length != this._branch.length) {
                return false;
            }
            int n = byArray.length;
            while (n-- > 0) {
                if (byArray[n] == this._branch[n]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public Xid newBranch() {
        return new LocalXid();
    }
}

