/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsrp4j.log;

import java.io.InputStream;
import java.util.Properties;
import org.apache.log4j.PropertyConfigurator;
import org.apache.wsrp4j.log.Logger;
import org.apache.wsrp4j.log.LoggerImpl;

public class LogManager {
    private static final String LOG_PROPERTIES_FILE = "wsrp4j-logger.properties";
    private static final String PROPERTY_PREFIX = "wsrp4j.logger.";
    private static final String GLOBAL_LOG_LEVEL_PROPERTY = "wsrp4j.logger";
    private static int globalLogLevel = 10;
    private static Properties wsrp4jLevels = new Properties();
    private static LogManager logManager = new LogManager();

    private LogManager() {
        try {
            InputStream propertiesInputStream = this.getClass().getClassLoader().getResourceAsStream(LOG_PROPERTIES_FILE);
            wsrp4jLevels.load(propertiesInputStream);
        }
        catch (Exception e) {
            System.err.println("LogManager: Error while initializing log properties. StackTrace follows.");
            e.printStackTrace(System.err);
        }
        try {
            PropertyConfigurator.configure((Properties)wsrp4jLevels);
            org.apache.log4j.Logger.getLogger(this.getClass()).info((Object)"Logger.properties file: wsrp4j-logger.properties");
            int userDefinedGlobalLevel = this.getLevelFromString(wsrp4jLevels.getProperty(GLOBAL_LOG_LEVEL_PROPERTY));
            if (userDefinedGlobalLevel != 0) {
                globalLogLevel = userDefinedGlobalLevel;
            }
            org.apache.log4j.Logger.getLogger(this.getClass()).info((Object)("Global log level: " + this.getLevelAsString(globalLogLevel)));
        }
        catch (Exception e) {
            System.err.println("LogManager: Error while initializing Logger.");
        }
    }

    public static LogManager getLogManager() {
        return logManager;
    }

    public Logger getLogger(Class aClass) {
        org.apache.log4j.Logger logger = org.apache.log4j.Logger.getLogger((Class)aClass);
        String propertyName = PROPERTY_PREFIX + aClass.getName();
        int level = globalLogLevel;
        int userDefinedLevel = this.getLevelFromString(wsrp4jLevels.getProperty(propertyName));
        if (userDefinedLevel != 0) {
            level = userDefinedLevel;
        }
        return new LoggerImpl(logger, level);
    }

    private int getLevelFromString(String s) {
        if (s != null) {
            if (s.equalsIgnoreCase("ERROR")) {
                return 10;
            }
            if (s.equalsIgnoreCase("WARN")) {
                return 20;
            }
            if (s.equalsIgnoreCase("INFO")) {
                return 30;
            }
            if (s.equalsIgnoreCase("TRACE_LOW")) {
                return 40;
            }
            if (s.equalsIgnoreCase("TRACE_MEDIUM")) {
                return 50;
            }
            if (s.equalsIgnoreCase("TRACE_HIGH")) {
                return 60;
            }
            return 0;
        }
        return 0;
    }

    private String getLevelAsString(int level) {
        String sLevel = level < 20 ? "ERROR" : (level < 30 ? "WARN" : (level < 40 ? "INFO" : (level < 50 ? "TRACE_LOW" : (level < 60 ? "TRACE_MEDIUM" : "TRACE_HIGH"))));
        return sLevel;
    }
}

