/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsrp4j.persistence.driver;

import java.io.InputStream;
import java.util.Properties;
import org.apache.wsrp4j.exception.WSRPException;
import org.apache.wsrp4j.exception.WSRPXHelper;
import org.apache.wsrp4j.log.LogManager;
import org.apache.wsrp4j.log.Logger;
import org.apache.wsrp4j.persistence.ClientPersistentFactory;
import org.apache.wsrp4j.persistence.ServerPersistentFactory;

public class PersistentAccess {
    private static String WSRP_SERVICES = "WSRPServices.properties";
    private static String CLIENT = "SwingConsumer.properties";
    private static String SERVER_PERSISTENT_FACTORY = "server.persistent.factory";
    private static String CLIENT_PERSISTENT_FACTORY = "client.persistent.factory";
    private static Properties pFactories = null;
    private static ServerPersistentFactory serverPersistentFactory = null;
    private static ClientPersistentFactory clientPersistentFactory = null;
    private static Logger logger = LogManager.getLogManager().getLogger(PersistentAccess.getThisClass());
    static /* synthetic */ Class class$org$apache$wsrp4j$persistence$driver$PersistentAccess;

    public static ServerPersistentFactory getServerPersistentFactory() throws WSRPException {
        String MN = "getServerPersistentFactory";
        if (logger.isLogging(60)) {
            logger.entry(60, MN);
        }
        if (serverPersistentFactory == null) {
            serverPersistentFactory = (ServerPersistentFactory)PersistentAccess.getFactory(SERVER_PERSISTENT_FACTORY, WSRP_SERVICES);
        }
        if (logger.isLogging(60)) {
            logger.exit(60, MN);
        }
        return serverPersistentFactory;
    }

    public static ClientPersistentFactory getClientPersistentFactory() throws WSRPException {
        String MN = "getClientPersistentFactory";
        if (logger.isLogging(60)) {
            logger.entry(60, MN);
        }
        if (clientPersistentFactory == null) {
            clientPersistentFactory = (ClientPersistentFactory)PersistentAccess.getFactory(CLIENT_PERSISTENT_FACTORY, CLIENT);
        }
        if (logger.isLogging(60)) {
            logger.exit(60, MN);
        }
        return clientPersistentFactory;
    }

    private static Object getFactory(String type, String propertyFile) throws WSRPException {
        String MN = "getFactory";
        if (logger.isLogging(60)) {
            logger.entry(60, MN);
        }
        Object obj = null;
        try {
            PersistentAccess.loadPropertyFile(propertyFile);
            String factoryName = (String)pFactories.get(type);
            Class<?> cl = Class.forName(factoryName);
            if (logger.isLogging(60)) {
                logger.exit(60, MN);
            }
            obj = cl.newInstance();
        }
        catch (Exception e) {
            WSRPXHelper.throwX(logger, 10, MN, 2004);
        }
        return obj;
    }

    private static void loadPropertyFile(String propertyFile) throws WSRPException {
        String MN = "loadPropertyFile";
        if (logger.isLogging(60)) {
            logger.entry(60, MN);
        }
        try {
            InputStream in = PersistentAccess.getThisClass().getClassLoader().getResourceAsStream(propertyFile);
            pFactories = new Properties();
            pFactories.load(in);
        }
        catch (Exception e) {
            WSRPXHelper.throwX(logger, 10, MN, 2002);
        }
    }

    private static Class getThisClass() {
        return class$org$apache$wsrp4j$persistence$driver$PersistentAccess == null ? (class$org$apache$wsrp4j$persistence$driver$PersistentAccess = PersistentAccess.class$("org.apache.wsrp4j.persistence.driver.PersistentAccess")) : class$org$apache$wsrp4j$persistence$driver$PersistentAccess;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

