/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsrp4j.persistence.xml.driver;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Writer;
import java.util.HashMap;
import org.apache.wsrp4j.exception.WSRPException;
import org.apache.wsrp4j.exception.WSRPXHelper;
import org.apache.wsrp4j.log.LogManager;
import org.apache.wsrp4j.log.Logger;
import org.apache.wsrp4j.persistence.PersistentDataObject;
import org.apache.wsrp4j.persistence.PersistentHandler;
import org.apache.wsrp4j.persistence.xml.PersistentDataObjectXML;
import org.apache.wsrp4j.persistence.xml.PersistentInformationXML;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;

public class PersistentHandlerImpl
implements PersistentHandler {
    private static PersistentHandler _persistentHandler = null;
    private static HashMap _filenameMap = new HashMap();
    private Logger logger = LogManager.getLogManager().getLogger(this.getClass());

    public static PersistentHandler create() {
        if (_persistentHandler == null) {
            _persistentHandler = new PersistentHandlerImpl();
        }
        return _persistentHandler;
    }

    private PersistentHandlerImpl() {
    }

    public void store(PersistentDataObject persistentDataObject) throws WSRPException {
        String MN = "store";
        if (this.logger.isLogging(60)) {
            this.logger.entry(60, MN);
        }
        Mapping mapping = null;
        Marshaller marshaller = null;
        FileWriter fileWriter = null;
        String filename = null;
        try {
            PersistentInformationXML persistentInformation = (PersistentInformationXML)persistentDataObject.getPersistentInformation();
            Object o = persistentDataObject.getLastElement();
            int hashCode = o.hashCode();
            String code = new Integer(hashCode).toString();
            filename = (String)_filenameMap.get(code);
            if (filename == null) {
                persistentInformation.updateFileName(code);
                filename = persistentInformation.getFilename();
                _filenameMap.put(code, filename);
            }
            File file = new File(filename);
            if (this.logger.isLogging(50)) {
                this.logger.text(50, MN, "Filename for store = " + filename + "with code = " + code);
            }
            fileWriter = new FileWriter(file);
            if (persistentInformation.getMappingFileName() != null) {
                mapping = new Mapping();
                mapping.loadMapping(persistentInformation.getMappingFileName());
                marshaller = new Marshaller((Writer)fileWriter);
                marshaller.setMapping(mapping);
            }
            ((PersistentDataObjectXML)persistentDataObject).marshalFile(fileWriter, marshaller);
            fileWriter.close();
        }
        catch (Exception e) {
            WSRPXHelper.throwX(this.logger, 10, MN, 1000, e);
        }
        if (this.logger.isLogging(60)) {
            this.logger.exit(60, MN);
        }
    }

    public PersistentDataObject restore(PersistentDataObject persistentDataObject) throws WSRPException {
        String MN;
        block8: {
            MN = "restore";
            if (this.logger.isLogging(60)) {
                this.logger.entry(60, MN);
            }
            Mapping mapping = null;
            Unmarshaller unmarshaller = null;
            try {
                File file;
                PersistentInformationXML persistentInformation = (PersistentInformationXML)persistentDataObject.getPersistentInformation();
                if (persistentInformation.getMappingFileName() != null) {
                    mapping = new Mapping();
                    mapping.loadMapping(persistentInformation.getMappingFileName());
                    unmarshaller = new Unmarshaller(mapping);
                }
                if (!(file = new File(persistentInformation.getFilename())).isFile()) break block8;
                FileReader fileReader = new FileReader(file);
                try {
                    ((PersistentDataObjectXML)persistentDataObject).unMarshalFile(fileReader, unmarshaller);
                    fileReader.close();
                    Object o = persistentDataObject.getLastElement();
                    int hashCode = o.hashCode();
                    String code = new Integer(hashCode).toString();
                    _filenameMap.put(code, file.getAbsolutePath());
                    if (this.logger.isLogging(50)) {
                        this.logger.text(50, MN, "File " + file.getAbsolutePath() + " added with hashCode = " + code);
                    }
                }
                catch (Exception e) {
                    WSRPXHelper.throwX(this.logger, 10, MN, 1001, e);
                }
            }
            catch (Exception e) {
                WSRPXHelper.throwX(this.logger, 10, MN, 1001, e);
            }
        }
        if (this.logger.isLogging(60)) {
            this.logger.exit(60, MN);
        }
        return persistentDataObject;
    }

    public PersistentDataObject restoreMultiple(PersistentDataObject persistentDataObject) throws WSRPException {
        String MN = "restoreMultiple";
        if (this.logger.isLogging(60)) {
            this.logger.entry(60, MN);
        }
        Mapping mapping = null;
        Unmarshaller unmarshaller = null;
        try {
            File file;
            PersistentInformationXML persistentInformation = (PersistentInformationXML)persistentDataObject.getPersistentInformation();
            if (persistentInformation.getMappingFileName() != null) {
                mapping = new Mapping();
                mapping.loadMapping(persistentInformation.getMappingFileName());
                unmarshaller = new Unmarshaller(mapping);
            }
            if ((file = new File(persistentInformation.getStoreDirectory())).exists()) {
                File[] files = file.listFiles();
                for (int x = 0; x < files.length; ++x) {
                    String currentFileName;
                    if (!files[x].isFile() || !(currentFileName = files[x].getName()).endsWith(persistentInformation.getExtension()) || !currentFileName.startsWith(persistentInformation.getFilenameStub())) continue;
                    try {
                        FileReader fileReader = new FileReader(files[x]);
                        ((PersistentDataObjectXML)persistentDataObject).unMarshalFile(fileReader, unmarshaller);
                        fileReader.close();
                        Object o = persistentDataObject.getLastElement();
                        int hashCode = o.hashCode();
                        String code = new Integer(hashCode).toString();
                        _filenameMap.put(code, files[x].getAbsolutePath());
                        if (!this.logger.isLogging(50)) continue;
                        this.logger.text(50, MN, "File " + files[x].getAbsolutePath() + " added with hashCode = " + code);
                        continue;
                    }
                    catch (Exception e) {
                        WSRPXHelper.throwX(this.logger, 10, MN, 1001, e);
                    }
                }
            }
        }
        catch (Exception e) {
            WSRPXHelper.throwX(this.logger, 10, MN, 1001, e);
        }
        if (this.logger.isLogging(60)) {
            this.logger.exit(60, MN);
        }
        return persistentDataObject;
    }

    public void delete(PersistentDataObject persistentDataObject) {
        String MN = "delete";
        if (this.logger.isLogging(60)) {
            this.logger.entry(60, MN);
        }
        Object o = persistentDataObject.getLastElement();
        int hashCode = o.hashCode();
        String code = new Integer(hashCode).toString();
        String filename = (String)_filenameMap.get(code);
        _filenameMap.remove(code);
        File file = new File(filename);
        if (file.exists()) {
            file.delete();
            if (this.logger.isLogging(50)) {
                this.logger.text(50, MN, "Persistent file: " + filename + "deleted.");
            }
        } else if (this.logger.isLogging(50)) {
            this.logger.text(50, MN, "Try to delete persistent file: " + filename + ". Not found!");
        }
        if (this.logger.isLogging(60)) {
            this.logger.exit(60, MN);
        }
    }
}

