/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsrp4j.persistence.xml.driver;

import java.io.File;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import oasis.names.tc.wsrp.v1.types.PortletDescription;
import org.apache.axis.AxisEngine;
import org.apache.axis.MessageContext;
import org.apache.axis.transport.http.HTTPConstants;
import org.apache.wsrp4j.consumer.driver.ProducerImpl;
import org.apache.wsrp4j.consumer.driver.UserImpl;
import org.apache.wsrp4j.consumer.driver.WSRPPortletImpl;
import org.apache.wsrp4j.log.LogManager;
import org.apache.wsrp4j.log.Logger;
import org.apache.wsrp4j.persistence.PersistentInformation;
import org.apache.wsrp4j.persistence.driver.WSRPServiceDescription;
import org.apache.wsrp4j.persistence.xml.ServerPersistentInformationProvider;
import org.apache.wsrp4j.persistence.xml.driver.ConsumerConfiguredPortletList;
import org.apache.wsrp4j.persistence.xml.driver.ConsumerPortletRegistrationList;
import org.apache.wsrp4j.persistence.xml.driver.PersistentInformationImpl;
import org.apache.wsrp4j.persistence.xml.driver.PortletDescriptionList;
import org.apache.wsrp4j.persistence.xml.driver.PortletList;
import org.apache.wsrp4j.persistence.xml.driver.ProducerList;
import org.apache.wsrp4j.persistence.xml.driver.RegistrationList;
import org.apache.wsrp4j.persistence.xml.driver.ServiceDescriptionList;
import org.apache.wsrp4j.persistence.xml.driver.UserList;
import org.apache.wsrp4j.producer.driver.RegistrationImpl;
import org.apache.wsrp4j.producer.provider.driver.ConsumerConfiguredPortletImpl;
import org.apache.wsrp4j.producer.provider.driver.ConsumerPortletRegistrationImpl;

public class ServerPersistentInformationProviderImpl
implements ServerPersistentInformationProvider {
    private ServerPersistentInformationProvider _persistentInfoProvider;
    private Logger logger;
    private static final String DESCRIPTIONS = "descriptions";
    private static final String PORTLETS = "portlets";
    private static final String PORTLETSTATES = "portletstates";
    private static final String REGISTRIES = "registries";
    private static final String USERS = "users";
    private static final String PRODUCERS = "producers";
    private static final String USER_MAPPING = "UserMapping";
    private static final String PRODUCER_MAPPING = "ProducerMapping";
    private static final String PORTLET_MAPPING = "PortletMapping";
    private static final String SERVICE_DESCRIPTION_MAPPING = "ServiceDescriptionMapping";
    private static final String REGISTRY_MAPPING = "RegistryMapping";
    private static final String PLUTO_PORTLET_MAPPING = "PlutoPortletMapping";
    private static final String SIMPLE_PORTLET_MAPPING = "SimplePortletMapping";
    private static final String PORTLET_STATE_MAPPING = "PortletStateMapping";
    private static String ROOT_DIR = null;
    private static String FILE_EXTENSION = ".xml";
    private static String PERSISTENT_DIR = "persistence";
    private static String SEPARATOR = "@";

    public static ServerPersistentInformationProvider create() {
        return new ServerPersistentInformationProviderImpl();
    }

    public static ServerPersistentInformationProvider create(String offsetPath) {
        return new ServerPersistentInformationProviderImpl(offsetPath);
    }

    private ServerPersistentInformationProviderImpl() {
        block5: {
            this._persistentInfoProvider = null;
            this.logger = LogManager.getLogManager().getLogger(this.getClass());
            this.logger.entry(60, "Constructor");
            try {
                if (ROOT_DIR != null) break block5;
                String path = null;
                try {
                    MessageContext msgContext = AxisEngine.getCurrentMessageContext();
                    HttpServlet servlet = (HttpServlet)msgContext.getProperty(HTTPConstants.MC_HTTP_SERVLET);
                    ServletContext servletContext = servlet.getServletContext();
                    path = servletContext.getRealPath("/WEB-INF") + File.separator;
                    if (this.logger.isLogging(50)) {
                        this.logger.text(50, "Constructor", "Current path of servletContext = " + path);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ROOT_DIR = path == null ? PERSISTENT_DIR : path + PERSISTENT_DIR;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.logger.exit(60, "Constructor");
    }

    public ServerPersistentInformationProviderImpl(String offsetPath) {
        this._persistentInfoProvider = null;
        this.logger = LogManager.getLogManager().getLogger(this.getClass());
        this.logger.entry(60, "Constructor");
        try {
            if (ROOT_DIR == null) {
                ROOT_DIR = offsetPath + File.separator + PERSISTENT_DIR;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.logger.exit(60, "Constructor");
    }

    public String getStoreDirectory(String subDirectory) {
        return ROOT_DIR + File.separator + subDirectory;
    }

    public void makeStoreSubDir(String subDirectory) {
        File file = new File(ROOT_DIR + File.separator + subDirectory);
        if (!file.exists()) {
            file.mkdir();
        }
    }

    public String getMappingFile(String mappingBaseName) {
        String mappingFile = new String(ROOT_DIR + File.separator + mappingBaseName + FILE_EXTENSION);
        return mappingFile;
    }

    public PersistentInformation getPersistentInformation(ServiceDescriptionList serviceDescriptionList) {
        this.logger.entry(60, "getPersistentInformation");
        PersistentInformationImpl persistentInfo = null;
        if (serviceDescriptionList != null) {
            persistentInfo = new PersistentInformationImpl();
            persistentInfo.setStoreDirectory(this.getStoreDirectory(DESCRIPTIONS));
            persistentInfo.setMappingFileName(this.getMappingFile(SERVICE_DESCRIPTION_MAPPING));
            WSRPServiceDescription serviceDescription = new WSRPServiceDescription();
            persistentInfo.setFilenameStub(serviceDescription.getClass().getName());
            persistentInfo.setFilename(persistentInfo.getStoreDirectory() + File.separator + serviceDescription.getClass().getName() + FILE_EXTENSION);
            persistentInfo.setExtension(FILE_EXTENSION);
            persistentInfo.setSeparator(SEPARATOR);
            serviceDescriptionList.setPersistentInformation(persistentInfo);
            this.makeStoreSubDir(DESCRIPTIONS);
        }
        this.logger.exit(60, "getPersistentInformation");
        return persistentInfo;
    }

    public PersistentInformation getPersistentInformation(PortletDescriptionList portletDescriptionList) {
        this.logger.entry(60, "getPersistentInformation");
        PersistentInformationImpl persistentInfo = null;
        if (portletDescriptionList != null) {
            persistentInfo = new PersistentInformationImpl();
            persistentInfo.setStoreDirectory(this.getStoreDirectory(DESCRIPTIONS));
            persistentInfo.setMappingFileName(null);
            PortletDescription portletDescription = new PortletDescription();
            persistentInfo.setFilenameStub(portletDescription.getClass().getName());
            persistentInfo.setFilename(null);
            persistentInfo.setExtension(FILE_EXTENSION);
            persistentInfo.setSeparator(SEPARATOR);
            portletDescriptionList.setPersistentInformation(persistentInfo);
            this.makeStoreSubDir(DESCRIPTIONS);
        }
        this.logger.exit(60, "getPersistentInformation");
        return persistentInfo;
    }

    public PersistentInformation getPersistentInformation(RegistrationList registrationList) {
        this.logger.entry(60, "getPersistentInformation");
        PersistentInformationImpl persistentInfo = null;
        if (registrationList != null) {
            persistentInfo = new PersistentInformationImpl();
            persistentInfo.setStoreDirectory(this.getStoreDirectory(REGISTRIES));
            persistentInfo.setMappingFileName(this.getMappingFile(REGISTRY_MAPPING));
            RegistrationImpl registration = new RegistrationImpl();
            persistentInfo.setFilenameStub(registration.getClass().getName());
            persistentInfo.setFilename(null);
            persistentInfo.setExtension(FILE_EXTENSION);
            persistentInfo.setSeparator(SEPARATOR);
            registrationList.setPersistentInformation(persistentInfo);
            this.makeStoreSubDir(REGISTRIES);
        }
        this.logger.exit(60, "getPersistentInformation");
        return persistentInfo;
    }

    public PersistentInformation getPersistentInformation(ConsumerConfiguredPortletList cceList) {
        this.logger.entry(60, "getPersistentInformation");
        PersistentInformationImpl persistentInfo = null;
        if (cceList != null) {
            persistentInfo = new PersistentInformationImpl();
            persistentInfo.setStoreDirectory(this.getStoreDirectory(PORTLETS));
            persistentInfo.setMappingFileName(this.getMappingFile(PLUTO_PORTLET_MAPPING));
            ConsumerConfiguredPortletImpl cce = new ConsumerConfiguredPortletImpl();
            persistentInfo.setFilenameStub(cce.getClass().getName());
            persistentInfo.setFilename(null);
            persistentInfo.setExtension(FILE_EXTENSION);
            persistentInfo.setSeparator(SEPARATOR);
            cceList.setPersistentInformation(persistentInfo);
            this.makeStoreSubDir(PORTLETS);
        }
        this.logger.exit(60, "getPersistentInformation");
        return persistentInfo;
    }

    public PersistentInformation getPersistentInformation(ProducerList producerList) {
        this.logger.entry(60, "getPersistentInformation");
        PersistentInformationImpl persistentInfo = null;
        if (producerList != null) {
            persistentInfo = new PersistentInformationImpl();
            persistentInfo.setStoreDirectory(this.getStoreDirectory(PRODUCERS));
            persistentInfo.setMappingFileName(this.getMappingFile(PRODUCER_MAPPING));
            ProducerImpl producer = new ProducerImpl();
            persistentInfo.setFilenameStub(producer.getClass().getName());
            persistentInfo.setFilename(null);
            persistentInfo.setExtension(FILE_EXTENSION);
            persistentInfo.setSeparator(SEPARATOR);
            producerList.setPersistentInformation(persistentInfo);
            this.makeStoreSubDir(PRODUCERS);
        }
        this.logger.exit(60, "getPersistentInformation");
        return persistentInfo;
    }

    public PersistentInformation getPersistentInformation(UserList userList) {
        this.logger.entry(60, "getPersistentInformation");
        PersistentInformationImpl persistentInfo = null;
        if (userList != null) {
            persistentInfo = new PersistentInformationImpl();
            persistentInfo.setStoreDirectory(this.getStoreDirectory(USERS));
            persistentInfo.setMappingFileName(this.getMappingFile(USER_MAPPING));
            UserImpl user = new UserImpl();
            persistentInfo.setFilenameStub(user.getClass().getName());
            persistentInfo.setFilename(null);
            persistentInfo.setExtension(FILE_EXTENSION);
            persistentInfo.setSeparator(SEPARATOR);
            userList.setPersistentInformation(persistentInfo);
            this.makeStoreSubDir(USERS);
        }
        this.logger.exit(60, "getPersistentInformation");
        return persistentInfo;
    }

    public PersistentInformation getPersistentInformation(PortletList portletList) {
        this.logger.entry(60, "getPersistentInformation");
        PersistentInformationImpl persistentInfo = null;
        if (portletList != null) {
            persistentInfo = new PersistentInformationImpl();
            persistentInfo.setStoreDirectory(this.getStoreDirectory(PORTLETS));
            persistentInfo.setMappingFileName(this.getMappingFile(PORTLET_MAPPING));
            WSRPPortletImpl portlet = new WSRPPortletImpl();
            persistentInfo.setFilenameStub(portlet.getClass().getName());
            persistentInfo.setFilename(null);
            persistentInfo.setExtension(FILE_EXTENSION);
            persistentInfo.setSeparator(SEPARATOR);
            portletList.setPersistentInformation(persistentInfo);
            this.makeStoreSubDir(PORTLETS);
        }
        this.logger.exit(60, "getPersistentInformation");
        return persistentInfo;
    }

    public PersistentInformation getPersistentInformation(ConsumerPortletRegistrationList regList) {
        this.logger.entry(60, "getPersistentInformation");
        PersistentInformationImpl persistentInfo = null;
        if (regList != null) {
            persistentInfo = new PersistentInformationImpl();
            persistentInfo.setStoreDirectory(this.getStoreDirectory(REGISTRIES));
            persistentInfo.setMappingFileName(null);
            ConsumerPortletRegistrationImpl cpr = new ConsumerPortletRegistrationImpl();
            persistentInfo.setFilenameStub(cpr.getClass().getName());
            persistentInfo.setFilename(null);
            persistentInfo.setExtension(FILE_EXTENSION);
            persistentInfo.setSeparator(SEPARATOR);
            regList.setPersistentInformation(persistentInfo);
            this.makeStoreSubDir(REGISTRIES);
        }
        this.logger.exit(60, "getPersistentInformation");
        return persistentInfo;
    }
}

