/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsrp4j.util;

import java.util.ArrayList;
import java.util.Locale;

public class LocaleHelper {
    private static final String LOCALE_SEPARATOR = "-";

    public static String getLanguageCode(String locale) {
        String code = "";
        int pos = locale.indexOf(LOCALE_SEPARATOR);
        if (pos != -1) {
            code = locale.substring(0, pos);
        } else if (locale.length() == 2) {
            code = locale;
        } else {
            pos = locale.indexOf("_");
            if (pos != -1) {
                code = locale.substring(0, pos);
            }
        }
        return code;
    }

    public static String getCountryCode(String locale) {
        String code = "";
        int pos = locale.indexOf(LOCALE_SEPARATOR);
        if (pos != -1) {
            code = locale.substring(pos + 1, locale.length());
        } else {
            pos = locale.indexOf("_");
            if (pos != -1) {
                code = locale.substring(0, pos);
            }
        }
        return code;
    }

    public static Locale getLocale(String locale) {
        return new Locale(LocaleHelper.getLanguageCode(locale), LocaleHelper.getCountryCode(locale));
    }

    public static String getWsrpLocale(Locale locale) {
        if (locale == null) {
            return null;
        }
        String lang = locale.getLanguage();
        String country = locale.getCountry();
        return lang + (country != null && !country.equals("") ? LOCALE_SEPARATOR + country : "");
    }

    public static Locale[] getLocales(String[] locales) {
        ArrayList<Locale> list = new ArrayList<Locale>();
        for (int i = 0; i < locales.length; ++i) {
            list.add(LocaleHelper.getLocale(locales[i]));
        }
        Locale[] typedArray = new Locale[locales.length];
        return list.toArray(typedArray);
    }
}

