/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsrp4j.util;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.encoding.SerializationContextImpl;
import org.apache.axis.encoding.Serializer;
import org.apache.axis.encoding.TypeMapping;
import org.apache.axis.encoding.TypeMappingRegistry;
import org.apache.axis.message.MessageElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;

public class MessageElementHelper
implements SerializationContext {
    StringWriter writer = null;
    SerializationContextImpl serializer = null;

    public static MessageElement create(Node value) {
        MessageElement result = null;
        try {
            if (Class.forName("org.w3c.dom.Element").isAssignableFrom(value.getClass())) {
                result = new MessageElement((Element)value);
                return result;
            }
            throw new Exception("Trying to create a MessageElement with something other than Element");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return result;
        }
    }

    public String getAsString(MessageElement msg) {
        try {
            this.writer = new StringWriter();
            this.serializer = new SerializationContextImpl((Writer)this.writer);
            this.serializer.setSendDecl(false);
            msg.output((SerializationContext)this);
            this.writer.flush();
            return this.writer.toString();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public MessageElement clone(MessageElement msg) {
        try {
            String oldValue = this.getAsString(msg);
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new StringReader(oldValue)));
            Element root = doc.getDocumentElement();
            MessageElement newMsg = MessageElementHelper.create(root);
            return newMsg;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public void serialize(QName elemQName, Attributes attributes, Object value) throws IOException {
        if (this.serializer == null) {
            throw new IOException("Out of sequence error -- no serializer");
        }
        this.serializer.serialize(elemQName, attributes, value);
    }

    public void serialize(QName elemQName, Attributes attributes, Object value, QName xmlType, boolean sendNull, Boolean sendType) throws IOException {
        if (this.serializer == null) {
            throw new IOException("Out of sequence error -- no serializer");
        }
        this.serializer.serialize(elemQName, attributes, value, xmlType, sendNull, sendType);
    }

    public Attributes setTypeAttribute(Attributes attributes, QName type) {
        if (this.serializer != null) {
            return this.serializer.setTypeAttribute(attributes, type);
        }
        return null;
    }

    public Serializer getSerializerForJavaType(Class javaType) {
        if (this.serializer != null) {
            return this.serializer.getSerializerForJavaType(javaType);
        }
        return null;
    }

    public boolean getPretty() {
        if (this.serializer != null) {
            return this.serializer.getPretty();
        }
        return false;
    }

    public void setPretty(boolean pretty) {
        if (this.serializer != null) {
            this.serializer.setPretty(pretty);
        }
    }

    public void setDoMultiRefs(boolean shouldDo) {
        if (this.serializer != null) {
            this.serializer.setDoMultiRefs(shouldDo);
        }
    }

    public void setSendDecl(boolean sendDecl) {
        if (this.serializer != null) {
            this.serializer.setSendDecl(sendDecl);
        }
    }

    public boolean shouldSendXSIType() {
        if (this.serializer != null) {
            return this.serializer.shouldSendXSIType();
        }
        return false;
    }

    public TypeMapping getTypeMapping() {
        if (this.serializer != null) {
            return this.serializer.getTypeMapping();
        }
        return null;
    }

    public TypeMappingRegistry getTypeMappingRegistry() {
        if (this.serializer != null) {
            return this.serializer.getTypeMappingRegistry();
        }
        return null;
    }

    public String getPrefixForURI(String uri) {
        if (this.serializer != null) {
            return this.serializer.getPrefixForURI(uri);
        }
        return null;
    }

    public String getPrefixForURI(String uri, String defaultPrefix) {
        if (this.serializer != null) {
            return this.serializer.getPrefixForURI(uri, defaultPrefix);
        }
        return null;
    }

    public void registerPrefixForURI(String prefix, String uri) {
        if (this.serializer != null) {
            this.serializer.registerPrefixForURI(prefix, uri);
        }
    }

    public Message getCurrentMessage() {
        if (this.serializer != null) {
            return this.serializer.getCurrentMessage();
        }
        return null;
    }

    public MessageContext getMessageContext() {
        if (this.serializer != null) {
            return this.serializer.getMessageContext();
        }
        return null;
    }

    public String qName2String(QName qName) {
        if (this.serializer != null) {
            return this.serializer.qName2String(qName);
        }
        return null;
    }

    public String attributeQName2String(QName qName) {
        if (this.serializer != null) {
            return this.serializer.attributeQName2String(qName);
        }
        return null;
    }

    public QName getQNameForClass(Class cls) {
        if (this.serializer != null) {
            return this.serializer.getQNameForClass(cls);
        }
        return null;
    }

    public boolean isPrimitive(Object value) {
        if (this.serializer != null) {
            return this.serializer.isPrimitive(value);
        }
        return false;
    }

    public void outputMultiRefs() throws IOException {
        if (this.serializer == null) {
            throw new IOException("Out of sequence error -- no serializer");
        }
        this.serializer.outputMultiRefs();
    }

    public void startElement(QName qName, Attributes attributes) throws IOException {
        if (this.serializer == null) {
            throw new IOException("Out of sequence error -- no serializer");
        }
        this.serializer.startElement(qName, attributes);
    }

    public void endElement() throws IOException {
        if (this.serializer == null) {
            throw new IOException("Out of sequence error -- no serializer");
        }
        this.serializer.endElement();
    }

    public void writeChars(char[] p1, int p2, int p3) throws IOException {
        if (this.serializer == null) {
            throw new IOException("Out of sequence error -- no serializer");
        }
        this.serializer.writeChars(p1, p2, p3);
    }

    public void writeString(String string) throws IOException {
        if (this.serializer == null) {
            throw new IOException("Out of sequence error -- no serializer");
        }
        this.serializer.writeString(string);
    }

    public void writeSafeString(String string) throws IOException {
        if (this.serializer == null) {
            throw new IOException("Out of sequence error -- no serializer");
        }
        this.serializer.writeSafeString(string);
    }

    public void writeDOMElement(Element el) throws IOException {
        if (this.serializer == null) {
            throw new IOException("Out of sequence error -- no serializer");
        }
        this.serializer.writeDOMElement(el);
    }

    public String getValueAsString(Object value, QName xmlType) throws IOException {
        if (this.serializer == null) {
            throw new IOException("Out of sequence error -- no serializer");
        }
        this.serializer.getValueAsString(value, xmlType);
        return null;
    }

    public QName getCurrentXMLType() {
        if (this.serializer != null) {
            return this.serializer.getCurrentXMLType();
        }
        return null;
    }

    public boolean getDoMultiRefs() {
        if (this.serializer != null) {
            return this.serializer.getDoMultiRefs();
        }
        return false;
    }
}

