/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsrp4j.util;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oasis.names.tc.wsrp.v1.types.ModelDescription;
import oasis.names.tc.wsrp.v1.types.Property;
import oasis.names.tc.wsrp.v1.types.PropertyDescription;
import oasis.names.tc.wsrp.v1.types.PropertyList;
import oasis.names.tc.wsrp.v1.types.ResetProperty;
import org.apache.axis.message.MessageElement;
import org.apache.wsrp4j.util.InvalidXMLStringException;
import org.apache.wsrp4j.util.MessageElementHelper;
import org.apache.xerces.jaxp.DocumentBuilderFactoryImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class PropertyListHelper {
    DocumentBuilderFactory factory = null;
    DocumentBuilder docBuilder = null;
    Document doc = null;

    public PropertyListHelper() {
        try {
            this.factory = new DocumentBuilderFactoryImpl();
            this.docBuilder = this.factory.newDocumentBuilder();
            this.doc = this.docBuilder.newDocument();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public PropertyList makeSample() {
        try {
            Property foo = new Property();
            Property bar = new Property();
            Property zot = new Property();
            foo.setName("foo");
            bar.setName("bar");
            zot.setName("zot");
            Element fooElement = this.doc.createElement("foo");
            Text fooText = this.doc.createTextNode("This some content for foo");
            fooElement.appendChild(fooText);
            MessageElement fooMsg = MessageElementHelper.create(fooElement);
            MessageElement[] fooMsgs = new MessageElement[]{fooMsg};
            foo.set_any(fooMsgs);
            Element barElement = this.doc.createElement("bar");
            Text barText = this.doc.createTextNode("This some content for bar");
            barElement.appendChild(barText);
            MessageElement barMsg = MessageElementHelper.create(barElement);
            MessageElement[] barMsgs = new MessageElement[]{barMsg};
            bar.set_any(barMsgs);
            Element zotElement = this.doc.createElement("zotBlock");
            zotElement.setAttribute("name", "zot");
            Text zotText = this.doc.createTextNode("This some content for zot");
            zotElement.appendChild(zotText);
            MessageElement zotMsg = MessageElementHelper.create(zotElement);
            MessageElement[] zotMsgs = new MessageElement[]{zotMsg};
            zot.set_any(zotMsgs);
            Property[] propertyArray = new Property[]{foo, bar, zot};
            PropertyList propertyList = new PropertyList();
            propertyList.setProperties(propertyArray);
            propertyList.setResetProperties(new ResetProperty[0]);
            return propertyList;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public void writePropertyAsString(StringWriter sw, Property prop) {
        if (prop != null) {
            sw.write("<Property name=\"" + prop.getName() + "\">");
            MessageElement[] msgs = prop.get_any();
            if (msgs != null) {
                for (int jj = 0; jj < msgs.length; ++jj) {
                    MessageElementHelper helper = new MessageElementHelper();
                    sw.write(helper.getAsString(msgs[jj]));
                }
            }
            sw.write("</Property>\n");
        }
    }

    public String convertToXMLString(PropertyList plist) {
        Property[] props;
        if (plist != null && (props = plist.getProperties()) != null) {
            StringWriter sw = new StringWriter();
            sw.write("<PropertyList>");
            for (int ii = 0; ii < props.length; ++ii) {
                this.writePropertyAsString(sw, props[ii]);
            }
            sw.write("</PropertyList>");
            sw.flush();
            return sw.toString();
        }
        return null;
    }

    public String convertToXMLString(ModelDescription md) {
        StringWriter sw = new StringWriter();
        PropertyDescription[] props = md.getPropertyDescriptions();
        sw.write("<ModelDescription>");
        for (int ii = 0; ii < props.length; ++ii) {
            this.writePropertyDescriptionAsString(sw, props[ii]);
        }
        sw.write("</ModelDescription>");
        sw.flush();
        return sw.toString();
    }

    private String quote(String ss) {
        return new String("\"" + ss + "\"");
    }

    private void writePropertyDescriptionAsString(StringWriter sw, PropertyDescription prop) {
    }

    public String getValue(PropertyList plist, String propName) {
        Property[] props = plist.getProperties();
        StringWriter sw = new StringWriter();
        try {
            for (int ii = 0; ii < props.length; ++ii) {
                if (!props[ii].getName().equals(propName)) continue;
                this.writePropertyAsString(sw, props[ii]);
                sw.flush();
                sw.close();
                return sw.toString();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public String getValueOfChild(PropertyList plist, String propName) {
        Property[] props;
        if (plist != null && (props = plist.getProperties()) != null) {
            StringWriter sw = new StringWriter();
            try {
                for (int ii = 0; ii < props.length; ++ii) {
                    if (!props[ii].getName().equals(propName)) continue;
                    MessageElement[] msgs = props[ii].get_any();
                    if (msgs != null) {
                        for (int jj = 0; jj < msgs.length; ++jj) {
                            MessageElementHelper helper = new MessageElementHelper();
                            sw.write(helper.getAsString(msgs[jj]));
                        }
                    }
                    sw.flush();
                    sw.close();
                    Document doc = this.docBuilder.parse(new InputSource(new StringReader(sw.toString())));
                    Element element = doc.getDocumentElement();
                    Node node = element.getFirstChild();
                    if (node != null) {
                        return node.getNodeValue();
                    }
                    return null;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    public Property updateProperty(Property prop, String xmlStringValue) throws InvalidXMLStringException {
        Document doc = this.docBuilder.newDocument();
        Element element = doc.createElement(prop.getName());
        Text node = doc.createTextNode(xmlStringValue);
        element.appendChild(node);
        MessageElement msg = MessageElementHelper.create(element);
        MessageElement[] msgs = new MessageElement[]{msg};
        prop.set_any(msgs);
        return prop;
    }
}

