/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsrp4j.consumer.portlet.impl;

import java.io.File;
import java.util.Iterator;
import java.util.Map;
import javax.portlet.PortletConfig;
import javax.portlet.PortletMode;
import javax.portlet.PortletURL;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import org.apache.wsrp4j.consumer.URLGenerator;

public class URLGeneratorImpl
implements URLGenerator {
    private static URLGeneratorImpl instance = null;
    private RenderResponse renderResponse = null;
    private Map consumerParameters = null;
    private static String rpURL = null;
    private static String RESOURCE_PROXY = "/ResourceProxy";

    public static URLGenerator getInstance(RenderResponse response, PortletConfig config) {
        if (response == null) {
            throw new IllegalArgumentException("response must not be null");
        }
        if (config == null) {
            throw new IllegalArgumentException("config must not be null");
        }
        if (instance == null) {
            instance = new URLGeneratorImpl(response);
        } else {
            instance.setRenderResponse(response);
        }
        URLGeneratorImpl.setResourceProxyURL(config);
        return instance;
    }

    private static void setResourceProxyURL(PortletConfig config) {
        String fullPath = config.getPortletContext().getRealPath("");
        int i = fullPath.lastIndexOf(File.separatorChar);
        rpURL = "/";
        rpURL = rpURL.concat(fullPath.substring(i + 1));
        rpURL = rpURL.concat(RESOURCE_PROXY);
    }

    private URLGeneratorImpl(RenderResponse response) {
        this.renderResponse = response;
    }

    public void setRenderResponse(RenderResponse response) {
        if (response != null) {
            this.renderResponse = response;
        }
    }

    public void setConsumerParameters(Map consumerParameters) {
        if (consumerParameters != null) {
            this.consumerParameters = consumerParameters;
        }
    }

    public String getBlockingActionURL(Map params) {
        PortletURL url = this.renderResponse.createActionURL();
        if (params != null) {
            Iterator iter = params.keySet().iterator();
            String paramName = "";
            String paramValue = "";
            while (iter.hasNext()) {
                paramName = (String)iter.next();
                if (paramName.equalsIgnoreCase("wsrp-windowState")) {
                    paramValue = (String)params.get(paramName);
                    if (paramValue == null) continue;
                    this.setWindowState(url, paramValue);
                    continue;
                }
                if (paramName.equalsIgnoreCase("wsrp-mode")) {
                    paramValue = (String)params.get(paramName);
                    if (paramValue == null) continue;
                    this.setPortletMode(url, paramValue);
                    continue;
                }
                paramValue = (String)params.get(paramName);
                if (paramValue == null) continue;
                url.setParameter(paramName, paramValue);
            }
        }
        if (this.consumerParameters != null) {
            Iterator iter2 = this.consumerParameters.keySet().iterator();
            String name = null;
            String value = null;
            while (iter2.hasNext()) {
                value = (String)this.consumerParameters.get(name);
                if (value == null) continue;
                url.setParameter(name, value);
            }
        }
        return url.toString();
    }

    public String getRenderURL(Map params) {
        PortletURL url = this.renderResponse.createRenderURL();
        if (params != null) {
            Iterator iter = params.keySet().iterator();
            String paramName = "";
            String paramValue = "";
            while (iter.hasNext()) {
                paramName = (String)iter.next();
                if (paramName.equalsIgnoreCase("wsrp-windowState")) {
                    paramValue = (String)params.get(paramName);
                    if (paramValue == null) continue;
                    this.setWindowState(url, paramValue);
                    continue;
                }
                if (paramName.equalsIgnoreCase("wsrp-mode")) {
                    paramValue = (String)params.get(paramName);
                    if (paramValue == null) continue;
                    this.setPortletMode(url, paramValue);
                    continue;
                }
                if (paramName.equalsIgnoreCase("wsrp-urlType") || (paramValue = (String)params.get(paramName)) == null) continue;
                url.setParameter(paramName, paramValue);
            }
        }
        if (this.consumerParameters != null) {
            Iterator iter2 = this.consumerParameters.keySet().iterator();
            String name = null;
            String value = null;
            while (iter2.hasNext()) {
                value = (String)this.consumerParameters.get(name);
                if (value == null) continue;
                url.setParameter(name, value);
            }
        }
        return url.toString();
    }

    public String getResourceURL(Map params) {
        String resourceUrl = this.renderResponse.encodeURL(rpURL);
        if (resourceUrl == null) {
            return "Error";
        }
        StringBuffer url = new StringBuffer(resourceUrl);
        if (params != null) {
            String paramValue = null;
            paramValue = (String)params.get("wsrp-url");
            if (paramValue != null) {
                url.append("?");
                url.append("wsrp-url");
                url.append("=");
                url.append(paramValue);
            }
        }
        return url.toString();
    }

    public String getNamespacedToken(String token) {
        return this.renderResponse.getNamespace();
    }

    private void setWindowState(PortletURL url, String windowState) {
        try {
            if (windowState.equalsIgnoreCase("wsrp:maximized")) {
                url.setWindowState(WindowState.MAXIMIZED);
            } else if (windowState.equalsIgnoreCase("wsrp:minimized")) {
                url.setWindowState(WindowState.MINIMIZED);
            } else if (windowState.equalsIgnoreCase("wsrp:normal")) {
                url.setWindowState(WindowState.NORMAL);
            } else if (windowState.equalsIgnoreCase("wsrp:solo")) {
                url.setWindowState(WindowState.MAXIMIZED);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setPortletMode(PortletURL url, String mode) {
        try {
            if (mode.equalsIgnoreCase("wsrp:edit")) {
                url.setPortletMode(PortletMode.EDIT);
            } else if (mode.equalsIgnoreCase("wsrp:view")) {
                url.setPortletMode(PortletMode.VIEW);
            } else if (mode.equalsIgnoreCase("wsrp:help")) {
                url.setPortletMode(PortletMode.HELP);
            } else if (mode.equalsIgnoreCase("wsrp:preview")) {
                url.setPortletMode(PortletMode.VIEW);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

