/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsrp4j.consumer.portlet.impl;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.WindowState;
import oasis.names.tc.wsrp.v1.types.ClientData;
import oasis.names.tc.wsrp.v1.types.MarkupContext;
import oasis.names.tc.wsrp.v1.types.NamedString;
import oasis.names.tc.wsrp.v1.types.SessionContext;
import org.apache.pluto.core.CoreUtils;
import org.apache.pluto.om.portlet.ContentType;
import org.apache.pluto.om.portlet.ContentTypeSet;
import org.apache.pluto.om.window.PortletWindow;
import org.apache.pluto.util.NamespaceMapperAccess;
import org.apache.wsrp4j.consumer.InteractionRequest;
import org.apache.wsrp4j.consumer.MarkupRequest;
import org.apache.wsrp4j.consumer.PortletWindowSession;
import org.apache.wsrp4j.consumer.driver.GenericWSRPBaseRequestImpl;
import org.apache.wsrp4j.log.LogManager;
import org.apache.wsrp4j.log.Logger;
import org.apache.wsrp4j.util.AuthenticationInfoHelper;
import org.apache.wsrp4j.util.Constants;
import org.apache.wsrp4j.util.LocaleHelper;
import org.apache.wsrp4j.util.Modes;
import org.apache.wsrp4j.util.WindowStates;

public class WSRPRequestImpl
extends GenericWSRPBaseRequestImpl
implements InteractionRequest,
MarkupRequest {
    private final PortletRequest portletRequest;
    private final PortletWindowSession windowSession;
    private final PortletWindow portletWindow;
    private final String nameSpace;
    private final String userAuth;
    private NamedString[] formParameters = null;
    private String interactionState = null;
    private String currentMode = null;
    private String currentState = null;
    private String naviState = null;
    private String[] modes = null;
    private String[] locales = null;
    protected Logger logger = LogManager.getLogManager().getLogger(class$org$apache$wsrp4j$consumer$portlet$impl$WSRPRequestImpl == null ? (class$org$apache$wsrp4j$consumer$portlet$impl$WSRPRequestImpl = WSRPRequestImpl.class$("org.apache.wsrp4j.consumer.portlet.impl.WSRPRequestImpl")) : class$org$apache$wsrp4j$consumer$portlet$impl$WSRPRequestImpl);
    static /* synthetic */ Class class$org$apache$wsrp4j$consumer$portlet$impl$WSRPRequestImpl;

    public WSRPRequestImpl(PortletWindowSession windowSession, PortletRequest portletRequest) {
        this.windowSession = windowSession;
        this.portletRequest = portletRequest;
        this.portletWindow = CoreUtils.getInternalRequest((PortletRequest)portletRequest).getInternalPortletWindow();
        this.nameSpace = NamespaceMapperAccess.getNamespaceMapper().encode(this.portletWindow.getId(), "");
        this.userAuth = AuthenticationInfoHelper.getWsrpFromPortlet((String)portletRequest.getAuthType());
        this.integrateParameter();
    }

    public String getInteractionState() {
        return this.interactionState;
    }

    public NamedString[] getFormParameters() {
        return this.formParameters;
    }

    public MarkupContext getCachedMarkup() {
        if (this.windowSession == null) {
            return null;
        }
        return this.windowSession.getCachedMarkup();
    }

    public String getSessionID() {
        SessionContext sessionCtx;
        if (this.windowSession != null && (sessionCtx = this.windowSession.getPortletSession().getSessionContext()) != null) {
            return sessionCtx.getSessionID();
        }
        return null;
    }

    public String getPortletInstanceKey() {
        return this.portletWindow.getId().toString();
    }

    public String getNavigationalState() {
        return this.naviState;
    }

    public String getWindowState() {
        if (this.currentState == null) {
            WindowState portletWindowState = this.portletRequest.getWindowState();
            this.currentState = WindowStates.getWsrpStateFromJsrPortletState((WindowState)portletWindowState).toString();
        }
        return this.currentState;
    }

    public String getMode() {
        if (this.currentMode == null) {
            PortletMode portletMode = this.portletRequest.getPortletMode();
            this.currentMode = Modes.getWsrpModeFromJsrPortletMode((PortletMode)portletMode).toString();
        }
        return this.currentMode;
    }

    public ClientData getClientData() {
        return null;
    }

    public String[] getLocales() {
        if (this.locales == null) {
            Enumeration eLocales = this.portletRequest.getLocales();
            ArrayList<String> wsrpLocales = new ArrayList<String>();
            while (eLocales.hasMoreElements()) {
                Locale locale = (Locale)eLocales.nextElement();
                wsrpLocales.add(LocaleHelper.getWsrpLocale((Locale)locale));
            }
            this.locales = wsrpLocales.toArray(new String[0]);
        }
        return this.locales;
    }

    public String[] getModes() {
        String MN = "getModes()";
        if (this.logger.isLogging(60)) {
            this.logger.entry(60, "getModes()");
        }
        if (this.modes != null) {
            if (this.logger.isLogging(60)) {
                this.logger.exit(60, "getModes()");
            }
            return this.modes;
        }
        HashSet<String> result = new HashSet<String>();
        String[] mimeTypes = this.getMimeTypes();
        if (mimeTypes != null) {
            ContentTypeSet contentTypes = this.portletWindow.getPortletEntity().getPortletDefinition().getContentTypeSet();
            for (int i = 0; i < mimeTypes.length; ++i) {
                if (mimeTypes[i].equals("*")) {
                    Iterator it = contentTypes.iterator();
                    while (it.hasNext()) {
                        ContentType type = (ContentType)it.next();
                        Iterator modesIt = type.getPortletModes();
                        while (modesIt.hasNext()) {
                            PortletMode mode = (PortletMode)modesIt.next();
                            result.add(Modes.getWsrpModeFromJsrPortletMode((PortletMode)mode).toString());
                        }
                    }
                    break;
                }
                ContentType type = contentTypes.get(mimeTypes[i]);
                if (type == null) continue;
                Iterator modesIt = type.getPortletModes();
                while (modesIt.hasNext()) {
                    PortletMode mode = (PortletMode)modesIt.next();
                    result.add(Modes.getWsrpModeFromJsrPortletMode((PortletMode)mode).toString());
                }
            }
        }
        if (!result.isEmpty()) {
            this.modes = result.toArray(new String[0]);
        }
        if (this.logger.isLogging(60)) {
            this.logger.exit(60, "getModes()");
        }
        return this.modes;
    }

    public String[] getWindowStates() {
        return WindowStates.getWindowStatesAsStringArray();
    }

    public String[] getMimeTypes() {
        return null;
    }

    public String[] getCharacterEncodingSet() {
        return null;
    }

    public boolean isModeSupported(String wsrpMode) {
        if (wsrpMode == null) {
            throw new IllegalArgumentException("A mode must not be null");
        }
        return this.portletRequest.isPortletModeAllowed(Modes.getJsrPortletModeFromWsrpMode((Modes)Modes.fromString((String)wsrpMode)));
    }

    public boolean isWindowStateSupported(String wsrpWindowState) {
        if (wsrpWindowState == null) {
            throw new IllegalArgumentException("A window state must not be null");
        }
        return this.portletRequest.isWindowStateAllowed(WindowStates.getJsrPortletStateFromWsrpState((WindowStates)WindowStates.fromString((String)wsrpWindowState)));
    }

    public String getUserAuthentication() {
        return this.userAuth;
    }

    private void integrateParameter() {
        String MN = "integrateParameter()";
        if (this.logger.isLogging(60)) {
            this.logger.entry(60, "integrateParameter()");
        }
        ArrayList<NamedString> formParams = new ArrayList<NamedString>();
        Set paramKeysSet = this.portletRequest.getParameterMap().keySet();
        this.interactionState = this.portletRequest.getParameter("wsrp-interactionState");
        this.naviState = this.portletRequest.getParameter("wsrp-navigationalState");
        if (this.naviState == null) {
            this.naviState = this.portletRequest.getParameter("proxyportlet-updateResponse-navState");
        }
        Iterator paramKeys = paramKeysSet.iterator();
        while (paramKeys.hasNext()) {
            String[] values;
            String key = (String)paramKeys.next();
            if (Constants.isWsrpURLParam((String)key) || key.equals("proxyportlet-updateResponse-navState") || (values = this.portletRequest.getParameterValues(key)) == null) continue;
            for (int i = 0; i < values.length; ++i) {
                NamedString paramPair = new NamedString();
                paramPair.setName(key);
                paramPair.setValue(values[i]);
                formParams.add(paramPair);
            }
        }
        if (!formParams.isEmpty()) {
            this.formParameters = new NamedString[formParams.size()];
            formParams.toArray(this.formParameters);
        }
        if (this.logger.isLogging(60)) {
            this.logger.exit(60, "integrateParameter()");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

