/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsrp4j.consumer.driver;

import java.util.Iterator;
import org.apache.wsrp4j.consumer.Producer;
import org.apache.wsrp4j.consumer.driver.GenericProducerRegistryImpl;
import org.apache.wsrp4j.exception.WSRPException;
import org.apache.wsrp4j.persistence.PersistentDataObject;
import org.apache.wsrp4j.persistence.PersistentHandler;
import org.apache.wsrp4j.util.HandleGenerator;
import org.apache.wsrp4j.util.HandleGeneratorImpl;
import org.apache.wsrp4j.util.StateChangedEvent;
import org.apache.wsrp4j.util.StateChangedListener;
import org.apache.wsrp4j.util.StateChangedService;

public class GenericPersistentProducerRegistryImpl
extends GenericProducerRegistryImpl
implements StateChangedListener {
    protected PersistentDataObject persistentDataObject = null;
    protected PersistentHandler persistentHandler = null;
    private HandleGenerator handleGenerator = HandleGeneratorImpl.create();

    public void addProducer(Producer producer) {
        if (producer != null) {
            super.addProducer(producer);
            try {
                this.store(producer);
            }
            catch (WSRPException e) {
                super.removeProducer(producer.getID());
            }
            if (producer instanceof StateChangedService) {
                ((StateChangedService)producer).addListener((StateChangedListener)this);
            }
        }
    }

    public Producer removeProducer(String id) {
        if (id == null) {
            return null;
        }
        Producer producer = super.removeProducer(id);
        this.delete(producer);
        return producer;
    }

    public void removeAllProducers() {
        Iterator producers = this.getAllProducers();
        while (producers.hasNext()) {
            Producer producer = (Producer)producers.next();
            this.delete(producer);
        }
        super.removeAllProducers();
    }

    public void stateChanged(StateChangedEvent event) {
        try {
            Producer producer = (Producer)event.getSource();
            this.store(producer);
        }
        catch (Throwable t) {
            if (t instanceof ClassCastException) {
                // empty if block
            }
            if (t instanceof WSRPException) {
                // empty if block
            }
        }
    }

    public void restore() throws WSRPException {
        super.removeAllProducers();
        try {
            this.persistentDataObject = this.persistentHandler.restoreMultiple(this.persistentDataObject);
            Iterator iterator = this.persistentDataObject.getObjects();
            while (iterator.hasNext()) {
                Producer producer = (Producer)iterator.next();
                if (producer instanceof StateChangedService) {
                    ((StateChangedService)producer).addListener((StateChangedListener)this);
                }
                super.addProducer(producer);
            }
        }
        catch (WSRPException e) {
            super.removeAllProducers();
            throw e;
        }
    }

    public void store(Producer producer) throws WSRPException {
        if (producer != null) {
            this.persistentDataObject.clear();
            this.persistentDataObject.addObject((Object)producer);
            this.persistentHandler.store(this.persistentDataObject);
        }
    }

    private void delete(Producer producer) {
        if (producer != null) {
            this.persistentDataObject.clear();
            this.persistentDataObject.addObject((Object)producer);
            this.persistentHandler.delete(this.persistentDataObject);
        }
    }
}

