/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsrp4j.consumer.driver;

import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Hashtable;
import javax.xml.rpc.ServiceException;
import oasis.names.tc.wsrp.v1.intf.WSRP_v1_PortletManagement_PortType;
import oasis.names.tc.wsrp.v1.intf.WSRP_v1_Registration_PortType;
import oasis.names.tc.wsrp.v1.intf.WSRP_v1_ServiceDescription_PortType;
import oasis.names.tc.wsrp.v1.types.InvalidRegistrationFault;
import oasis.names.tc.wsrp.v1.types.PortletDescription;
import oasis.names.tc.wsrp.v1.types.RegistrationContext;
import oasis.names.tc.wsrp.v1.types.RegistrationData;
import oasis.names.tc.wsrp.v1.types.RegistrationState;
import oasis.names.tc.wsrp.v1.types.ReturnAny;
import oasis.names.tc.wsrp.v1.types.ServiceDescription;
import oasis.names.tc.wsrp.v1.types._getServiceDescription;
import oasis.names.tc.wsrp.v1.types._modifyRegistration;
import oasis.names.tc.wsrp.v1.wsdl.WSRPServiceLocator;
import org.apache.wsrp4j.consumer.Producer;
import org.apache.wsrp4j.exception.WSRPException;
import org.apache.wsrp4j.exception.WSRPXHelper;
import org.apache.wsrp4j.log.LogManager;
import org.apache.wsrp4j.log.Logger;
import org.apache.wsrp4j.util.ParameterChecker;
import org.apache.wsrp4j.util.StateChangedServiceImpl;

public class ProducerImpl
extends StateChangedServiceImpl
implements Producer {
    private String name = null;
    private String producerID = null;
    private String description = null;
    private String registrationURL;
    private String serviceDescriptionURL;
    private String markupURL;
    private String portletManagementURL;
    private boolean registrationRequired = false;
    private RegistrationContext registrationContext = null;
    private RegistrationData consumerRegData = null;
    private ServiceDescription serviceDescription = null;
    private Hashtable portletDesc = new Hashtable();
    private WSRP_v1_ServiceDescription_PortType serviceDescriptionInterface = null;
    private WSRP_v1_Registration_PortType registrationInterface = null;
    private WSRP_v1_PortletManagement_PortType portletManagementInterface = null;
    private Logger logger = LogManager.getLogManager().getLogger(this.getClass());
    private ParameterChecker checker = new ParameterChecker();

    public ProducerImpl() {
    }

    public ProducerImpl(String producerID, String markupURL, String serviceDescriptionURL) throws WSRPException {
        this();
        this.producerID = producerID;
        if (markupURL != null) {
            this.markupURL = markupURL;
        } else {
            WSRPXHelper.throwX((Logger)this.logger, (int)10, (String)"init", (int)6016);
        }
        if (serviceDescriptionURL != null) {
            this.serviceDescriptionURL = serviceDescriptionURL;
            this.initServiceDescInterface(serviceDescriptionURL);
        } else {
            WSRPXHelper.throwX((Logger)this.logger, (int)10, (String)"init", (int)6003);
        }
    }

    public ProducerImpl(String producerID, String markupURL, String serviceDescriptionURL, String registrationURL, String portletManagementURL, RegistrationData registrationData) throws WSRPException {
        this(producerID, markupURL, serviceDescriptionURL);
        if (registrationURL != null) {
            this.initRegistrationInterface(registrationURL);
            this.registrationURL = registrationURL;
            this.consumerRegData = registrationData;
        }
        if (portletManagementURL != null) {
            this.portletManagementURL = portletManagementURL;
            this.initPortletManagementInterface(portletManagementURL);
        }
    }

    public void initServiceDescInterface(String serviceDescriptionURL) throws WSRPException {
        this.serviceDescriptionURL = serviceDescriptionURL;
        try {
            WSRPServiceLocator serviceLocator = new WSRPServiceLocator();
            this.serviceDescriptionInterface = serviceLocator.getWSRPServiceDescriptionService(new URL(serviceDescriptionURL));
        }
        catch (ServiceException xmlEx) {
            WSRPXHelper.throwX((Logger)this.logger, (int)10, (String)"initServiceDescInterface", (int)6004, (Throwable)xmlEx);
        }
        catch (MalformedURLException urlEx) {
            WSRPXHelper.throwX((Logger)this.logger, (int)10, (String)"initServiceDescInterface", (int)6005, (Throwable)urlEx);
        }
    }

    public void initRegistrationInterface(String registrationURL) throws WSRPException {
        this.registrationURL = registrationURL;
        try {
            WSRPServiceLocator serviceLocator = new WSRPServiceLocator();
            this.registrationInterface = serviceLocator.getWSRPRegistrationService(new URL(registrationURL));
        }
        catch (ServiceException xmlEx) {
            WSRPXHelper.throwX((Logger)this.logger, (int)10, (String)"initRegistrationInterface", (int)6006, (Throwable)xmlEx);
        }
        catch (MalformedURLException urlEx) {
            WSRPXHelper.throwX((Logger)this.logger, (int)10, (String)"initRegistrationInterface", (int)6007, (Throwable)urlEx);
        }
    }

    public String getServiceDescriptionInterfaceEndpoint() {
        return this.serviceDescriptionURL;
    }

    public void setServiceDescriptionInterfaceEndpoint(String url) {
        this.serviceDescriptionURL = url;
        this.stateChanged();
    }

    public String getRegistrationInterfaceEndpoint() {
        return this.registrationURL;
    }

    public void setRegistrationInterfaceEndpoint(String url) {
        this.registrationURL = url;
        this.stateChanged();
    }

    public String getID() {
        return this.producerID;
    }

    public void setID(String id) {
        this.producerID = id;
        this.stateChanged();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.stateChanged();
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
        this.stateChanged();
    }

    public boolean isRegistrationRequired() {
        return this.registrationRequired;
    }

    public void setIsRegistrationRequired(boolean registrationRequired) {
        this.registrationRequired = registrationRequired;
        this.stateChanged();
    }

    public RegistrationData getRegistrationData() {
        return this.consumerRegData;
    }

    public void setRegistrationData(RegistrationData regData) {
        this.consumerRegData = regData;
        this.stateChanged();
    }

    public RegistrationContext getRegistrationContext() {
        return this.registrationContext;
    }

    public void setRegistrationContext(RegistrationContext registrationContext) {
        if (registrationContext != null) {
            this.registrationContext = registrationContext;
            this.stateChanged();
        }
    }

    public ServiceDescription getServiceDescription() throws WSRPException {
        return this.getServiceDescription(false);
    }

    public ServiceDescription getServiceDescription(boolean newRequest) throws WSRPException {
        block10: {
            if (this.serviceDescription == null || newRequest) {
                _getServiceDescription request = new _getServiceDescription();
                if (this.registrationContext != null) {
                    request.setRegistrationContext(this.registrationContext);
                }
                request.setDesiredLocales(null);
                ServiceDescription response = null;
                try {
                    response = this.serviceDescriptionInterface.getServiceDescription(request);
                    if (response != null) {
                        try {
                            this.checker.check(response);
                        }
                        catch (RemoteException wsrpFault) {
                            WSRPXHelper.handleWSRPFault((Logger)this.logger, (RemoteException)wsrpFault);
                        }
                        if (this.registrationContext == null && response.isRequiresRegistration()) {
                            this.register(this.consumerRegData);
                            this.getServiceDescription(true);
                        } else {
                            this.setServiceDescription(response);
                        }
                        break block10;
                    }
                    WSRPXHelper.throwX((Logger)this.logger, (int)10, (String)"getServiceDescription", (int)6011);
                }
                catch (InvalidRegistrationFault invalidReg) {
                    this.register(this.consumerRegData);
                    this.getServiceDescription(true);
                }
                catch (RemoteException wsrpFault) {
                    WSRPXHelper.handleWSRPFault((Logger)this.logger, (RemoteException)wsrpFault);
                }
            }
        }
        return this.serviceDescription;
    }

    public PortletDescription getPortletDescription(String portletHandle) throws WSRPException {
        PortletDescription desc = null;
        if (portletHandle != null) {
            if (this.serviceDescription == null) {
                this.getServiceDescription();
            }
            if ((desc = (PortletDescription)this.portletDesc.get(portletHandle)) == null) {
                WSRPXHelper.throwX((Logger)this.logger, (int)10, (String)"getPortletDescription", (int)6010);
            }
        }
        return desc;
    }

    public void setServiceDescription(ServiceDescription serviceDescription) {
        if (serviceDescription != null) {
            this.serviceDescription = serviceDescription;
            this.updatePortletDescriptions(serviceDescription);
            this.setIsRegistrationRequired(serviceDescription.isRequiresRegistration());
        }
    }

    public void addPortletDescription(PortletDescription portletDescription) {
        if (portletDescription != null) {
            this.portletDesc.put(portletDescription.getPortletHandle(), portletDescription);
        }
    }

    private void updatePortletDescriptions(ServiceDescription serviceDescription) {
        PortletDescription[] offeredPortlets;
        if (serviceDescription != null && (offeredPortlets = serviceDescription.getOfferedPortlets()) != null) {
            this.portletDesc.clear();
            for (int i = 0; i < offeredPortlets.length; ++i) {
                if (offeredPortlets[i] == null) continue;
                this.addPortletDescription(offeredPortlets[i]);
            }
        }
    }

    public RegistrationContext register(RegistrationData registrationData) throws WSRPException {
        if (registrationData != null && this.registrationInterface != null) {
            try {
                RegistrationContext regContext = this.registrationInterface.register(registrationData);
                this.checker.check(regContext, false);
                this.setRegistrationContext(regContext);
            }
            catch (RemoteException wsrpFault) {
                WSRPXHelper.handleWSRPFault((Logger)this.logger, (RemoteException)wsrpFault);
            }
        }
        return this.registrationContext;
    }

    public RegistrationState modifyRegistration(RegistrationData registrationData) throws WSRPException {
        RegistrationState newState = null;
        try {
            if (registrationData != null && this.registrationInterface != null) {
                _modifyRegistration request = new _modifyRegistration();
                if (this.registrationContext != null) {
                    request.setRegistrationContext(this.registrationContext);
                }
                request.setRegistrationData(registrationData);
                newState = this.registrationInterface.modifyRegistration(request);
                this.getRegistrationContext().setRegistrationState(newState.getRegistrationState());
                this.stateChanged();
            }
        }
        catch (RemoteException wsrpFault) {
            WSRPXHelper.handleWSRPFault((Logger)this.logger, (RemoteException)wsrpFault);
        }
        return newState;
    }

    public ReturnAny deregister() throws WSRPException {
        ReturnAny any = null;
        try {
            if (this.registrationContext != null && this.registrationInterface != null) {
                any = this.registrationInterface.deregister(this.registrationContext);
                this.registrationContext = null;
                this.registrationRequired = false;
                this.stateChanged();
            }
        }
        catch (RemoteException wsrpFault) {
            WSRPXHelper.handleWSRPFault((Logger)this.logger, (RemoteException)wsrpFault);
        }
        return any;
    }

    public String getMarkupInterfaceEndpoint() {
        return this.markupURL;
    }

    public void setMarkupInterfaceEndpoint(String url) {
        this.markupURL = url;
        this.stateChanged();
    }

    public String getPortletManagementInterfaceEndpoint() {
        return this.portletManagementURL;
    }

    public void setPortletManagementInterfaceEndpoint(String url) {
        this.portletManagementURL = url;
        this.stateChanged();
    }

    public void initPortletManagementInterface(String portletManagementURL) throws WSRPException {
        String MN = "initPortletManagementInterface";
        this.portletManagementURL = portletManagementURL;
        try {
            WSRPServiceLocator serviceLocator = new WSRPServiceLocator();
            this.portletManagementInterface = serviceLocator.getWSRPPortletManagementService(new URL(portletManagementURL));
        }
        catch (ServiceException xmlEx) {
            WSRPXHelper.throwX((Logger)this.logger, (int)10, (String)"initPortletManagementInterface", (int)6014, (Throwable)xmlEx);
        }
        catch (MalformedURLException urlEx) {
            WSRPXHelper.throwX((Logger)this.logger, (int)10, (String)"initPortletManagementInterface", (int)6015, (Throwable)urlEx);
        }
    }

    public WSRP_v1_PortletManagement_PortType getPortletManagementInterface() {
        return this.portletManagementInterface;
    }

    public WSRP_v1_Registration_PortType getRegistrationInterface() {
        return this.registrationInterface;
    }

    public WSRP_v1_ServiceDescription_PortType getServiceDescriptionInterface() {
        return this.serviceDescriptionInterface;
    }

    public boolean isPortletManagementInferfaceSupported() {
        return this.portletManagementURL != null;
    }

    public boolean isRegistrationInterfaceSupported() {
        return this.registrationURL != null;
    }
}

