/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsrp4j.consumer.driver;

import java.util.HashMap;
import java.util.Map;
import org.apache.wsrp4j.consumer.URLGenerator;
import org.apache.wsrp4j.consumer.URLRewriter;
import org.apache.wsrp4j.log.LogManager;
import org.apache.wsrp4j.log.Logger;

public class URLRewriterImpl
implements URLRewriter {
    private static URLRewriter instance = null;
    private URLGenerator urlGenerator = null;
    private Logger logger = LogManager.getLogManager().getLogger(this.getClass());

    public static URLRewriter getInstance() {
        if (instance == null) {
            instance = new URLRewriterImpl();
        }
        return instance;
    }

    private URLRewriterImpl() {
    }

    public void setURLGenerator(URLGenerator urlGenerator) {
        String MN = "setURLGenerator";
        if (this.logger.isLogging(60)) {
            this.logger.entry(60, MN);
        }
        this.urlGenerator = urlGenerator;
        if (this.logger.isLogging(60)) {
            this.logger.exit(60, MN);
        }
    }

    private void rewrite(StringBuffer markup, String rewriteURL) {
        String MN = "rewrite";
        if (this.urlGenerator != null) {
            if (rewriteURL.startsWith("wsrp_rewrite?")) {
                Map params = this.createParameterMap(rewriteURL);
                if (rewriteURL.indexOf("blockingAction") != -1) {
                    markup.append(this.urlGenerator.getBlockingActionURL(params));
                } else if (rewriteURL.indexOf("render") != -1) {
                    markup.append(this.urlGenerator.getRenderURL(params));
                } else if (rewriteURL.indexOf("resource") != -1) {
                    markup.append(this.urlGenerator.getResourceURL(params));
                }
            } else if (rewriteURL.startsWith("wsrp_rewrite_")) {
                markup.append(this.urlGenerator.getNamespacedToken(""));
            } else if (this.logger.isLogging(10)) {
                this.logger.text(10, MN, "no valid rewrite expression found in: " + rewriteURL);
            }
        } else if (this.logger.isLogging(10)) {
            String message = "URLGenerator has not been set for class URLRewriterImpl. URL-Rewriting not possible.";
            this.logger.text(10, MN, message);
        }
    }

    private Map createParameterMap(String rewriteURL) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (rewriteURL.indexOf("blockingAction") != -1) {
            params.put("wsrp-urlType", "blockingAction");
        } else if (rewriteURL.indexOf("render") != -1) {
            params.put("wsrp-urlType", "render");
        } else if (rewriteURL.indexOf("resource") != -1) {
            params.put("wsrp-urlType", "resource");
        }
        int equals = 0;
        int next = 0;
        int end = rewriteURL.indexOf("/wsrp_rewrite");
        int index = rewriteURL.indexOf("&");
        int lengthNext = 0;
        String subNext = null;
        while (index != -1) {
            subNext = rewriteURL.substring(index, index + "&amp;".length());
            lengthNext = subNext.equals("&amp;") ? "&amp;".length() : "&".length();
            equals = rewriteURL.indexOf("=", index + lengthNext);
            next = rewriteURL.indexOf("&", equals);
            if (equals != -1) {
                if (next != -1) {
                    params.put(rewriteURL.substring(index + lengthNext, equals), rewriteURL.substring(equals + 1, next));
                } else {
                    params.put(rewriteURL.substring(index + lengthNext, equals), rewriteURL.substring(equals + 1, end));
                }
            }
            index = next;
        }
        return params;
    }

    public String rewriteURLs(String markup) {
        String MN = "rewriteURLs";
        if (this.logger.isLogging(60)) {
            this.logger.entry(60, "rewriteURLs");
        }
        if (this.urlGenerator == null) {
            if (this.logger.isLogging(10)) {
                String message = "URLGenerator has not been set for class URLRewriterImpl. URL-Rewriting not possible.";
                this.logger.text(10, "rewriteURLs", message);
            }
            return markup;
        }
        StringBuffer resultMarkup = new StringBuffer("");
        int markupIndex = 0;
        int rewriteStartPos = -1;
        int rewriteEndPos = -1;
        int currentPos = 0;
        String exprType = null;
        while (markupIndex < markup.length()) {
            rewriteStartPos = -1;
            rewriteEndPos = -1;
            rewriteStartPos = markup.indexOf("wsrp_rewrite", markupIndex);
            if (rewriteStartPos != -1 && rewriteStartPos + "wsrp_rewrite".length() - 1 <= markup.length() - 2) {
                exprType = markup.substring(rewriteStartPos + "wsrp_rewrite".length() - 1 + 1, rewriteStartPos + "wsrp_rewrite".length() - 1 + 2);
                if (exprType.equals("_")) {
                    rewriteEndPos = rewriteStartPos + "wsrp_rewrite".length() + "_".length() - 1;
                } else if (exprType.equals("?") && (rewriteEndPos = markup.indexOf("/wsrp_rewrite", markupIndex)) != -1) {
                    currentPos = rewriteStartPos;
                    while (currentPos != -1 && currentPos < rewriteEndPos) {
                        rewriteStartPos = currentPos;
                        currentPos = markup.indexOf("wsrp_rewrite?", rewriteStartPos + "wsrp_rewrite".length() + "?".length());
                    }
                    rewriteEndPos = rewriteEndPos + "/wsrp_rewrite".length() - 1;
                }
            }
            if (rewriteStartPos != -1 && rewriteEndPos != -1) {
                resultMarkup.append(markup.substring(markupIndex, rewriteStartPos));
                this.rewrite(resultMarkup, markup.substring(rewriteStartPos, rewriteEndPos + 1));
                markupIndex = rewriteEndPos + 1;
                continue;
            }
            resultMarkup.append(markup.substring(markupIndex, markup.length()));
            markupIndex = markup.length();
        }
        if (this.logger.isLogging(60)) {
            this.logger.exit(60, "rewriteURLs");
        }
        return resultMarkup.toString();
    }
}

