/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.Constants;
import com.sun.org.apache.bcel.internal.classfile.Constant;
import com.sun.org.apache.bcel.internal.classfile.ConstantCP;
import com.sun.org.apache.bcel.internal.classfile.ConstantClass;
import com.sun.org.apache.bcel.internal.classfile.ConstantDouble;
import com.sun.org.apache.bcel.internal.classfile.ConstantFloat;
import com.sun.org.apache.bcel.internal.classfile.ConstantInteger;
import com.sun.org.apache.bcel.internal.classfile.ConstantLong;
import com.sun.org.apache.bcel.internal.classfile.ConstantNameAndType;
import com.sun.org.apache.bcel.internal.classfile.ConstantString;
import com.sun.org.apache.bcel.internal.classfile.ConstantUtf8;
import com.sun.org.apache.bcel.internal.classfile.Node;
import com.sun.org.apache.bcel.internal.classfile.Utility;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ConstantPool
implements Cloneable,
Node {
    private int constant_pool_count;
    private Constant[] constant_pool;

    public ConstantPool(Constant[] constant_pool) {
        this.setConstantPool(constant_pool);
    }

    ConstantPool(DataInputStream file) throws IOException, ClassFormatError {
        this.constant_pool_count = file.readUnsignedShort();
        this.constant_pool = new Constant[this.constant_pool_count];
        int i = 1;
        while (i < this.constant_pool_count) {
            this.constant_pool[i] = Constant.readConstant(file);
            byte tag = this.constant_pool[i].getTag();
            if (tag == 6 || tag == 5) {
                ++i;
            }
            ++i;
        }
    }

    public void accept(Visitor v) {
        v.visitConstantPool(this);
    }

    public String constantToString(Constant c) throws ClassFormatError {
        String str;
        byte tag = c.getTag();
        switch (tag) {
            case 7: {
                int i = ((ConstantClass)c).getNameIndex();
                c = this.getConstant(i, (byte)1);
                str = Utility.compactClassName(((ConstantUtf8)c).getBytes(), false);
                break;
            }
            case 8: {
                int i = ((ConstantString)c).getStringIndex();
                c = this.getConstant(i, (byte)1);
                str = "\"" + ConstantPool.escape(((ConstantUtf8)c).getBytes()) + "\"";
                break;
            }
            case 1: {
                str = ((ConstantUtf8)c).getBytes();
                break;
            }
            case 6: {
                str = "" + ((ConstantDouble)c).getBytes();
                break;
            }
            case 4: {
                str = "" + ((ConstantFloat)c).getBytes();
                break;
            }
            case 5: {
                str = "" + ((ConstantLong)c).getBytes();
                break;
            }
            case 3: {
                str = "" + ((ConstantInteger)c).getBytes();
                break;
            }
            case 12: {
                str = this.constantToString(((ConstantNameAndType)c).getNameIndex(), (byte)1) + " " + this.constantToString(((ConstantNameAndType)c).getSignatureIndex(), (byte)1);
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                str = this.constantToString(((ConstantCP)c).getClassIndex(), (byte)7) + "." + this.constantToString(((ConstantCP)c).getNameAndTypeIndex(), (byte)12);
                break;
            }
            default: {
                throw new RuntimeException("Unknown constant type " + tag);
            }
        }
        return str;
    }

    private static final String escape(String str) {
        int len = str.length();
        StringBuffer buf = new StringBuffer(len + 5);
        char[] ch = str.toCharArray();
        int i = 0;
        while (i < len) {
            switch (ch[i]) {
                case '\n': {
                    buf.append("\\n");
                    break;
                }
                case '\r': {
                    buf.append("\\r");
                    break;
                }
                case '\t': {
                    buf.append("\\t");
                    break;
                }
                case '\b': {
                    buf.append("\\b");
                    break;
                }
                case '\"': {
                    buf.append("\\\"");
                    break;
                }
                default: {
                    buf.append(ch[i]);
                }
            }
            ++i;
        }
        return buf.toString();
    }

    public String constantToString(int index, byte tag) throws ClassFormatError {
        Constant c = this.getConstant(index, tag);
        return this.constantToString(c);
    }

    public void dump(DataOutputStream file) throws IOException {
        file.writeShort(this.constant_pool_count);
        int i = 1;
        while (i < this.constant_pool_count) {
            if (this.constant_pool[i] != null) {
                this.constant_pool[i].dump(file);
            }
            ++i;
        }
    }

    public Constant getConstant(int index) {
        if (index >= this.constant_pool.length || index < 0) {
            throw new ClassFormatError("Invalid constant pool reference: " + index + ". Constant pool size is: " + this.constant_pool.length);
        }
        return this.constant_pool[index];
    }

    public Constant getConstant(int index, byte tag) throws ClassFormatError {
        Constant c = this.getConstant(index);
        if (c == null) {
            throw new ClassFormatError("Constant pool at index " + index + " is null.");
        }
        if (c.getTag() == tag) {
            return c;
        }
        throw new ClassFormatError("Expected class `" + Constants.CONSTANT_NAMES[tag] + "' at index " + index + " and got " + c);
    }

    public Constant[] getConstantPool() {
        return this.constant_pool;
    }

    public String getConstantString(int index, byte tag) throws ClassFormatError {
        int i;
        Constant c = this.getConstant(index, tag);
        switch (tag) {
            case 7: {
                i = ((ConstantClass)c).getNameIndex();
                break;
            }
            case 8: {
                i = ((ConstantString)c).getStringIndex();
                break;
            }
            default: {
                throw new RuntimeException("getConstantString called with illegal tag " + tag);
            }
        }
        c = this.getConstant(i, (byte)1);
        return ((ConstantUtf8)c).getBytes();
    }

    public int getLength() {
        return this.constant_pool_count;
    }

    public void setConstant(int index, Constant constant) {
        this.constant_pool[index] = constant;
    }

    public void setConstantPool(Constant[] constant_pool) {
        this.constant_pool = constant_pool;
        this.constant_pool_count = constant_pool == null ? 0 : constant_pool.length;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        int i = 1;
        while (i < this.constant_pool_count) {
            buf.append(i + ")" + this.constant_pool[i] + "\n");
            ++i;
        }
        return buf.toString();
    }

    public ConstantPool copy() {
        ConstantPool c = null;
        try {
            c = (ConstantPool)this.clone();
        }
        catch (CloneNotSupportedException e) {
            // empty catch block
        }
        c.constant_pool = new Constant[this.constant_pool_count];
        int i = 1;
        while (i < this.constant_pool_count) {
            if (this.constant_pool[i] != null) {
                c.constant_pool[i] = this.constant_pool[i].copy();
            }
            ++i;
        }
        return c;
    }
}

