/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.verifier.statics;

import com.sun.org.apache.bcel.internal.generic.Type;
import com.sun.org.apache.bcel.internal.verifier.exc.LocalVariableInfoInconsistentException;
import java.util.Hashtable;

public class LocalVariableInfo {
    private Hashtable types = new Hashtable();
    private Hashtable names = new Hashtable();

    private void setName(int offset, String name) {
        this.names.put(Integer.toString(offset), name);
    }

    private void setType(int offset, Type t) {
        this.types.put(Integer.toString(offset), t);
    }

    public Type getType(int offset) {
        return (Type)this.types.get(Integer.toString(offset));
    }

    public String getName(int offset) {
        return (String)this.names.get(Integer.toString(offset));
    }

    public void add(String name, int startpc, int length, Type t) throws LocalVariableInfoInconsistentException {
        int i = startpc;
        while (i <= startpc + length) {
            this.add(i, name, t);
            ++i;
        }
    }

    private void add(int offset, String name, Type t) throws LocalVariableInfoInconsistentException {
        if (this.getName(offset) != null && !this.getName(offset).equals(name)) {
            throw new LocalVariableInfoInconsistentException("At bytecode offset '" + offset + "' a local variable has two different names: '" + this.getName(offset) + "' and '" + name + "'.");
        }
        if (this.getType(offset) != null && !this.getType(offset).equals(t)) {
            throw new LocalVariableInfoInconsistentException("At bytecode offset '" + offset + "' a local variable has two different types: '" + this.getType(offset) + "' and '" + t + "'.");
        }
        this.setName(offset, name);
        this.setType(offset, t);
    }
}

