/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsrp4j.consumer.portlet.impl;

import java.io.IOException;
import java.rmi.RemoteException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;
import oasis.names.tc.wsrp.v1.types.BlockingInteractionResponse;
import oasis.names.tc.wsrp.v1.types.MarkupContext;
import oasis.names.tc.wsrp.v1.types.MarkupResponse;
import oasis.names.tc.wsrp.v1.types.PersonName;
import oasis.names.tc.wsrp.v1.types.PortletContext;
import oasis.names.tc.wsrp.v1.types.PortletDescription;
import oasis.names.tc.wsrp.v1.types.SessionContext;
import oasis.names.tc.wsrp.v1.types.UpdateResponse;
import oasis.names.tc.wsrp.v1.types.UserContext;
import oasis.names.tc.wsrp.v1.types.UserProfile;
import org.apache.pluto.core.CoreUtils;
import org.apache.pluto.om.window.PortletWindow;
import org.apache.wsrp4j.consumer.ConsumerEnvironment;
import org.apache.wsrp4j.consumer.GroupSessionMgr;
import org.apache.wsrp4j.consumer.InteractionRequest;
import org.apache.wsrp4j.consumer.MarkupRequest;
import org.apache.wsrp4j.consumer.PortletDriver;
import org.apache.wsrp4j.consumer.PortletKey;
import org.apache.wsrp4j.consumer.PortletSession;
import org.apache.wsrp4j.consumer.PortletWindowSession;
import org.apache.wsrp4j.consumer.Producer;
import org.apache.wsrp4j.consumer.URLGenerator;
import org.apache.wsrp4j.consumer.URLTemplateComposer;
import org.apache.wsrp4j.consumer.User;
import org.apache.wsrp4j.consumer.UserSessionMgr;
import org.apache.wsrp4j.consumer.WSRPPortlet;
import org.apache.wsrp4j.consumer.driver.PortletKeyImpl;
import org.apache.wsrp4j.consumer.driver.UserImpl;
import org.apache.wsrp4j.consumer.driver.WSRPPortletImpl;
import org.apache.wsrp4j.consumer.portlet.SessionHandler;
import org.apache.wsrp4j.consumer.portlet.impl.ConsumerEnvironmentImpl;
import org.apache.wsrp4j.consumer.portlet.impl.URLGeneratorImpl;
import org.apache.wsrp4j.consumer.portlet.impl.WSRPRequestImpl;
import org.apache.wsrp4j.exception.WSRPException;
import org.apache.wsrp4j.exception.WSRPXHelper;
import org.apache.wsrp4j.log.LogManager;
import org.apache.wsrp4j.log.Logger;
import org.apache.wsrp4j.util.ParameterChecker;

public class ProxyPortlet
extends GenericPortlet {
    private ConsumerEnvironment consumerEnv = null;
    private static ParameterChecker checker = null;
    private static final Logger logger = LogManager.getLogManager().getLogger(class$org$apache$wsrp4j$consumer$portlet$impl$ProxyPortlet == null ? (class$org$apache$wsrp4j$consumer$portlet$impl$ProxyPortlet = ProxyPortlet.class$("org.apache.wsrp4j.consumer.portlet.impl.ProxyPortlet")) : class$org$apache$wsrp4j$consumer$portlet$impl$ProxyPortlet);
    private static final Object urlGenLock = new Object();
    private static final Object sessionHdlrLock = new Object();
    public static final String NAVIGATIONAL_STATE = "proxyportlet-updateResponse-navState";
    static /* synthetic */ Class class$org$apache$wsrp4j$consumer$portlet$impl$ProxyPortlet;

    public void init(PortletConfig config) throws PortletException {
        String MN = "init";
        if (logger.isLogging(60)) {
            logger.entry(60, "init");
        }
        super.init(config);
        checker = new ParameterChecker();
        try {
            this.initConsumerEnvironment(config);
        }
        catch (WSRPException e) {
            throw new PortletException((Throwable)e);
        }
        if (logger.isLogging(60)) {
            logger.exit(60, "init");
        }
    }

    private void initConsumerEnvironment(PortletConfig config) throws WSRPException {
        try {
            String path;
            String className = config.getInitParameter("consumer.enviroment.class");
            if (className != null) {
                Class<?> cl = Class.forName(className);
                this.consumerEnv = (ConsumerEnvironment)cl.newInstance();
                path = config.getPortletContext().getRealPath("/WEB-INF");
                if (logger.isLogging(60)) {
                    logger.text(60, "initConsumerEnvironment", "Path to persistent directory :" + path);
                }
            } else {
                throw new IllegalStateException("Consumer Environment class not found");
            }
            ((ConsumerEnvironmentImpl)this.consumerEnv).setRegistryPath(path);
        }
        catch (Exception e) {
            WSRPXHelper.throwX((Logger)logger, (int)10, (String)"initConsumerEnvironment", (int)6001, (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processAction(ActionRequest request, ActionResponse actionResponse) throws PortletException {
        String MN = "processAction";
        if (logger.isLogging(60)) {
            logger.entry(60, MN);
        }
        try {
            try {
                block33: {
                    User user = this.getUser((PortletRequest)request);
                    String userID = null;
                    if (user != null) {
                        userID = user.getUserID();
                    }
                    Map preferences = this.getPreferences((PortletRequest)request);
                    PortletKey portletKey = this.getPortletKey(preferences);
                    WSRPPortlet portlet = this.getPortlet(portletKey, preferences);
                    PortletWindowSession windowSession = this.getWindowSession(userID, portlet, (PortletRequest)request);
                    PortletDriver portletDriver = this.consumerEnv.getPortletDriverRegistry().getPortletDriver(portlet);
                    WSRPRequestImpl actionRequest = new WSRPRequestImpl(windowSession, (PortletRequest)request);
                    PortletWindow myWindow = CoreUtils.getInternalRequest((PortletRequest)request).getInternalPortletWindow();
                    if (logger.isLogging(60)) {
                        logger.text(60, MN, "proxyporltet(" + myWindow.getPortletEntity().getId() + ") invokes action on portlet " + portlet.getPortletKey().getPortletHandle());
                    }
                    BlockingInteractionResponse response = null;
                    try {
                        response = portletDriver.performBlockingInteraction((InteractionRequest)actionRequest, userID);
                        checker.check(response);
                    }
                    catch (RemoteException wsrpFault) {
                        WSRPXHelper.handleWSRPFault((Logger)logger, (RemoteException)wsrpFault);
                    }
                    if (response != null) {
                        UpdateResponse updateResponse = response.getUpdateResponse();
                        String redirectURL = response.getRedirectURL();
                        if (updateResponse != null) {
                            String newWindowState;
                            block32: {
                                String newMode;
                                if (windowSession != null) {
                                    this.updateSessionContext(updateResponse.getSessionContext(), windowSession.getPortletSession());
                                    windowSession.updateMarkupCache(updateResponse.getMarkupContext());
                                }
                                this.updatePortletContext((PortletRequest)request, updateResponse.getPortletContext(), portlet);
                                String navState = updateResponse.getNavigationalState();
                                if (navState != null) {
                                    actionResponse.setRenderParameter(NAVIGATIONAL_STATE, navState);
                                }
                                if ((newMode = updateResponse.getNewMode()) != null) {
                                    try {
                                        if (newMode.equalsIgnoreCase("wsrp:view")) {
                                            actionResponse.setPortletMode(PortletMode.VIEW);
                                            break block32;
                                        }
                                        if (newMode.equalsIgnoreCase("wsrp:edit")) {
                                            actionResponse.setPortletMode(PortletMode.EDIT);
                                            break block32;
                                        }
                                        if (newMode.equalsIgnoreCase("wsrp:help")) {
                                            actionResponse.setPortletMode(PortletMode.HELP);
                                        }
                                    }
                                    catch (PortletModeException e) {
                                        if (!logger.isLogging(30)) break block32;
                                        logger.text(30, MN, "The portlet='" + portlet.getPortletKey().getPortletHandle() + "' does not support the mode=" + e.getMode());
                                    }
                                }
                            }
                            if ((newWindowState = updateResponse.getNewWindowState()) != null) {
                                try {
                                    if (newWindowState.equalsIgnoreCase("wsrp:maximized")) {
                                        actionResponse.setWindowState(WindowState.MAXIMIZED);
                                        break block33;
                                    }
                                    if (newWindowState.equalsIgnoreCase("wsrp:minimized")) {
                                        actionResponse.setWindowState(WindowState.MINIMIZED);
                                    } else if (newWindowState.equalsIgnoreCase("wsrp:normal")) {
                                        actionResponse.setWindowState(WindowState.NORMAL);
                                    }
                                }
                                catch (WindowStateException e) {
                                    if (logger.isLogging(30)) {
                                        logger.text(30, MN, "The portlet='" + portlet.getPortletKey().getPortletHandle() + "' does not support the window state=" + e.getState());
                                    }
                                }
                            }
                        } else if (redirectURL != null) {
                            try {
                                actionResponse.sendRedirect(redirectURL);
                            }
                            catch (IOException ioEx) {
                                WSRPXHelper.throwX((Logger)logger, (int)10, (String)"processAction", (int)6012);
                            }
                        }
                    }
                }
                Object var21_24 = null;
            }
            catch (WSRPException e) {
                throw new PortletException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var21_25 = null;
            if (!logger.isLogging(60)) throw throwable;
            logger.exit(60, MN);
            throw throwable;
        }
        if (!logger.isLogging(60)) return;
        logger.exit(60, MN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void render(RenderRequest request, RenderResponse renderResponse) throws PortletException, IOException {
        String MN = "render";
        if (logger.isLogging(60)) {
            logger.entry(60, MN);
        }
        try {
            block14: {
                try {
                    renderResponse.setContentType(request.getResponseContentType());
                    User user = this.getUser((PortletRequest)request);
                    String userID = null;
                    if (user != null) {
                        userID = user.getUserID();
                    }
                    Map preferences = this.getPreferences((PortletRequest)request);
                    PortletKey portletKey = this.getPortletKey(preferences);
                    WSRPPortlet portlet = this.getPortlet(portletKey, preferences);
                    PortletWindowSession windowSession = this.getWindowSession(userID, portlet, (PortletRequest)request);
                    PortletDriver portletDriver = this.consumerEnv.getPortletDriverRegistry().getPortletDriver(portlet);
                    WSRPRequestImpl markupRequest = new WSRPRequestImpl(windowSession, (PortletRequest)request);
                    PortletWindow myWindow = CoreUtils.getInternalRequest((PortletRequest)request).getInternalPortletWindow();
                    if (logger.isLogging(60)) {
                        logger.text(60, MN, "proxyporltet(" + myWindow.getPortletEntity().getId() + ") renders portlet " + portlet.getPortletKey().getPortletHandle());
                    }
                    Object object = urlGenLock;
                    synchronized (object) {
                        URLGenerator urlGenerator = URLGeneratorImpl.getInstance(renderResponse, this.getPortletConfig());
                        URLTemplateComposer templateComposer = this.consumerEnv.getTemplateComposer();
                        if (templateComposer != null) {
                            templateComposer.setURLGenerator(urlGenerator);
                        }
                        this.consumerEnv.getURLRewriter().setURLGenerator(urlGenerator);
                    }
                    MarkupResponse response = null;
                    try {
                        response = portletDriver.getMarkup((MarkupRequest)markupRequest, userID);
                        checker.check(response);
                    }
                    catch (RemoteException wsrpFault) {
                        WSRPXHelper.handleWSRPFault((Logger)logger, (RemoteException)wsrpFault);
                    }
                    if (response != null) {
                        if (windowSession != null) {
                            this.updateSessionContext(response.getSessionContext(), windowSession.getPortletSession());
                        }
                        this.processMarkupContext(response.getMarkupContext(), renderResponse);
                    }
                    if (windowSession == null) break block14;
                    windowSession.updateMarkupCache(null);
                }
                catch (WSRPException e) {
                    throw new PortletException("Error occured while retrieving markup", (Throwable)e);
                }
            }
            Object var18_18 = null;
            if (!logger.isLogging(60)) return;
            logger.exit(60, MN);
            return;
        }
        catch (Throwable throwable) {
            Object var18_19 = null;
            if (!logger.isLogging(60)) throw throwable;
            logger.exit(60, MN);
            throw throwable;
        }
    }

    private String processMarkupContext(MarkupContext markupContext, RenderResponse renderResponse) throws IOException, WSRPException {
        String MN = "processMarkupContext";
        if (logger.isLogging(60)) {
            logger.entry(60, "processMarkupContext");
        }
        String markup = null;
        if (markupContext != null && renderResponse != null) {
            String title = markupContext.getPreferredTitle();
            if (title != null) {
                renderResponse.setTitle(title);
            }
            if ((markup = markupContext.getMarkupString()) != null) {
                try {
                    renderResponse.getWriter().write(markup);
                }
                catch (IOException e) {
                    WSRPXHelper.throwX((int)0, (Throwable)e);
                }
            }
        }
        if (logger.isLogging(60)) {
            logger.exit(60, "processMarkupContext");
        }
        return markup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PortletWindowSession getWindowSession(String userID, WSRPPortlet portlet, PortletRequest request) throws WSRPException {
        PortletKey portletKey = portlet.getPortletKey();
        this.getProducer(portletKey.getProducerId());
        UserSessionMgr userSession = null;
        Object object = sessionHdlrLock;
        synchronized (object) {
            SessionHandler sessionHandler = (SessionHandler)this.consumerEnv.getSessionHandler();
            sessionHandler.setPortletSession(request.getPortletSession());
            userSession = sessionHandler.getUserSession(portletKey.getProducerId(), userID);
        }
        if (userSession != null) {
            String groupID = this.getPortletDescription(portlet).getGroupID();
            groupID = groupID == null ? "default" : groupID;
            GroupSessionMgr groupSession = userSession.getGroupSession(groupID);
            if (groupSession != null) {
                PortletWindow portletWindow = CoreUtils.getInternalRequest((PortletRequest)request).getInternalPortletWindow();
                String handle = portletWindow.getPortletEntity().getId().toString();
                PortletSession portletSession = groupSession.getPortletSession(handle);
                if (portletSession != null) {
                    String windowID = portletWindow.getId().toString();
                    PortletWindowSession windowSession = portletSession.getPortletWindowSession(windowID);
                    return windowSession;
                }
                WSRPXHelper.throwX((int)6022);
            } else {
                WSRPXHelper.throwX((int)6021);
            }
        } else {
            WSRPXHelper.throwX((int)6020);
        }
        return null;
    }

    private void updateSessionContext(SessionContext sessionContext, PortletSession portletSession) {
        if (sessionContext != null && portletSession != null) {
            portletSession.setSessionContext(sessionContext);
        }
    }

    private void updatePortletContext(PortletRequest request, PortletContext portletContext, WSRPPortlet portlet) throws WSRPException {
        if (portletContext != null && portlet != null) {
            String newPortletHandle = portletContext.getPortletHandle();
            PortletKey portletKey = portlet.getPortletKey();
            if (newPortletHandle != null && !newPortletHandle.equals(portletKey.getPortletHandle())) {
                String producerID = portletKey.getProducerId();
                PortletKeyImpl newPortletKey = new PortletKeyImpl(newPortletHandle, producerID);
                portlet = this.createPortlet((PortletKey)newPortletKey, portlet.getParent());
                this.consumerEnv.getPortletRegistry().addPortlet(portlet);
                PortletPreferences preferences = request.getPreferences();
                try {
                    preferences.setValue("wsrp_portlet_handle", newPortletHandle);
                    preferences.setValue("wsrp_parent_handle", portlet.getParent());
                    preferences.store();
                }
                catch (Exception e) {
                    WSRPXHelper.throwX((int)0, (Throwable)e);
                }
            }
            portlet.setPortletContext(portletContext);
        }
    }

    private User getUser(PortletRequest request) {
        User user = null;
        Principal userPrincipal = request.getUserPrincipal();
        if (userPrincipal != null) {
            String userKey = userPrincipal.getName();
            user = this.consumerEnv.getUserRegistry().getUser(userKey);
            if (user == null) {
                user = new UserImpl(userKey);
                UserContext userContext = new UserContext();
                userContext.setProfile(this.fillUserProfile(request));
                userContext.setUserContextKey(userKey);
                user.setUserContext(userContext);
                this.consumerEnv.getUserRegistry().addUser(user);
            }
        }
        return user;
    }

    private UserProfile fillUserProfile(PortletRequest request) {
        UserProfile userProfile = null;
        Map userInfo = (Map)request.getAttribute("javax.portlet.userinfo");
        if (userInfo != null) {
            userProfile = new UserProfile();
            PersonName personName = new PersonName();
            personName.setGiven(userInfo.get("name.given").toString());
            userProfile.setName(personName);
        }
        return userProfile;
    }

    private Map getPreferences(PortletRequest request) {
        HashMap<String, String> preferences = new HashMap<String, String>();
        Enumeration keys = request.getPreferences().getNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = request.getPreferences().getValue(key, null);
            preferences.put(key, value);
        }
        return preferences;
    }

    protected PortletKey getPortletKey(Map preferences) {
        String producerID;
        PortletKeyImpl portletKey = null;
        String portletHandle = (String)preferences.get("wsrp_portlet_handle");
        if (portletHandle != null && (producerID = (String)preferences.get("wsrp_producer_id")) != null) {
            portletKey = new PortletKeyImpl(portletHandle, producerID);
        }
        return portletKey;
    }

    private WSRPPortlet getPortlet(PortletKey portletKey, Map preferences) throws WSRPException {
        WSRPPortlet portlet = null;
        if (portletKey != null && (portlet = this.consumerEnv.getPortletRegistry().getPortlet(portletKey)) == null) {
            String parentHandle = (String)preferences.get("wsrp_parent_handle");
            portlet = this.createPortlet(portletKey, parentHandle);
            this.consumerEnv.getPortletRegistry().addPortlet(portlet);
        }
        return portlet;
    }

    private WSRPPortlet createPortlet(PortletKey portletKey, String parentHandle) {
        WSRPPortletImpl portlet = new WSRPPortletImpl(portletKey);
        PortletContext portletContext = new PortletContext();
        portletContext.setPortletHandle(portletKey.getPortletHandle());
        portletContext.setPortletState(null);
        portletContext.setExtensions(null);
        portlet.setPortletContext(portletContext);
        if (parentHandle != null) {
            portlet.setParent(parentHandle);
        } else {
            portlet.setParent(portletKey.getPortletHandle());
        }
        return portlet;
    }

    private PortletDescription getPortletDescription(WSRPPortlet portlet) throws WSRPException {
        String producerID = portlet.getPortletKey().getProducerId();
        Producer producer = this.getProducer(producerID);
        PortletDescription portletDesc = producer.getPortletDescription(portlet.getParent());
        if (portletDesc == null) {
            WSRPXHelper.throwX((int)6019);
        }
        return portletDesc;
    }

    protected Producer getProducer(String producerID) throws WSRPException {
        Producer producer;
        String MN = "getProducer";
        if (logger.isLogging(60)) {
            logger.text(60, "getProducer", "Trying to load producer with ID :" + producerID);
        }
        if ((producer = this.consumerEnv.getProducerRegistry().getProducer(producerID)) == null) {
            WSRPXHelper.throwX((Logger)logger, (int)10, (String)"getProducer", (int)6013);
        }
        return producer;
    }

    protected ConsumerEnvironment getConsumerEnvironment() {
        return this.consumerEnv;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

