/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsrp4j.consumer.portlet.impl;

import java.util.Hashtable;
import java.util.Map;
import javax.portlet.PortletSession;
import oasis.names.tc.wsrp.v1.intf.WSRP_v1_Markup_PortType;
import org.apache.wsrp4j.consumer.GroupSession;
import org.apache.wsrp4j.consumer.GroupSessionMgr;
import org.apache.wsrp4j.consumer.driver.GenericUserSessionImpl;
import org.apache.wsrp4j.consumer.portlet.impl.GroupSessionImpl;
import org.apache.wsrp4j.exception.WSRPException;

public class UserSessionImpl
extends GenericUserSessionImpl {
    private PortletSession portletSession = null;
    private Map userSession = null;

    public UserSessionImpl(String producerID, String userID, String portletServicesURL, PortletSession portletSession) throws WSRPException {
        super(producerID, userID, portletServicesURL);
        this.portletSession = portletSession;
        this.userSession = this.getUserSessionMap();
        this.setGroupSessionTable(this.getGroupSessionTable());
    }

    private Hashtable getGroupSessionTable() {
        this.groupSessions = (Hashtable)this.userSession.get("wsrp_group_sessions");
        if (this.groupSessions == null) {
            this.groupSessions = new Hashtable();
            this.userSession.put("wsrp_group_sessions", this.groupSessions);
        }
        return this.groupSessions;
    }

    public GroupSessionMgr getGroupSession(String groupID) throws WSRPException {
        if (groupID != null) {
            Object groupSession = (GroupSessionMgr)this.groupSessions.get(groupID);
            if (groupSession == null) {
                groupSession = new GroupSessionImpl(groupID, this.getMarkupInterfaceURL());
                this.addGroupSession((GroupSession)groupSession);
            }
            return groupSession;
        }
        return null;
    }

    public WSRP_v1_Markup_PortType getWSRPBaseService() {
        WSRP_v1_Markup_PortType markupPort = null;
        markupPort = (WSRP_v1_Markup_PortType)this.userSession.get("wsrp_markup_port");
        if (markupPort == null) {
            markupPort = super.getWSRPBaseService();
            this.userSession.put("wsrp_markup_port", markupPort);
        }
        this.setWSRPBaseService(markupPort);
        return markupPort;
    }

    public boolean isInitCookieRequired() {
        Boolean initCookieReq = null;
        initCookieReq = (Boolean)this.userSession.get("wsrp_init_cookie_required");
        if (initCookieReq == null) {
            initCookieReq = new Boolean(super.isInitCookieRequired());
            this.setInitCookieRequired(initCookieReq);
        }
        return initCookieReq;
    }

    public void setInitCookieRequired(boolean initCookieRequired) {
        this.userSession.put("wsrp_init_cookie_required", new Boolean(initCookieRequired));
        super.setInitCookieRequired(initCookieRequired);
    }

    public boolean isInitCookieDone() {
        Boolean initCookieDone = null;
        initCookieDone = (Boolean)this.userSession.get("wsrp_init_cookie_done");
        if (initCookieDone == null) {
            initCookieDone = new Boolean(super.isInitCookieDone());
            this.setInitCookieDone(initCookieDone);
        }
        return initCookieDone;
    }

    public void setInitCookieDone(boolean initCookieDone) {
        this.userSession.put("wsrp_init_cookie_done", new Boolean(initCookieDone));
        super.setInitCookieRequired(initCookieDone);
    }

    private Map getUserSessionMap() {
        String key = this.createKey();
        Hashtable myMap = (Hashtable)this.portletSession.getAttribute(key, 1);
        if (myMap == null) {
            myMap = new Hashtable();
            this.portletSession.setAttribute(key, myMap, 1);
        }
        return myMap;
    }

    private String createKey() {
        return "user :" + this.getUserID() + " producer:" + this.getProducerID();
    }
}

