/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.impl.xs.models;

import com.sun.org.apache.xerces.internal.impl.dtd.models.CMNode;
import com.sun.org.apache.xerces.internal.impl.xs.XSComplexTypeDecl;
import com.sun.org.apache.xerces.internal.impl.xs.XSDeclarationPool;
import com.sun.org.apache.xerces.internal.impl.xs.XSElementDecl;
import com.sun.org.apache.xerces.internal.impl.xs.XSModelGroupImpl;
import com.sun.org.apache.xerces.internal.impl.xs.XSParticleDecl;
import com.sun.org.apache.xerces.internal.impl.xs.models.CMNodeFactory;
import com.sun.org.apache.xerces.internal.impl.xs.models.XSAllCM;
import com.sun.org.apache.xerces.internal.impl.xs.models.XSCMBinOp;
import com.sun.org.apache.xerces.internal.impl.xs.models.XSCMLeaf;
import com.sun.org.apache.xerces.internal.impl.xs.models.XSCMUniOp;
import com.sun.org.apache.xerces.internal.impl.xs.models.XSCMValidator;
import com.sun.org.apache.xerces.internal.impl.xs.models.XSDFACM;
import com.sun.org.apache.xerces.internal.impl.xs.models.XSEmptyCM;

public class CMBuilder {
    private XSDeclarationPool fDeclPool = null;
    private static XSEmptyCM fEmptyCM = new XSEmptyCM();
    private int fLeafCount;
    private int fParticleCount;
    private CMNodeFactory fNodeFactory;

    public CMBuilder(CMNodeFactory cMNodeFactory) {
        this.fNodeFactory = cMNodeFactory;
    }

    public void setDeclPool(XSDeclarationPool xSDeclarationPool) {
        this.fDeclPool = xSDeclarationPool;
    }

    public XSCMValidator getContentModel(XSComplexTypeDecl xSComplexTypeDecl) {
        short s = xSComplexTypeDecl.getContentType();
        if (s == 1 || s == 0) {
            return null;
        }
        XSParticleDecl xSParticleDecl = (XSParticleDecl)xSComplexTypeDecl.getParticle();
        if (xSParticleDecl == null) {
            return fEmptyCM;
        }
        XSCMValidator xSCMValidator = null;
        xSCMValidator = xSParticleDecl.fType == 3 && ((XSModelGroupImpl)xSParticleDecl.fValue).fCompositor == 103 ? this.createAllCM(xSParticleDecl) : this.createDFACM(xSParticleDecl);
        this.fNodeFactory.resetNodeCount();
        if (xSCMValidator == null) {
            xSCMValidator = fEmptyCM;
        }
        return xSCMValidator;
    }

    XSCMValidator createAllCM(XSParticleDecl xSParticleDecl) {
        if (xSParticleDecl.fMaxOccurs == 0) {
            return null;
        }
        XSModelGroupImpl xSModelGroupImpl = (XSModelGroupImpl)xSParticleDecl.fValue;
        XSAllCM xSAllCM = new XSAllCM(xSParticleDecl.fMinOccurs == 0, xSModelGroupImpl.fParticleCount);
        int n = 0;
        while (n < xSModelGroupImpl.fParticleCount) {
            xSAllCM.addElement((XSElementDecl)xSModelGroupImpl.fParticles[n].fValue, xSModelGroupImpl.fParticles[n].fMinOccurs == 0);
            ++n;
        }
        return xSAllCM;
    }

    XSCMValidator createDFACM(XSParticleDecl xSParticleDecl) {
        this.fLeafCount = 0;
        this.fParticleCount = 0;
        CMNode cMNode = this.buildSyntaxTree(xSParticleDecl);
        if (cMNode == null) {
            return null;
        }
        return new XSDFACM(cMNode, this.fLeafCount);
    }

    private CMNode buildSyntaxTree(XSParticleDecl xSParticleDecl) {
        int n = xSParticleDecl.fMaxOccurs;
        int n2 = xSParticleDecl.fMinOccurs;
        short s = xSParticleDecl.fType;
        CMNode cMNode = null;
        if (s == 2 || s == 1) {
            cMNode = this.fNodeFactory.getCMLeafNode(xSParticleDecl.fType, xSParticleDecl.fValue, this.fParticleCount++, this.fLeafCount++);
            cMNode = this.expandContentModel(cMNode, n2, n);
        } else if (s == 3) {
            XSModelGroupImpl xSModelGroupImpl = (XSModelGroupImpl)xSParticleDecl.fValue;
            CMNode cMNode2 = null;
            boolean bl = false;
            int n3 = 0;
            while (n3 < xSModelGroupImpl.fParticleCount) {
                cMNode2 = this.buildSyntaxTree(xSModelGroupImpl.fParticles[n3]);
                if (cMNode2 != null) {
                    if (cMNode == null) {
                        cMNode = cMNode2;
                    } else {
                        cMNode = this.fNodeFactory.getCMBinOpNode(xSModelGroupImpl.fCompositor, cMNode, cMNode2);
                        bl = true;
                    }
                }
                ++n3;
            }
            if (cMNode != null) {
                if (xSModelGroupImpl.fCompositor == 101 && !bl && xSModelGroupImpl.fParticleCount > 1) {
                    cMNode = this.fNodeFactory.getCMUniOpNode(5, cMNode);
                }
                cMNode = this.expandContentModel(cMNode, n2, n);
            }
        }
        return cMNode;
    }

    private CMNode expandContentModel(CMNode cMNode, int n, int n2) {
        CMNode cMNode2 = null;
        if (n == 1 && n2 == 1) {
            cMNode2 = cMNode;
        } else if (n == 0 && n2 == 1) {
            cMNode2 = this.fNodeFactory.getCMUniOpNode(5, cMNode);
        } else if (n == 0 && n2 == -1) {
            cMNode2 = this.fNodeFactory.getCMUniOpNode(4, cMNode);
        } else if (n == 1 && n2 == -1) {
            cMNode2 = this.fNodeFactory.getCMUniOpNode(6, cMNode);
        } else if (n2 == -1) {
            cMNode2 = this.fNodeFactory.getCMUniOpNode(6, cMNode);
            cMNode2 = this.fNodeFactory.getCMBinOpNode(102, this.multiNodes(cMNode, n - 1, true), cMNode2);
        } else {
            if (n > 0) {
                cMNode2 = this.multiNodes(cMNode, n, false);
            }
            if (n2 > n) {
                cMNode = this.fNodeFactory.getCMUniOpNode(5, cMNode);
                cMNode2 = cMNode2 == null ? this.multiNodes(cMNode, n2 - n, false) : this.fNodeFactory.getCMBinOpNode(102, cMNode2, this.multiNodes(cMNode, n2 - n, true));
            }
        }
        return cMNode2;
    }

    private CMNode multiNodes(CMNode cMNode, int n, boolean bl) {
        if (n == 0) {
            return null;
        }
        if (n == 1) {
            return bl ? this.copyNode(cMNode) : cMNode;
        }
        int n2 = n / 2;
        return this.fNodeFactory.getCMBinOpNode(102, this.multiNodes(cMNode, n2, bl), this.multiNodes(cMNode, n - n2, true));
    }

    private CMNode copyNode(CMNode cMNode) {
        int n = cMNode.type();
        if (n == 101 || n == 102) {
            XSCMBinOp xSCMBinOp = (XSCMBinOp)cMNode;
            cMNode = this.fNodeFactory.getCMBinOpNode(n, this.copyNode(xSCMBinOp.getLeft()), this.copyNode(xSCMBinOp.getRight()));
        } else if (n == 4 || n == 6 || n == 5) {
            XSCMUniOp xSCMUniOp = (XSCMUniOp)cMNode;
            cMNode = this.fNodeFactory.getCMUniOpNode(n, this.copyNode(xSCMUniOp.getChild()));
        } else if (n == 1 || n == 2) {
            XSCMLeaf xSCMLeaf = (XSCMLeaf)cMNode;
            cMNode = this.fNodeFactory.getCMLeafNode(xSCMLeaf.type(), xSCMLeaf.getLeaf(), xSCMLeaf.getParticleId(), this.fLeafCount++);
        }
        return cMNode;
    }
}

