/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.parsers;

import com.sun.org.apache.xerces.internal.dom.ASModelImpl;
import com.sun.org.apache.xerces.internal.dom3.as.ASModel;
import com.sun.org.apache.xerces.internal.dom3.as.DOMASBuilder;
import com.sun.org.apache.xerces.internal.dom3.as.DOMASException;
import com.sun.org.apache.xerces.internal.impl.xs.SchemaGrammar;
import com.sun.org.apache.xerces.internal.impl.xs.XSGrammarBucket;
import com.sun.org.apache.xerces.internal.parsers.DOMParserImpl;
import com.sun.org.apache.xerces.internal.parsers.XMLGrammarCachingConfiguration;
import com.sun.org.apache.xerces.internal.util.SymbolTable;
import com.sun.org.apache.xerces.internal.util.XMLGrammarPoolImpl;
import com.sun.org.apache.xerces.internal.xni.XNIException;
import com.sun.org.apache.xerces.internal.xni.grammars.Grammar;
import com.sun.org.apache.xerces.internal.xni.grammars.XMLGrammarPool;
import com.sun.org.apache.xerces.internal.xni.parser.XMLInputSource;
import java.util.Vector;
import org.w3c.dom.ls.LSInput;

public class DOMASBuilderImpl
extends DOMParserImpl
implements DOMASBuilder {
    protected static final String SCHEMA_FULL_CHECKING = "http://apache.org/xml/features/validation/schema-full-checking";
    protected static final String ERROR_REPORTER = "http://apache.org/xml/properties/internal/error-reporter";
    protected static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    protected static final String ENTITY_MANAGER = "http://apache.org/xml/properties/internal/entity-manager";
    protected XSGrammarBucket fGrammarBucket;
    protected ASModelImpl fAbstractSchema;

    public DOMASBuilderImpl() {
        super(new XMLGrammarCachingConfiguration());
    }

    public DOMASBuilderImpl(XMLGrammarCachingConfiguration xMLGrammarCachingConfiguration) {
        super(xMLGrammarCachingConfiguration);
    }

    public DOMASBuilderImpl(SymbolTable symbolTable) {
        super(new XMLGrammarCachingConfiguration(symbolTable));
    }

    public DOMASBuilderImpl(SymbolTable symbolTable, XMLGrammarPool xMLGrammarPool) {
        super(new XMLGrammarCachingConfiguration(symbolTable, xMLGrammarPool));
    }

    public ASModel getAbstractSchema() {
        return this.fAbstractSchema;
    }

    public void setAbstractSchema(ASModel aSModel) {
        this.fAbstractSchema = (ASModelImpl)aSModel;
        XMLGrammarPool xMLGrammarPool = (XMLGrammarPool)this.fConfiguration.getProperty("http://apache.org/xml/properties/internal/grammar-pool");
        if (xMLGrammarPool == null) {
            xMLGrammarPool = new XMLGrammarPoolImpl();
            this.fConfiguration.setProperty("http://apache.org/xml/properties/internal/grammar-pool", xMLGrammarPool);
        }
        if (this.fAbstractSchema != null) {
            this.initGrammarPool(this.fAbstractSchema, xMLGrammarPool);
        }
    }

    public ASModel parseASURI(String string) throws DOMASException, Exception {
        XMLInputSource xMLInputSource = new XMLInputSource(null, string, null);
        return this.parseASInputSource(xMLInputSource);
    }

    public ASModel parseASInputSource(LSInput lSInput) throws DOMASException, Exception {
        XMLInputSource xMLInputSource = this.dom2xmlInputSource(lSInput);
        try {
            return this.parseASInputSource(xMLInputSource);
        }
        catch (XNIException xNIException) {
            Exception exception = xNIException.getException();
            throw exception;
        }
    }

    ASModel parseASInputSource(XMLInputSource xMLInputSource) throws Exception {
        if (this.fGrammarBucket == null) {
            this.fGrammarBucket = new XSGrammarBucket();
        }
        this.initGrammarBucket();
        XMLGrammarCachingConfiguration xMLGrammarCachingConfiguration = (XMLGrammarCachingConfiguration)this.fConfiguration;
        xMLGrammarCachingConfiguration.lockGrammarPool();
        SchemaGrammar schemaGrammar = xMLGrammarCachingConfiguration.parseXMLSchema(xMLInputSource);
        xMLGrammarCachingConfiguration.unlockGrammarPool();
        ASModelImpl aSModelImpl = null;
        if (schemaGrammar != null) {
            aSModelImpl = new ASModelImpl();
            this.fGrammarBucket.putGrammar(schemaGrammar, true);
            this.addGrammars(aSModelImpl, this.fGrammarBucket);
        }
        return aSModelImpl;
    }

    private void initGrammarBucket() {
        this.fGrammarBucket.reset();
        if (this.fAbstractSchema != null) {
            this.initGrammarBucketRecurse(this.fAbstractSchema);
        }
    }

    private void initGrammarBucketRecurse(ASModelImpl aSModelImpl) {
        if (aSModelImpl.getGrammar() != null) {
            this.fGrammarBucket.putGrammar(aSModelImpl.getGrammar());
        }
        int n = 0;
        while (n < aSModelImpl.getInternalASModels().size()) {
            ASModelImpl aSModelImpl2 = (ASModelImpl)aSModelImpl.getInternalASModels().elementAt(n);
            this.initGrammarBucketRecurse(aSModelImpl2);
            ++n;
        }
    }

    private void addGrammars(ASModelImpl aSModelImpl, XSGrammarBucket xSGrammarBucket) {
        SchemaGrammar[] schemaGrammarArray = xSGrammarBucket.getGrammars();
        int n = 0;
        while (n < schemaGrammarArray.length) {
            ASModelImpl aSModelImpl2 = new ASModelImpl();
            aSModelImpl2.setGrammar(schemaGrammarArray[n]);
            aSModelImpl.addASModel(aSModelImpl2);
            ++n;
        }
    }

    private void initGrammarPool(ASModelImpl aSModelImpl, XMLGrammarPool xMLGrammarPool) {
        Grammar[] grammarArray = new Grammar[1];
        grammarArray[0] = aSModelImpl.getGrammar();
        if (grammarArray[0] != null) {
            xMLGrammarPool.cacheGrammars(grammarArray[0].getGrammarDescription().getGrammarType(), grammarArray);
        }
        Vector vector = aSModelImpl.getInternalASModels();
        int n = 0;
        while (n < vector.size()) {
            this.initGrammarPool((ASModelImpl)vector.elementAt(n), xMLGrammarPool);
            ++n;
        }
    }
}

