/*
 * Decompiled with CFR 0.152.
 */
package com.whirlycott.cache.policy;

import com.whirlycott.cache.CacheConfiguration;
import com.whirlycott.cache.CacheMaintenancePolicy;
import com.whirlycott.cache.ManagedCache;
import com.whirlycott.cache.Messages;
import com.whirlycott.cache.policy.UsedComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LRUMaintenancePolicy
implements CacheMaintenancePolicy {
    private static final Log log = LogFactory.getLog((Class)(class$com$whirlycott$cache$policy$LRUMaintenancePolicy == null ? (class$com$whirlycott$cache$policy$LRUMaintenancePolicy = LRUMaintenancePolicy.class$("com.whirlycott.cache.policy.LRUMaintenancePolicy")) : class$com$whirlycott$cache$policy$LRUMaintenancePolicy));
    protected ManagedCache managedCache = null;
    protected int maxSize;
    static /* synthetic */ Class class$com$whirlycott$cache$policy$LRUMaintenancePolicy;

    public void performMaintenance() {
        log.debug((Object)Messages.getString("LRUMaintenancePolicy.performing_lru_maintenance"));
        Object[] objectArray = new Object[]{new Integer(this.maxSize), new Integer(this.managedCache.size())};
        log.debug((Object)Messages.getCompoundString("CacheMaintenancePolicy.report_items", objectArray));
        ArrayList arrayList = new ArrayList(this.managedCache.entrySet());
        int n = this.managedCache.size();
        if (this.maxSize < n) {
            Object[] objectArray2 = new Object[]{new Integer(n - this.maxSize)};
            log.debug((Object)Messages.getCompoundString("CacheMaintenancePolicy.clearing_approximately", objectArray2));
            Collections.sort(arrayList, new UsedComparator());
            List list = arrayList.subList(0, n - this.maxSize);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                if (entry == null) continue;
                this.managedCache.remove(entry.getKey());
            }
            log.debug((Object)(Messages.getString("LRUMaintenancePolicy.new_size") + this.managedCache.size()));
        }
    }

    public void setCache(ManagedCache managedCache) {
        this.managedCache = managedCache;
    }

    public void setConfiguration(CacheConfiguration cacheConfiguration) {
        this.maxSize = cacheConfiguration.getMaxSize();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

