/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util;

import edu.emory.mathcs.backport.java.util.AbstractQueue;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.SortedSet;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PriorityQueue
extends AbstractQueue
implements Serializable {
    private static final long serialVersionUID = -7720805057305804111L;
    private static final int DEFAULT_INITIAL_CAPACITY = 11;
    private transient Object[] queue;
    private int size;
    private final Comparator comparator;
    private transient int modCount;
    private static final /* synthetic */ boolean assert;

    private final void initializeArray(Collection c) {
        int sz = c.size();
        int initialCapacity = (int)Math.min((long)sz * 110L / 100L, 0x7FFFFFFEL);
        if (initialCapacity < 1) {
            initialCapacity = 1;
        }
        this.queue = new Object[initialCapacity + 1];
    }

    private final void fillFromSorted(Collection c) {
        Iterator i = c.iterator();
        while (i.hasNext()) {
            this.queue[++this.size] = i.next();
        }
    }

    private final void fillFromUnsorted(Collection c) {
        Iterator i = c.iterator();
        while (i.hasNext()) {
            this.queue[++this.size] = i.next();
        }
        this.heapify();
    }

    /*
     * Unable to fully structure code
     */
    private final void grow(int index) {
        newlen = this.queue.length;
        if (index < newlen) {
            return;
        }
        if (index != 0x7FFFFFFF) ** GOTO lbl10
        throw new OutOfMemoryError();
lbl-1000:
        // 1 sources

        {
            if (newlen >= 0x3FFFFFFF) {
                newlen = 0x7FFFFFFF;
                continue;
            }
            newlen <<= 2;
lbl10:
            // 3 sources

            ** while (newlen <= index)
        }
lbl11:
        // 1 sources

        newQueue = new Object[newlen];
        System.arraycopy(this.queue, 0, newQueue, 0, this.queue.length);
        this.queue = newQueue;
    }

    public boolean offer(Object o) {
        if (o == null) {
            throw new NullPointerException();
        }
        ++this.modCount;
        ++this.size;
        if (this.size >= this.queue.length) {
            this.grow(this.size);
        }
        this.queue[this.size] = o;
        this.fixUp(this.size);
        return true;
    }

    public Object peek() {
        if (this.size == 0) {
            return null;
        }
        return this.queue[1];
    }

    public boolean add(Object o) {
        return this.offer(o);
    }

    public boolean remove(Object o) {
        if (o == null) {
            return false;
        }
        if (this.comparator == null) {
            int i = 1;
            while (i <= this.size) {
                if (((Comparable)this.queue[i]).compareTo(o) == 0) {
                    this.removeAt(i);
                    return true;
                }
                ++i;
            }
        } else {
            int i = 1;
            while (i <= this.size) {
                if (this.comparator.compare(this.queue[i], o) == 0) {
                    this.removeAt(i);
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public Iterator iterator() {
        return new Itr();
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        ++this.modCount;
        int i = 1;
        while (i <= this.size) {
            this.queue[i] = null;
            ++i;
        }
        this.size = 0;
    }

    public Object poll() {
        if (this.size == 0) {
            return null;
        }
        ++this.modCount;
        Object result = this.queue[1];
        this.queue[1] = this.queue[this.size];
        this.queue[this.size--] = null;
        if (this.size > 1) {
            this.fixDown(1);
        }
        return result;
    }

    private final Object removeAt(int i) {
        Object moved;
        if (!(assert || i > 0 && i <= this.size)) {
            throw new AssertionError();
        }
        ++this.modCount;
        this.queue[i] = moved = this.queue[this.size];
        this.queue[this.size--] = null;
        if (i <= this.size) {
            this.fixDown(i);
            if (this.queue[i] == moved) {
                this.fixUp(i);
                if (this.queue[i] != moved) {
                    return moved;
                }
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private final void fixUp(int k) {
        block3: {
            if (this.comparator != null) ** GOTO lbl17
            while (k > 1) {
                j = k >> 1;
                if (((Comparable)this.queue[j]).compareTo(this.queue[k]) > 0) {
                    tmp = this.queue[j];
                    this.queue[j] = this.queue[k];
                    this.queue[k] = tmp;
                    k = j;
                    continue;
                }
                break block3;
            }
            break block3;
            while (this.comparator.compare(this.queue[j = k >>> 1], this.queue[k]) > 0) {
                tmp = this.queue[j];
                this.queue[j] = this.queue[k];
                this.queue[k] = tmp;
                k = j;
lbl17:
                // 2 sources

                if (k > 1) continue;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void fixDown(int k) {
        block5: {
            if (this.comparator != null) ** GOTO lbl20
            while ((j = k << 1) <= this.size && j > 0) {
                if (j < this.size && ((Comparable)this.queue[j]).compareTo(this.queue[j + 1]) > 0) {
                    ++j;
                }
                if (((Comparable)this.queue[k]).compareTo(this.queue[j]) > 0) {
                    tmp = this.queue[j];
                    this.queue[j] = this.queue[k];
                    this.queue[k] = tmp;
                    k = j;
                    continue;
                }
                break block5;
            }
            break block5;
lbl-1000:
            // 1 sources

            {
                if (j < this.size && this.comparator.compare(this.queue[j], this.queue[j + 1]) > 0) {
                    ++j;
                }
                if (this.comparator.compare(this.queue[k], this.queue[j]) <= 0) break;
                tmp = this.queue[j];
                this.queue[j] = this.queue[k];
                this.queue[k] = tmp;
                k = j;
lbl20:
                // 2 sources

                ** while ((j = k << 1) <= this.size && j > 0)
            }
        }
    }

    private final void heapify() {
        int i = this.size / 2;
        while (i >= 1) {
            this.fixDown(i);
            --i;
        }
    }

    public Comparator comparator() {
        return this.comparator;
    }

    private final void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.queue.length);
        int i = 1;
        while (i <= this.size) {
            s.writeObject(this.queue[i]);
            ++i;
        }
    }

    private final void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int arrayLength = s.readInt();
        this.queue = new Object[arrayLength];
        int i = 1;
        while (i <= this.size) {
            this.queue[i] = s.readObject();
            ++i;
        }
    }

    private final /* synthetic */ void this() {
        this.size = 0;
        this.modCount = 0;
    }

    public PriorityQueue() {
        this(11, null);
    }

    public PriorityQueue(int initialCapacity) {
        this(initialCapacity, null);
    }

    public PriorityQueue(int initialCapacity, Comparator comparator) {
        this.this();
        if (initialCapacity < 1) {
            throw new IllegalArgumentException();
        }
        this.queue = new Object[initialCapacity + 1];
        this.comparator = comparator;
    }

    public PriorityQueue(Collection c) {
        this.this();
        this.initializeArray(c);
        if (c instanceof SortedSet) {
            SortedSet s = (SortedSet)c;
            this.comparator = s.comparator();
            this.fillFromSorted(s);
        } else if (c instanceof PriorityQueue) {
            PriorityQueue s = (PriorityQueue)c;
            this.comparator = s.comparator();
            this.fillFromSorted(s);
        } else {
            this.comparator = null;
            this.fillFromUnsorted(c);
        }
    }

    public PriorityQueue(PriorityQueue c) {
        this.this();
        this.initializeArray(c);
        this.comparator = c.comparator();
        this.fillFromSorted(c);
    }

    public PriorityQueue(SortedSet c) {
        this.this();
        this.initializeArray(c);
        this.comparator = c.comparator();
        this.fillFromSorted(c);
    }

    static {
        assert = Class.forName("[Ledu.emory.mathcs.backport.java.util.PriorityQueue;").getComponentType().desiredAssertionStatus() ^ true;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class Itr
    implements Iterator {
        private int cursor;
        private int lastRet;
        private int expectedModCount;
        private ArrayList forgetMeNot;
        private Object lastRetElt;

        public boolean hasNext() {
            boolean bl = false;
            if (this.cursor <= PriorityQueue.this.size || this.forgetMeNot != null) {
                bl = true;
            }
            return bl;
        }

        public Object next() {
            Object result;
            this.checkForComodification();
            if (this.cursor <= PriorityQueue.this.size) {
                result = PriorityQueue.this.queue[this.cursor];
                this.lastRet = this.cursor++;
            } else {
                if (this.forgetMeNot == null) {
                    throw new NoSuchElementException();
                }
                int remaining = this.forgetMeNot.size();
                result = this.forgetMeNot.remove(remaining - 1);
                if (remaining == 1) {
                    this.forgetMeNot = null;
                }
                this.lastRet = 0;
                this.lastRetElt = result;
            }
            return result;
        }

        public void remove() {
            this.checkForComodification();
            if (this.lastRet != 0) {
                Object moved = PriorityQueue.this.removeAt(this.lastRet);
                this.lastRet = 0;
                if (moved == null) {
                    --this.cursor;
                } else {
                    if (this.forgetMeNot == null) {
                        this.forgetMeNot = new ArrayList();
                    }
                    this.forgetMeNot.add(moved);
                }
            } else if (this.lastRetElt != null) {
                PriorityQueue.this.remove(this.lastRetElt);
                this.lastRetElt = null;
            } else {
                throw new IllegalStateException();
            }
            this.expectedModCount = PriorityQueue.this.modCount;
        }

        final void checkForComodification() {
            if (PriorityQueue.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }

        private final /* synthetic */ void this() {
            this.cursor = 1;
            this.lastRet = 0;
            this.expectedModCount = PriorityQueue.this.modCount;
            this.forgetMeNot = null;
            this.lastRetElt = null;
        }

        private Itr() {
            this.this();
        }
    }
}

