/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.types;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.SimpleTimeZone;
import java.util.StringTokenizer;
import java.util.TimeZone;
import org.exolab.castor.types.OperationNotSupportedException;
import org.exolab.castor.types.TimePeriod;

public class Month
extends TimePeriod {
    private static final boolean DEBUG = false;
    private static final String MONTH_FORMAT = "yyyy-MM";

    public Month() {
        super("P1M");
        int n = TimeZone.getDefault().getRawOffset();
        if (n < 0) {
            n = -n;
            try {
                super.setZoneNegative();
            }
            catch (OperationNotSupportedException operationNotSupportedException) {
                // empty catch block
            }
        }
        short s = (short)(n / 3600000);
        short s2 = (short)((n %= 3600000) / 60000);
        try {
            super.setZone(s, s2);
        }
        catch (OperationNotSupportedException operationNotSupportedException) {
            // empty catch block
        }
    }

    public void setDay(short s) throws OperationNotSupportedException {
        String string = "In a Month : the day field must not be changed";
        throw new OperationNotSupportedException(string);
    }

    public void setHour(short s) throws OperationNotSupportedException {
        String string = "In a Month : the hour field must not be changed";
        throw new OperationNotSupportedException(string);
    }

    public void setMinute(short s) throws OperationNotSupportedException {
        String string = "In a Month : the minute field must not be changed";
        throw new OperationNotSupportedException(string);
    }

    public void setSecond(short s, short s2) throws OperationNotSupportedException {
        String string = "In a Month : the second fields must not be changed";
        throw new OperationNotSupportedException(string);
    }

    public void setZone(short s, short s2) throws OperationNotSupportedException {
        String string = "In a Month : the time zone fields must not be changed";
        throw new OperationNotSupportedException(string);
    }

    public void setZoneNegative() throws OperationNotSupportedException {
        String string = "In a Month : the tinme zone fields must not be changed";
        throw new OperationNotSupportedException(string);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getCentury());
        if (stringBuffer.length() == 1) {
            stringBuffer.insert(0, 0);
        }
        if (this.getYear() / 10 == 0) {
            stringBuffer.append(0);
        }
        stringBuffer.append(this.getYear());
        stringBuffer.append('-');
        if (this.getMonth() / 10 == 0) {
            stringBuffer.append(0);
        }
        stringBuffer.append(this.getMonth());
        if (this.isNegative()) {
            stringBuffer.insert(0, '-');
        }
        return stringBuffer.toString();
    }

    public static Object parse(String string) throws ParseException {
        return Month.parseMonth(string);
    }

    public static Month parseMonth(String string) throws ParseException {
        StringTokenizer stringTokenizer;
        Month month = new Month();
        if (string.startsWith("-")) {
            month.setNegative();
        }
        if ((stringTokenizer = new StringTokenizer(string, "-")).countTokens() != 2) {
            throw new ParseException(string + ": Bad XML Schema Month type format (CCYY-MM)", 0);
        }
        String string2 = stringTokenizer.nextToken();
        if (string2.length() != 4) {
            throw new ParseException(string + ": Bad year format", 1);
        }
        month.setCentury(Short.parseShort(string2.substring(0, 2)));
        try {
            month.setYear(Short.parseShort(string2.substring(2, 4)));
        }
        catch (OperationNotSupportedException operationNotSupportedException) {
            // empty catch block
        }
        string2 = stringTokenizer.nextToken();
        if (string2.length() != 2) {
            throw new ParseException(string + ": Bad month format", 5);
        }
        try {
            month.setMonth(Short.parseShort(string2));
        }
        catch (OperationNotSupportedException operationNotSupportedException) {
            // empty catch block
        }
        string2 = null;
        return month;
    }

    public Date toDate() throws ParseException {
        Date date = null;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(MONTH_FORMAT);
        SimpleTimeZone simpleTimeZone = new SimpleTimeZone(0, "UTC");
        if (!this.isUTC()) {
            int n = 0;
            n = (this.getZoneMinute() + this.getZoneHour() * 60) * 60 * 1000;
            n = this.isZoneNegative() ? -n : n;
            simpleTimeZone.setRawOffset(n);
            simpleTimeZone.setID(TimeZone.getAvailableIDs(n)[0]);
        }
        simpleDateFormat.setTimeZone(simpleTimeZone);
        date = simpleDateFormat.parse(this.toString());
        return date;
    }
}

