/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema.util;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import org.exolab.castor.util.Configuration;
import org.exolab.castor.util.NestedIOException;
import org.exolab.castor.xml.schema.Order;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.util.XMLInstance2SchemaHandler;
import org.exolab.castor.xml.schema.writer.SchemaWriter;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;

public class XMLInstance2Schema {
    private InputSource _source = null;
    private Schema _schema = null;
    private Order _defaultGroup = Order.seq;

    public Schema createSchema(String string) throws IOException {
        return this.createSchema(new InputSource(string));
    }

    public Schema createSchema(Reader reader) throws IOException {
        return this.createSchema(new InputSource(reader));
    }

    public Schema createSchema(InputSource inputSource) throws IOException {
        XMLInstance2SchemaHandler xMLInstance2SchemaHandler = new XMLInstance2SchemaHandler();
        xMLInstance2SchemaHandler.setDefaultGroupOrder(this._defaultGroup);
        try {
            Parser parser = Configuration.getParser();
            if (parser == null) {
                throw new IOException("fatal error: unable to create SAX parser.");
            }
            parser.setDocumentHandler(xMLInstance2SchemaHandler);
            parser.setErrorHandler(xMLInstance2SchemaHandler);
            parser.parse(inputSource);
        }
        catch (SAXException sAXException) {
            throw new NestedIOException(sAXException);
        }
        return xMLInstance2SchemaHandler.getSchema();
    }

    public void setDefaultGroupingAsAll() {
        this._defaultGroup = Order.all;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.out.println("Missing filename");
            System.out.println();
            System.out.println("usage: java XMLInstance2Schema <input-file> [<output-file> (optional)]");
            return;
        }
        try {
            XMLInstance2Schema xMLInstance2Schema = new XMLInstance2Schema();
            Schema schema = xMLInstance2Schema.createSchema(stringArray[0]);
            Writer writer = null;
            SchemaWriter schemaWriter = null;
            writer = stringArray.length > 1 ? new FileWriter(stringArray[1]) : new PrintWriter(System.out, true);
            schemaWriter = new SchemaWriter(writer);
            schemaWriter.write(schema);
            writer.flush();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

