/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.util;

import org.exolab.castor.xml.XMLFieldDescriptor;

public class XMLFieldDescriptors {
    private int DEFAULT_SIZE;
    private XMLFieldDescriptor[] elements;
    private int initialSize;
    private int elementCount;

    public XMLFieldDescriptors() {
        this.initialSize = this.DEFAULT_SIZE = 11;
        this.elementCount = 0;
        this.elements = new XMLFieldDescriptor[this.DEFAULT_SIZE];
    }

    public XMLFieldDescriptors(int n) {
        this.initialSize = this.DEFAULT_SIZE = 11;
        this.elementCount = 0;
        this.initialSize = n;
        this.elements = new XMLFieldDescriptor[n];
    }

    public boolean add(XMLFieldDescriptor xMLFieldDescriptor) {
        int n = 0;
        while (n < this.elementCount) {
            if (this.elements[n] == xMLFieldDescriptor) {
                return false;
            }
            ++n;
        }
        if (this.elementCount == this.elements.length) {
            this.increaseSize();
        }
        this.elements[this.elementCount++] = xMLFieldDescriptor;
        return true;
    }

    public void clear() {
        int n = 0;
        while (n < this.elementCount) {
            this.elements[n] = null;
            ++n;
        }
        this.elementCount = 0;
    }

    public Object clone() {
        Object object = null;
        try {
            object = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return object;
    }

    public boolean contains(XMLFieldDescriptor xMLFieldDescriptor) {
        return this.indexOf(xMLFieldDescriptor) >= 0;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof XMLFieldDescriptors)) {
            return false;
        }
        XMLFieldDescriptors xMLFieldDescriptors = (XMLFieldDescriptors)object;
        if (xMLFieldDescriptors.elementCount != this.elementCount) {
            return false;
        }
        int n = 0;
        while (n < this.elementCount) {
            XMLFieldDescriptor xMLFieldDescriptor = this.get(n);
            XMLFieldDescriptor xMLFieldDescriptor2 = xMLFieldDescriptors.elements[n];
            if (!(xMLFieldDescriptor == null ? xMLFieldDescriptor2 == null : xMLFieldDescriptor.equals(xMLFieldDescriptor2))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public XMLFieldDescriptor get(int n) throws IndexOutOfBoundsException {
        if (n < 0 || n >= this.elementCount) {
            throw new IndexOutOfBoundsException();
        }
        return this.elements[n];
    }

    public int hashCode() {
        int n = 1;
        int n2 = 0;
        while (n2 < this.elementCount) {
            XMLFieldDescriptor xMLFieldDescriptor = this.elements[n2];
            n = 31 * n + (xMLFieldDescriptor == null ? 0 : xMLFieldDescriptor.hashCode());
            ++n2;
        }
        return n;
    }

    public int indexOf(XMLFieldDescriptor xMLFieldDescriptor) {
        if (xMLFieldDescriptor == null) {
            int n = 0;
            while (n < this.elementCount) {
                if (this.elements[n] == null) {
                    return n;
                }
                ++n;
            }
        } else {
            int n = 0;
            while (n < this.elementCount) {
                if (xMLFieldDescriptor.equals(this.elements[n])) {
                    return n;
                }
                ++n;
            }
        }
        return -1;
    }

    public boolean isEmpty() {
        return this.elementCount == 0;
    }

    public XMLFieldDescriptor remove(int n) {
        if (n < 0 || n > this.elementCount) {
            return null;
        }
        XMLFieldDescriptor xMLFieldDescriptor = this.elements[n];
        this.shiftDown(n + 1);
        --this.elementCount;
        return xMLFieldDescriptor;
    }

    public boolean remove(XMLFieldDescriptor xMLFieldDescriptor) {
        int n = this.indexOf(xMLFieldDescriptor);
        if (n > -1) {
            this.remove(n);
            return true;
        }
        return false;
    }

    public void trimToSize() {
        if (this.elements.length == this.elementCount) {
            return;
        }
        XMLFieldDescriptor[] xMLFieldDescriptorArray = this.elements;
        this.elements = new XMLFieldDescriptor[this.elementCount];
        System.arraycopy(xMLFieldDescriptorArray, 0, this.elements, 0, this.elementCount);
        xMLFieldDescriptorArray = null;
    }

    public int size() {
        return this.elementCount;
    }

    public XMLFieldDescriptor[] toArray() {
        XMLFieldDescriptor[] xMLFieldDescriptorArray = new XMLFieldDescriptor[this.elementCount];
        System.arraycopy(this.elements, 0, xMLFieldDescriptorArray, 0, this.elementCount);
        return xMLFieldDescriptorArray;
    }

    public XMLFieldDescriptor[] toArray(XMLFieldDescriptor[] xMLFieldDescriptorArray) {
        return this.toArray(xMLFieldDescriptorArray, 0);
    }

    public XMLFieldDescriptor[] toArray(XMLFieldDescriptor[] xMLFieldDescriptorArray, int n) {
        XMLFieldDescriptor[] xMLFieldDescriptorArray2 = null;
        xMLFieldDescriptorArray2 = xMLFieldDescriptorArray.length >= this.elementCount ? xMLFieldDescriptorArray : new XMLFieldDescriptor[this.elementCount];
        System.arraycopy(this.elements, 0, xMLFieldDescriptorArray2, n, this.elementCount);
        return xMLFieldDescriptorArray2;
    }

    private void increaseSize() {
        XMLFieldDescriptor[] xMLFieldDescriptorArray = this.elements;
        int n = xMLFieldDescriptorArray.length > 0 ? xMLFieldDescriptorArray.length : 1;
        this.elements = new XMLFieldDescriptor[n * 3 / 2 + 1];
        System.arraycopy(xMLFieldDescriptorArray, 0, this.elements, 0, xMLFieldDescriptorArray.length);
        xMLFieldDescriptorArray = null;
    }

    private void shiftDown(int n) {
        if (n <= 0 || n >= this.elementCount) {
            return;
        }
        System.arraycopy(this.elements, n, this.elements, n - 1, this.elementCount - n);
        this.elements[this.elementCount - 1] = null;
    }

    private void shiftUp(int n) {
        if (n == this.elementCount) {
            return;
        }
        if (this.elementCount == this.elements.length) {
            this.increaseSize();
        }
        System.arraycopy(this.elements, n, this.elements, n + 1, this.elementCount - n);
    }
}

