/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsrp4j.exception;

import org.apache.wsrp4j.exception.Messages;

public class WSRPException
extends Exception {
    private int errCode = 0;
    private Throwable nestedThrowable = null;
    private static final int COMMON_EXCEPTION = 1;
    private static final int CONSUMER_EXCEPTION = 2;
    private static final int PRODUCER_EXCEPTION = 4;
    private static final int PROVIDER_EXCEPTION = 8;
    private int exceptionRange = 0;

    public WSRPException() {
        this(0, null);
    }

    public WSRPException(int errorCode) {
        this(errorCode, null);
    }

    public WSRPException(int errorCode, Throwable t) {
        super(Messages.get(errorCode));
        this.errCode = errorCode;
        this.nestedThrowable = t;
    }

    public int getErrorCode() {
        return this.errCode;
    }

    public Throwable getNestedThrowable() {
        return this.nestedThrowable;
    }

    public String toString() {
        StringBuffer s = new StringBuffer(this.getClass().getName());
        s.append(": ");
        s.append(this.getMessage());
        if (this.nestedThrowable != null) {
            s.append("\n\nNested Throwable is:\n");
            s.append(this.nestedThrowable.toString());
        }
        return s.toString();
    }

    public String toHTMLString() {
        StringBuffer s = new StringBuffer();
        s.append("<H2>Exception occured!</H2><br>");
        s.append("<b>" + this.getClass().getName() + "</><br>");
        s.append("   Message = " + this.getMessage() + "<br>");
        s.append("   Type    = " + this.getExceptionRange() + "<br>");
        if (this.nestedThrowable != null) {
            Throwable t = this.nestedThrowable;
            s.append("<H3>Exception stack:</H3>");
            while (t != null) {
                s.append("<br><b>" + t.getClass().getName() + "</><br>");
                if (t instanceof WSRPException) {
                    s.append("   Message = " + ((WSRPException)t).getMessage() + "<br>");
                    s.append("   Type    = " + ((WSRPException)t).getExceptionRange() + "<br>");
                    t = ((WSRPException)t).getNestedThrowable();
                    continue;
                }
                s.append("   Message = " + t.getMessage() + "<br>");
                t = null;
            }
        }
        return s.toString();
    }

    public int getExceptionRange() {
        return this.exceptionRange;
    }

    public void setCommonExceptionRange() {
        this.exceptionRange = 1;
    }

    public void setConsumerExceptionRange() {
        this.exceptionRange = 2;
    }

    public void setProducerExceptionRange() {
        this.exceptionRange = 4;
    }

    public void setProviderExceptionRange() {
        this.exceptionRange = 8;
    }
}

