/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsrp4j.log;

import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.apache.wsrp4j.log.Logger;

public final class LoggerImpl
implements Logger {
    private org.apache.log4j.Logger logger = null;
    private int level = 10;

    LoggerImpl(org.apache.log4j.Logger aLogger, int logLevel) {
        this.logger = aLogger;
        this.level = logLevel;
    }

    public boolean isLogging(int logLevel) {
        Level log4jLevel = this.determineLog4jLevel(logLevel);
        if (log4jLevel != Level.OFF) {
            return logLevel <= this.level && this.logger.isEnabledFor((Priority)log4jLevel);
        }
        return false;
    }

    public void text(int logLevel, String loggingMethod, String text) {
        this.text(logLevel, loggingMethod, text, null);
    }

    public void text(int logLevel, String loggingMethod, String text, Object parm1) {
        this.text(logLevel, loggingMethod, text, new Object[]{parm1});
    }

    public void text(int logLevel, String loggingMethod, String text, Object[] parms) {
        this.text(logLevel, loggingMethod, null, text, parms);
    }

    public void text(int logLevel, String loggingMethod, Throwable t, String text) {
        this.text(logLevel, loggingMethod, t, text, null);
    }

    public void text(int logLevel, String loggingMethod, Throwable t, String text, Object[] parms) {
        if (!this.isLogging(logLevel)) {
            return;
        }
        Level log4jLevel = this.determineLog4jLevel(logLevel);
        StringBuffer msgBuffer = new StringBuffer();
        if (loggingMethod != null) {
            msgBuffer.append(loggingMethod);
            msgBuffer.append(" - ");
        }
        if (text != null) {
            msgBuffer.append(text);
        }
        if (parms != null) {
            msgBuffer.append("\nParameters:\n");
            for (int i = 0; i < parms.length; ++i) {
                msgBuffer.append(parms[i]);
            }
        }
        this.logger.log((Priority)log4jLevel, (Object)msgBuffer.toString(), t);
    }

    public void entry(int logLevel, String loggingMethod) {
        this.entry(logLevel, loggingMethod, null);
    }

    public void entry(int logLevel, String loggingMethod, Object parm1) {
        this.entry(logLevel, loggingMethod, new Object[]{parm1});
    }

    public void entry(int logLevel, String loggingMethod, Object[] parms) {
        this.text(logLevel, loggingMethod, "Entering method", parms);
    }

    public void exit(int logLevel, String loggingMethod) {
        this.text(logLevel, loggingMethod, "Exiting method.");
    }

    public void exit(int logLevel, String loggingMethod, byte retValue) {
        this.exit(logLevel, loggingMethod, new Byte(retValue));
    }

    public void exit(int logLevel, String loggingMethod, short retValue) {
        this.exit(logLevel, loggingMethod, new Short(retValue));
    }

    public void exit(int logLevel, String loggingMethod, int retValue) {
        this.exit(logLevel, loggingMethod, new Integer(retValue));
    }

    public void exit(int logLevel, String loggingMethod, long retValue) {
        this.exit(logLevel, loggingMethod, new Long(retValue));
    }

    public void exit(int logLevel, String loggingMethod, float retValue) {
        this.exit(logLevel, loggingMethod, new Float(retValue));
    }

    public void exit(int logLevel, String loggingMethod, double retValue) {
        this.exit(logLevel, loggingMethod, new Double(retValue));
    }

    public void exit(int logLevel, String loggingMethod, char retValue) {
        this.exit(logLevel, loggingMethod, new Character(retValue));
    }

    public void exit(int logLevel, String loggingMethod, boolean retValue) {
        this.exit(logLevel, loggingMethod, new Boolean(retValue));
    }

    public void exit(int logLevel, String loggingMethod, Object retValue) {
        this.text(logLevel, loggingMethod, "Exiting method. Returned value: {0}", retValue);
    }

    public void stackTrace(int logLevel, String loggingMethod, String text) {
        this.text(logLevel, loggingMethod, new Throwable("Stacktrace"), text);
    }

    private Level determineLog4jLevel(int wsrp4jLevel) {
        if (wsrp4jLevel < 10) {
            return Level.OFF;
        }
        if (wsrp4jLevel < 20) {
            return Level.ERROR;
        }
        if (wsrp4jLevel < 30) {
            return Level.WARN;
        }
        if (wsrp4jLevel < 40) {
            return Level.INFO;
        }
        if (wsrp4jLevel < 60) {
            return Level.DEBUG;
        }
        return Level.ALL;
    }
}

