/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsrp4j.persistence.xml.driver;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.wsrp4j.consumer.app.driver.PageImpl;
import org.apache.wsrp4j.consumer.driver.ConsumerPortletContext;
import org.apache.wsrp4j.consumer.driver.ProducerImpl;
import org.apache.wsrp4j.consumer.driver.UserImpl;
import org.apache.wsrp4j.consumer.driver.WSRPPortletImpl;
import org.apache.wsrp4j.log.LogManager;
import org.apache.wsrp4j.log.Logger;
import org.apache.wsrp4j.persistence.PersistentInformation;
import org.apache.wsrp4j.persistence.xml.ClientPersistentInformationProvider;
import org.apache.wsrp4j.persistence.xml.driver.ConsumerPortletContextList;
import org.apache.wsrp4j.persistence.xml.driver.PageList;
import org.apache.wsrp4j.persistence.xml.driver.PersistentInformationImpl;
import org.apache.wsrp4j.persistence.xml.driver.PortletList;
import org.apache.wsrp4j.persistence.xml.driver.ProducerList;
import org.apache.wsrp4j.persistence.xml.driver.UserList;

public class ClientPersistentInformationProviderImpl
implements ClientPersistentInformationProvider {
    private ClientPersistentInformationProvider _persistentInfoProvider = null;
    private static final String CONSUMER_PERSISTENTSTORE = "consumer.persistentstore";
    private Logger logger = LogManager.getLogManager().getLogger(this.getClass());
    private static final String PORTLETS = "portlets";
    private static final String USERS = "users";
    private static final String PAGES = "pages";
    private static final String PRODUCERS = "producers";
    private static final String PORTLET_MAPPING = "PortletMapping";
    private static final String PAGE_MAPPING = "PageMapping";
    private static final String USER_MAPPING = "UserMapping";
    private static final String PRODUCER_MAPPING = "ProducerMapping";
    private static String ROOT_DIR = null;
    private static String FILE_EXTENSION = ".xml";
    private static String PERSISTENT_DIR = "persistence";
    private static String SEPARATOR = "@";

    public static ClientPersistentInformationProvider create() {
        return new ClientPersistentInformationProviderImpl();
    }

    private ClientPersistentInformationProviderImpl() {
        File file = null;
        String StoreDir = null;
        try {
            InputStream is = this.getClass().getClassLoader().getResourceAsStream("SwingConsumer.properties");
            Properties props = new Properties();
            if (is != null) {
                props.load(is);
                StoreDir = (String)props.get(CONSUMER_PERSISTENTSTORE);
                is.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (StoreDir != null) {
            if (StoreDir.endsWith(File.separator)) {
                StoreDir = StoreDir.concat(File.separator);
            }
            ROOT_DIR = StoreDir + PERSISTENT_DIR;
        } else {
            file = new File("");
            ROOT_DIR = file.getAbsolutePath();
            ROOT_DIR = ROOT_DIR + File.separator + PERSISTENT_DIR;
        }
        file = new File(ROOT_DIR);
        file.mkdir();
    }

    private String getStoreDirectory(String subDirectory) {
        return ROOT_DIR + File.separator + subDirectory;
    }

    private void makeStoreSubDir(String subDirectory) {
        File file = new File(ROOT_DIR + File.separator + subDirectory);
        if (!file.exists()) {
            file.mkdir();
        }
    }

    private String getMappingFile(String mappingBaseName) {
        String mappingFile = new String(ROOT_DIR + File.separator + mappingBaseName + FILE_EXTENSION);
        return mappingFile;
    }

    public PersistentInformation getPersistentInformation(PortletList portletList) {
        PersistentInformationImpl persistentInfo = null;
        if (portletList != null) {
            persistentInfo = new PersistentInformationImpl();
            persistentInfo.setStoreDirectory(this.getStoreDirectory(PORTLETS));
            persistentInfo.setMappingFileName(this.getMappingFile(PORTLET_MAPPING));
            WSRPPortletImpl portlet = new WSRPPortletImpl();
            persistentInfo.setFilenameStub(portlet.getClass().getName());
            persistentInfo.setFilename(null);
            persistentInfo.setExtension(FILE_EXTENSION);
            persistentInfo.setSeparator(SEPARATOR);
            portletList.setPersistentInformation(persistentInfo);
            this.makeStoreSubDir(PORTLETS);
        }
        return persistentInfo;
    }

    public PersistentInformation getPersistentInformation(PageList pageList) {
        PersistentInformationImpl persistentInfo = null;
        if (pageList != null) {
            persistentInfo = new PersistentInformationImpl();
            persistentInfo.setStoreDirectory(this.getStoreDirectory(PAGES));
            persistentInfo.setMappingFileName(this.getMappingFile(PAGE_MAPPING));
            PageImpl page = new PageImpl();
            persistentInfo.setFilenameStub(page.getClass().getName());
            persistentInfo.setFilename(null);
            persistentInfo.setExtension(FILE_EXTENSION);
            persistentInfo.setSeparator(SEPARATOR);
            pageList.setPersistentInformation(persistentInfo);
            this.makeStoreSubDir(PAGES);
        }
        return persistentInfo;
    }

    public PersistentInformation getPersistentInformation(UserList userList) {
        PersistentInformationImpl persistentInfo = null;
        if (userList != null) {
            persistentInfo = new PersistentInformationImpl();
            persistentInfo.setStoreDirectory(this.getStoreDirectory(USERS));
            persistentInfo.setMappingFileName(this.getMappingFile(USER_MAPPING));
            UserImpl user = new UserImpl();
            persistentInfo.setFilenameStub(user.getClass().getName());
            persistentInfo.setFilename(null);
            persistentInfo.setExtension(FILE_EXTENSION);
            persistentInfo.setSeparator(SEPARATOR);
            userList.setPersistentInformation(persistentInfo);
            this.makeStoreSubDir(USERS);
        }
        return persistentInfo;
    }

    public PersistentInformation getPersistentInformation(ProducerList producerList) {
        PersistentInformationImpl persistentInfo = null;
        if (producerList != null) {
            persistentInfo = new PersistentInformationImpl();
            persistentInfo.setStoreDirectory(this.getStoreDirectory(PRODUCERS));
            persistentInfo.setMappingFileName(this.getMappingFile(PRODUCER_MAPPING));
            ProducerImpl producer = new ProducerImpl();
            persistentInfo.setFilenameStub(producer.getClass().getName());
            persistentInfo.setFilename(null);
            persistentInfo.setExtension(FILE_EXTENSION);
            persistentInfo.setSeparator(SEPARATOR);
            producerList.setPersistentInformation(persistentInfo);
            this.makeStoreSubDir(PRODUCERS);
        }
        return persistentInfo;
    }

    public PersistentInformation getPersistentInformation(ConsumerPortletContextList consumerPortletContextList) {
        PersistentInformationImpl persistentInfo = null;
        if (consumerPortletContextList != null) {
            persistentInfo = new PersistentInformationImpl();
            persistentInfo.setStoreDirectory(this.getStoreDirectory(PORTLETS));
            persistentInfo.setMappingFileName(null);
            ConsumerPortletContext consumerPortletContext = new ConsumerPortletContext();
            persistentInfo.setFilenameStub(consumerPortletContext.getClass().getName());
            persistentInfo.setFilename(null);
            persistentInfo.setExtension(FILE_EXTENSION);
            persistentInfo.setSeparator(SEPARATOR);
            consumerPortletContextList.setPersistentInformation(persistentInfo);
            this.makeStoreSubDir(PORTLETS);
        }
        return persistentInfo;
    }
}

