/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsrp4j.persistence.xml.driver;

import org.apache.wsrp4j.exception.WSRPException;
import org.apache.wsrp4j.exception.WSRPXHelper;
import org.apache.wsrp4j.log.LogManager;
import org.apache.wsrp4j.log.Logger;
import org.apache.wsrp4j.persistence.PersistentDataObject;
import org.apache.wsrp4j.persistence.PersistentHandler;
import org.apache.wsrp4j.persistence.PersistentInformationProvider;
import org.apache.wsrp4j.persistence.ServerPersistentFactory;
import org.apache.wsrp4j.persistence.xml.ServerPersistentInformationProvider;
import org.apache.wsrp4j.persistence.xml.driver.ConsumerConfiguredPortletList;
import org.apache.wsrp4j.persistence.xml.driver.ConsumerPortletRegistrationList;
import org.apache.wsrp4j.persistence.xml.driver.PersistentHandlerImpl;
import org.apache.wsrp4j.persistence.xml.driver.PortletDescriptionList;
import org.apache.wsrp4j.persistence.xml.driver.PortletList;
import org.apache.wsrp4j.persistence.xml.driver.ProducerList;
import org.apache.wsrp4j.persistence.xml.driver.RegistrationList;
import org.apache.wsrp4j.persistence.xml.driver.ServerPersistentInformationProviderImpl;
import org.apache.wsrp4j.persistence.xml.driver.ServiceDescriptionList;
import org.apache.wsrp4j.persistence.xml.driver.UserList;

public class ServerPersistentFactoryImpl
implements ServerPersistentFactory {
    private static ServerPersistentFactory serverPersistentFactory = null;
    private static PersistentHandler persistentHandler = null;
    private static ServerPersistentInformationProvider serverInfoProvider = null;
    private String path = null;
    private Logger logger = LogManager.getLogManager().getLogger(this.getClass());

    public PersistentHandler getPersistentHandler() {
        String MN = "getPersistentHandler";
        if (this.logger.isLogging(60)) {
            this.logger.entry(60, MN);
        }
        if (persistentHandler == null) {
            persistentHandler = PersistentHandlerImpl.create();
            if (this.logger.isLogging(50)) {
                this.logger.text(50, MN, "PersistentHandler successfully created.");
            }
        }
        if (this.logger.isLogging(60)) {
            this.logger.exit(60, MN);
        }
        return persistentHandler;
    }

    public PersistentInformationProvider getPersistentInformationProvider() {
        String MN = "getServerPersistentInformationProvider";
        if (this.logger.isLogging(60)) {
            this.logger.entry(60, MN);
        }
        if (serverInfoProvider == null && this.path == null) {
            serverInfoProvider = ServerPersistentInformationProviderImpl.create();
        } else if (serverInfoProvider == null && this.path != null) {
            serverInfoProvider = ServerPersistentInformationProviderImpl.create(this.path);
        }
        if (this.logger.isLogging(50)) {
            this.logger.text(50, MN, "ServerPersistentInformationProvider successfully created.");
        }
        if (this.logger.isLogging(60)) {
            this.logger.exit(60, MN);
        }
        return serverInfoProvider;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public PersistentDataObject getPortletList() throws WSRPException {
        String MN = "getPortletList";
        if (this.logger.isLogging(60)) {
            this.logger.entry(60, MN);
        }
        PortletList pdo = null;
        try {
            pdo = (PortletList)Class.forName("org.apache.wsrp4j.persistence.xml.driver.PortletList").newInstance();
            ((ServerPersistentInformationProvider)this.getPersistentInformationProvider()).getPersistentInformation(pdo);
        }
        catch (Exception e) {
            WSRPXHelper.throwX(this.logger, 10, MN, 1003, e);
        }
        if (this.logger.isLogging(60)) {
            this.logger.exit(60, MN);
        }
        return pdo;
    }

    public PersistentDataObject getProducerList() throws WSRPException {
        String MN = "getProducerList";
        if (this.logger.isLogging(60)) {
            this.logger.entry(60, MN);
        }
        ProducerList pdo = null;
        try {
            pdo = (ProducerList)Class.forName("org.apache.wsrp4j.persistence.xml.driver.ProducerList").newInstance();
            ((ServerPersistentInformationProvider)this.getPersistentInformationProvider()).getPersistentInformation(pdo);
        }
        catch (Exception e) {
            WSRPXHelper.throwX(this.logger, 10, MN, 1003, e);
        }
        if (this.logger.isLogging(60)) {
            this.logger.exit(60, MN);
        }
        return pdo;
    }

    public PersistentDataObject getRegistrationList() throws WSRPException {
        String MN = "getRegistrationList";
        if (this.logger.isLogging(60)) {
            this.logger.entry(60, MN);
        }
        RegistrationList pdo = null;
        try {
            pdo = (RegistrationList)Class.forName("org.apache.wsrp4j.persistence.xml.driver.RegistrationList").newInstance();
            ((ServerPersistentInformationProvider)this.getPersistentInformationProvider()).getPersistentInformation(pdo);
        }
        catch (Exception e) {
            WSRPXHelper.throwX(this.logger, 10, MN, 1003, e);
        }
        if (this.logger.isLogging(60)) {
            this.logger.exit(60, MN);
        }
        return pdo;
    }

    public PersistentDataObject getUserList() throws WSRPException {
        String MN = "getUserList";
        if (this.logger.isLogging(60)) {
            this.logger.entry(60, MN);
        }
        UserList pdo = null;
        try {
            pdo = (UserList)Class.forName("org.apache.wsrp4j.persistence.xml.driver.UserList").newInstance();
            ((ServerPersistentInformationProvider)this.getPersistentInformationProvider()).getPersistentInformation(pdo);
        }
        catch (Exception e) {
            WSRPXHelper.throwX(this.logger, 10, MN, 1003, e);
        }
        if (this.logger.isLogging(60)) {
            this.logger.exit(60, MN);
        }
        return pdo;
    }

    public PersistentDataObject getConsumerConfiguredPortletList() throws WSRPException {
        String MN = "getConsumerConfiguredPortletList";
        if (this.logger.isLogging(60)) {
            this.logger.entry(60, MN);
        }
        ConsumerConfiguredPortletList pdo = null;
        try {
            pdo = (ConsumerConfiguredPortletList)Class.forName("org.apache.wsrp4j.persistence.xml.driver.ConsumerConfiguredPortletList").newInstance();
            ((ServerPersistentInformationProvider)this.getPersistentInformationProvider()).getPersistentInformation(pdo);
        }
        catch (Exception e) {
            WSRPXHelper.throwX(this.logger, 10, MN, 1003, e);
        }
        if (this.logger.isLogging(60)) {
            this.logger.exit(60, MN);
        }
        return pdo;
    }

    public PersistentDataObject getPortletDescriptionList() throws WSRPException {
        String MN = "getPortletDescriptionList";
        if (this.logger.isLogging(60)) {
            this.logger.entry(60, MN);
        }
        PortletDescriptionList pdo = null;
        try {
            pdo = (PortletDescriptionList)Class.forName("org.apache.wsrp4j.persistence.xml.driver.PortletDescriptionList").newInstance();
            ((ServerPersistentInformationProvider)this.getPersistentInformationProvider()).getPersistentInformation(pdo);
        }
        catch (Exception e) {
            WSRPXHelper.throwX(this.logger, 10, MN, 1003, e);
        }
        if (this.logger.isLogging(60)) {
            this.logger.exit(60, MN);
        }
        return pdo;
    }

    public PersistentDataObject getServiceDescriptionList() throws WSRPException {
        String MN = "getServiceDescriptionList";
        if (this.logger.isLogging(60)) {
            this.logger.entry(60, MN);
        }
        ServiceDescriptionList pdo = null;
        try {
            pdo = (ServiceDescriptionList)Class.forName("org.apache.wsrp4j.persistence.xml.driver.ServiceDescriptionList").newInstance();
            ((ServerPersistentInformationProvider)this.getPersistentInformationProvider()).getPersistentInformation(pdo);
        }
        catch (Exception e) {
            WSRPXHelper.throwX(this.logger, 10, MN, 1003, e);
        }
        if (this.logger.isLogging(60)) {
            this.logger.exit(60, MN);
        }
        return pdo;
    }

    public PersistentDataObject getConsumerPortletRegistrationList() throws WSRPException {
        String MN = "getConsumerPortletRegistrationList";
        if (this.logger.isLogging(60)) {
            this.logger.entry(60, MN);
        }
        ConsumerPortletRegistrationList pdo = null;
        try {
            pdo = (ConsumerPortletRegistrationList)Class.forName("org.apache.wsrp4j.persistence.xml.driver.ConsumerPortletRegistrationList").newInstance();
            ((ServerPersistentInformationProvider)this.getPersistentInformationProvider()).getPersistentInformation(pdo);
        }
        catch (Exception e) {
            WSRPXHelper.throwX(this.logger, 10, MN, 1003, e);
        }
        if (this.logger.isLogging(60)) {
            this.logger.exit(60, MN);
        }
        return pdo;
    }
}

