/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsrp4j.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;
import java.util.BitSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xerces.jaxp.DocumentBuilderFactoryImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class DOMSupport {
    public static final short OUTPUT_DOM_TREE_IGNORE_TEXT_NODES = 1;
    public static final short OUTPUT_DOM_TREE_OUTPUT_TEXT_NODES_HIDE_CONTENT = 2;
    public static final short OUTPUT_DOM_TREE_OUTPUT_TEXT_NODES_FULLY = 3;
    public static final short OUTPUT_DOM_TREE_IGNORE_COMMENT_NODES = 1;
    public static final short OUTPUT_DOM_TREE_OUTPUT_COMMENT_NODES_HIDE_CONTENT = 2;
    public static final short OUTPUT_DOM_TREE_OUTPUT_COMMENT_NODES_FULLY = 3;
    private static final String XML_OUTPUT_INDENTATION_SPACE = "   ";
    private static final int MAX_PRINTABLE_TREE_DEPTH = 256;

    public static void dumpDOMNode(PrintWriter outputTarget, Node node, short textNodeOutputOption, short commentNodeOutputOption, boolean terseOutput, boolean displayHashcodes, int depth, BitSet siblingsAtDepth) {
        NamedNodeMap nnm;
        String nodeValue;
        if (node == null || depth > 256) {
            return;
        }
        short nodeType = node.getNodeType();
        if (nodeType == 3 && textNodeOutputOption == 1 || nodeType == 8 && commentNodeOutputOption == 1) {
            return;
        }
        for (int currentDepth = 0; currentDepth < depth; ++currentDepth) {
            if (siblingsAtDepth.get(currentDepth)) {
                outputTarget.print("|  ");
                continue;
            }
            outputTarget.print(XML_OUTPUT_INDENTATION_SPACE);
        }
        outputTarget.print("+--");
        if (displayHashcodes) {
            outputTarget.print("(" + node.getClass().getName() + "@" + Integer.toHexString(node.hashCode()) + ") ");
        }
        switch (nodeType) {
            case 1: {
                outputTarget.print("ELEMENT: ");
                break;
            }
            case 2: {
                outputTarget.print("ATTRIBUTE: ");
                break;
            }
            case 3: {
                outputTarget.print("TEXT: ");
                break;
            }
            case 4: {
                outputTarget.print("CDATA_SECTION: ");
                break;
            }
            case 5: {
                outputTarget.print("ENTITY_REFERENCE: ");
                break;
            }
            case 6: {
                outputTarget.print("ENTITY: ");
                break;
            }
            case 7: {
                outputTarget.print("PROCESSING_INSTRUCTION: ");
                break;
            }
            case 8: {
                outputTarget.print("COMMENT: ");
                break;
            }
            case 9: {
                outputTarget.print("DOCUMENT: ");
                break;
            }
            case 10: {
                outputTarget.print("DOCUMENT_TYPE: ");
                break;
            }
            case 11: {
                outputTarget.print("DOCUMENT_FRAGMENT: ");
                break;
            }
            case 12: {
                outputTarget.print("NOTATION: ");
            }
        }
        if (!terseOutput || nodeType != 4 || nodeType != 8 || nodeType != 11 || nodeType != 9 || nodeType != 3) {
            outputTarget.print("name=");
            String nodeName = node.getNodeName();
            if (nodeName != null) {
                outputTarget.print("\"" + nodeName + "\"");
            } else {
                outputTarget.print("null");
            }
        }
        if ((nodeValue = node.getNodeValue()) != null) {
            outputTarget.print(", value=");
            if (nodeType == 3 && textNodeOutputOption == 2 || nodeType == 8 && commentNodeOutputOption == 2) {
                outputTarget.println("(not displayed)");
            } else {
                outputTarget.print("\"");
                block21: for (int nodeValueIndex = 0; nodeValueIndex < nodeValue.length(); ++nodeValueIndex) {
                    char ch = nodeValue.charAt(nodeValueIndex);
                    switch (ch) {
                        case '\t': {
                            outputTarget.print("\\t");
                            continue block21;
                        }
                        case '\n': {
                            outputTarget.print("\\n");
                            continue block21;
                        }
                        case '\f': {
                            outputTarget.print("\\f");
                            continue block21;
                        }
                        case '\r': {
                            outputTarget.print("\\r");
                            continue block21;
                        }
                        default: {
                            outputTarget.print(ch);
                        }
                    }
                }
                outputTarget.println("\"");
            }
        } else {
            if (!terseOutput) {
                outputTarget.print(", value=null");
            }
            outputTarget.println();
        }
        if (node.hasChildNodes()) {
            siblingsAtDepth.set(depth + 1);
        }
        if ((nnm = node.getAttributes()) != null) {
            for (int attributeIndex = 0; attributeIndex < nnm.getLength(); ++attributeIndex) {
                Node attributeNode = nnm.item(attributeIndex);
                for (int currentDepth = 0; currentDepth <= depth + 1; ++currentDepth) {
                    if (siblingsAtDepth.get(currentDepth)) {
                        outputTarget.print("|  ");
                        continue;
                    }
                    outputTarget.print(XML_OUTPUT_INDENTATION_SPACE);
                }
                outputTarget.println("   (Attribute: name=\"" + attributeNode.getNodeName() + "\", value=\"" + attributeNode.getNodeValue() + "\")");
            }
        }
        Node child = node.getFirstChild();
        while (child != null) {
            short nextChildNodeType;
            Node nextChild;
            for (nextChild = child.getNextSibling(); nextChild != null && ((nextChildNodeType = nextChild.getNodeType()) == 3 && textNodeOutputOption == 1 || nextChildNodeType == 8 && commentNodeOutputOption == 1); nextChild = nextChild.getNextSibling()) {
            }
            if (nextChild == null) {
                siblingsAtDepth.clear(depth + 1);
            }
            DOMSupport.dumpDOMNode(outputTarget, child, textNodeOutputOption, commentNodeOutputOption, terseOutput, displayHashcodes, depth + 1, siblingsAtDepth);
            child = nextChild;
        }
    }

    public static void dumpDOMTree(PrintWriter outputTarget, Node rootNode, short textNodeOutputOption, short commentNodeOutputOption, boolean terseOutput, boolean displayHashcodes) {
        DOMSupport.dumpDOMNode(outputTarget, rootNode, textNodeOutputOption, commentNodeOutputOption, terseOutput, displayHashcodes, 0, new BitSet(256));
    }

    public static void exportDOMNode(Writer outputTarget, Node node) {
        DOMSupport.exportDOMNode(outputTarget, node, -1);
    }

    public static void exportDOMNode(Writer outputTarget, Node node, int indentLevel) {
        if (node == null) {
            return;
        }
        String nodeName = null;
        NamedNodeMap nnm = null;
        Node attributeNode = null;
        Node child = null;
        String piData = null;
        String commentData = null;
        String endLine = indentLevel == -1 ? "" : "\n";
        String indentS = "";
        for (int i = indentLevel; i > 0; --i) {
            indentS = indentS + "  ";
        }
        switch (node.getNodeType()) {
            case 9: {
                try {
                    outputTarget.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + endLine);
                }
                catch (IOException e) {}
                break;
            }
            case 10: {
                try {
                    outputTarget.write("<!DOCTYPE " + node.getNodeName() + ">" + endLine);
                }
                catch (IOException e) {}
                break;
            }
            case 1: {
                nodeName = node.getNodeName();
                try {
                    outputTarget.write(indentS + "<" + nodeName);
                }
                catch (IOException e) {
                    // empty catch block
                }
                nnm = node.getAttributes();
                if (nnm != null) {
                    int numberAttributes = nnm.getLength();
                    for (int attributeIndex = 0; attributeIndex < numberAttributes; ++attributeIndex) {
                        attributeNode = nnm.item(attributeIndex);
                        try {
                            outputTarget.write(" " + attributeNode.getNodeName() + "=\"" + attributeNode.getNodeValue() + "\"");
                            continue;
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                }
                if (node.hasChildNodes()) {
                    try {
                        outputTarget.write(">" + endLine);
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    for (child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                        DOMSupport.exportDOMNode(outputTarget, child, indentLevel == -1 ? -1 : 1 + indentLevel);
                    }
                    try {
                        outputTarget.write(indentS + "</" + nodeName + ">" + endLine);
                    }
                    catch (IOException e) {}
                    break;
                }
                try {
                    outputTarget.write("/>" + endLine);
                }
                catch (IOException e) {}
                break;
            }
            case 5: {
                try {
                    outputTarget.write("&" + node.getNodeName() + ";");
                }
                catch (IOException e) {}
                break;
            }
            case 4: {
                try {
                    outputTarget.write(indentS + "<![CDATA[" + node.getNodeValue() + "]]>" + endLine);
                }
                catch (IOException e) {}
                break;
            }
            case 3: {
                try {
                    outputTarget.write(DOMSupport.normalize(node.getNodeValue()));
                }
                catch (IOException e) {}
                break;
            }
            case 7: {
                try {
                    outputTarget.write(indentS + "<?" + node.getNodeName());
                }
                catch (IOException e) {
                    // empty catch block
                }
                piData = node.getNodeValue();
                if (piData != null && piData.length() > 0) {
                    try {
                        outputTarget.write(" " + piData);
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                try {
                    outputTarget.write("?>" + endLine);
                }
                catch (IOException e) {}
                break;
            }
            case 11: {
                DOMSupport.exportDOMNode(outputTarget, node.getFirstChild());
                break;
            }
            case 8: {
                try {
                    outputTarget.write(indentS + "<!--");
                }
                catch (IOException e) {
                    // empty catch block
                }
                commentData = node.getNodeValue();
                if (commentData != null && commentData.length() > 0) {
                    try {
                        outputTarget.write(" " + commentData);
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                try {
                    outputTarget.write(" -->" + endLine);
                    break;
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
    }

    public static void exportDOMTree(Writer outputTarget, Node rootNode) {
        DOMSupport.exportDOMNode(outputTarget, rootNode);
    }

    public static Element fetchURL(URL url) throws IOException {
        DocumentBuilder docBuilder;
        DocumentBuilderFactoryImpl factory = new DocumentBuilderFactoryImpl();
        try {
            docBuilder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e.getMessage());
        }
        BufferedReader in = null;
        InputStream file = url.openStream();
        in = new BufferedReader(new InputStreamReader(file));
        StringBuffer docBuff = new StringBuffer();
        String currentLine = in.readLine();
        while (currentLine != null) {
            docBuff.append(currentLine.trim());
            currentLine = in.readLine();
        }
        in.close();
        in = new BufferedReader(new StringReader(docBuff.toString()));
        Document doc = null;
        try {
            doc = docBuilder.parse(new InputSource(in));
        }
        catch (SAXException e) {
            throw new IOException(e.getMessage());
        }
        if (doc != null) {
            return doc.getDocumentElement();
        }
        return null;
    }

    public static Document getOwnerDocument(Node node) {
        Document doc = node.getOwnerDocument();
        if (doc == null) {
            doc = (Document)node;
        }
        return doc;
    }

    private static String normalize(String s) {
        StringBuffer str = new StringBuffer();
        int len = s != null ? s.length() : 0;
        block27: for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '-': {
                    str.append("&#x2d;");
                    continue block27;
                }
                case '\u00c4': {
                    str.append("&#xe4;");
                    continue block27;
                }
                case '\u00e0': {
                    str.append("&#xE0;");
                    continue block27;
                }
                case '\u00e1': {
                    str.append("&#xE1;");
                    continue block27;
                }
                case '\u00e2': {
                    str.append("&#xE2;");
                    continue block27;
                }
                case '\u00e3': {
                    str.append("&#xE3;");
                    continue block27;
                }
                case '\u00e4': {
                    str.append("&#xE4;");
                    continue block27;
                }
                case '\u00e5': {
                    str.append("&#xE5;");
                    continue block27;
                }
                case '\u00e6': {
                    str.append("&#xE6;");
                    continue block27;
                }
                case '\u00e7': {
                    str.append("&#xE7;");
                    continue block27;
                }
                case '\u00e8': {
                    str.append("&#xE8;");
                    continue block27;
                }
                case '\u00e9': {
                    str.append("&#xE9;");
                    continue block27;
                }
                case '\u00ed': {
                    str.append("&#xED;");
                    continue block27;
                }
                case '\u00ef': {
                    str.append("&#xEF;");
                    continue block27;
                }
                case '\u00f0': {
                    str.append("&#xF0;");
                    continue block27;
                }
                case '\u00f1': {
                    str.append("&#xF1;");
                    continue block27;
                }
                case '\u00f2': {
                    str.append("&#xF2;");
                    continue block27;
                }
                case '\u00f3': {
                    str.append("&#xF3;");
                    continue block27;
                }
                case '\u00f4': {
                    str.append("&#xF4;");
                    continue block27;
                }
                case '\u00fc': {
                    str.append("&#xFC;");
                    continue block27;
                }
                case '\u00ff': {
                    str.append("&#xFF;");
                    continue block27;
                }
                case '<': {
                    str.append("&lt;");
                    continue block27;
                }
                case '>': {
                    str.append("&gt;");
                    continue block27;
                }
                case '&': {
                    str.append("&amp;");
                    continue block27;
                }
                case '\"': {
                    str.append("&quot;");
                    continue block27;
                }
                default: {
                    str.append(ch);
                }
            }
        }
        return str.toString();
    }

    public static String translateDOMException(DOMException e) {
        String translation = null;
        switch (e.code) {
            case 1: {
                translation = "Index size error";
                break;
            }
            case 2: {
                translation = "String size error";
                break;
            }
            case 3: {
                translation = "Hierarchy request error";
                break;
            }
            case 4: {
                translation = "Wrong document";
                break;
            }
            case 5: {
                translation = "Invalid character";
                break;
            }
            case 6: {
                translation = "No data allowed";
                break;
            }
            case 7: {
                translation = "No modification allowed";
                break;
            }
            case 8: {
                translation = "Not found error";
                break;
            }
            case 9: {
                translation = "Not supported";
                break;
            }
            case 10: {
                translation = "Attribute in-use";
                break;
            }
            default: {
                translation = "UNKNOWN DOM EXCEPTION";
            }
        }
        return translation;
    }
}

