/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsrp4j.consumer.driver;

import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.rpc.ServiceException;
import oasis.names.tc.wsrp.v1.intf.WSRP_v1_Markup_PortType;
import oasis.names.tc.wsrp.v1.wsdl.WSRPServiceLocator;
import org.apache.wsrp4j.consumer.InitCookieInfo;
import org.apache.wsrp4j.exception.WSRPException;
import org.apache.wsrp4j.exception.WSRPXHelper;
import org.apache.wsrp4j.log.LogManager;
import org.apache.wsrp4j.log.Logger;

public class InitCookieInfoImpl
implements InitCookieInfo {
    private Logger logger = null;
    private String markupInterfaceURL = null;
    private boolean initCookieRequired;
    private boolean initCookieDone;
    private WSRP_v1_Markup_PortType markupInterface;

    public InitCookieInfoImpl(String markupURL) throws WSRPException {
        String MN = "init";
        this.logger = LogManager.getLogManager().getLogger(this.getClass());
        this.initCookieDone = false;
        this.initCookieRequired = false;
        this.markupInterfaceURL = markupURL;
        try {
            WSRPServiceLocator serviceLocator = new WSRPServiceLocator();
            serviceLocator.setMaintainSession(true);
            this.markupInterface = serviceLocator.getWSRPBaseService(new URL(markupURL));
        }
        catch (ServiceException xmlEx) {
            WSRPXHelper.throwX((Logger)this.logger, (int)10, (String)"init", (int)6017, (Throwable)xmlEx);
        }
        catch (MalformedURLException urlEx) {
            WSRPXHelper.throwX((Logger)this.logger, (int)10, (String)"init", (int)6018, (Throwable)urlEx);
        }
    }

    public boolean isInitCookieRequired() {
        return this.initCookieRequired;
    }

    public void setInitCookieRequired(boolean initCookieRequired) {
        this.initCookieRequired = initCookieRequired;
    }

    public boolean isInitCookieDone() {
        return this.initCookieDone;
    }

    public void setInitCookieDone(boolean initCookieDone) {
        this.initCookieDone = initCookieDone;
    }

    public String getMarkupInterfaceURL() {
        return this.markupInterfaceURL;
    }

    public WSRP_v1_Markup_PortType getWSRPBaseService() {
        return this.markupInterface;
    }

    public void setWSRPBaseService(WSRP_v1_Markup_PortType markupPortType) {
        if (markupPortType != null) {
            this.markupInterface = markupPortType;
        }
    }
}

