/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util;

import edu.emory.mathcs.backport.java.util.Deque;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ArrayDeque
extends AbstractCollection
implements Deque,
Cloneable,
Serializable {
    private static final int MIN_INITIAL_CAPACITY = 8;
    private static final long serialVersionUID = 2340985798034038923L;
    private transient Object[] elements;
    private transient int head;
    private transient int tail;
    private static final /* synthetic */ boolean assert;

    private final void allocateElements(int numElements) {
        int initialCapacity = 8;
        if (numElements >= initialCapacity) {
            initialCapacity = numElements;
            initialCapacity |= initialCapacity >>> 1;
            initialCapacity |= initialCapacity >>> 2;
            initialCapacity |= initialCapacity >>> 4;
            initialCapacity |= initialCapacity >>> 8;
            initialCapacity |= initialCapacity >>> 16;
            if (++initialCapacity < 0) {
                initialCapacity >>>= 1;
            }
        }
        this.elements = new Object[initialCapacity];
    }

    private final void doubleCapacity() {
        if (!assert && this.head != this.tail) {
            throw new AssertionError();
        }
        int p = this.head;
        int n = this.elements.length;
        int r = n - p;
        int newCapacity = n << 1;
        if (newCapacity < 0) {
            throw new IllegalStateException("Sorry, deque too big");
        }
        Object[] a = new Object[newCapacity];
        System.arraycopy(this.elements, p, a, 0, r);
        System.arraycopy(this.elements, 0, a, r, p);
        this.elements = a;
        this.head = 0;
        this.tail = n;
    }

    private final Object[] copyElements(Object[] a) {
        if (this.head < this.tail) {
            System.arraycopy(this.elements, this.head, a, 0, this.size());
        } else if (this.head > this.tail) {
            int headPortionLen = this.elements.length - this.head;
            System.arraycopy(this.elements, this.head, a, 0, headPortionLen);
            System.arraycopy(this.elements, 0, a, headPortionLen, this.tail);
        }
        return a;
    }

    public void addFirst(Object e) {
        if (e == null) {
            throw new NullPointerException();
        }
        this.head = this.head - 1 & this.elements.length - 1;
        this.elements[this.head] = e;
        if (this.head == this.tail) {
            this.doubleCapacity();
        }
    }

    public void addLast(Object e) {
        if (e == null) {
            throw new NullPointerException();
        }
        this.elements[this.tail] = e;
        this.tail = this.tail + 1 & this.elements.length - 1;
        if (this.tail == this.head) {
            this.doubleCapacity();
        }
    }

    public boolean offerFirst(Object e) {
        this.addFirst(e);
        return true;
    }

    public boolean offerLast(Object e) {
        this.addLast(e);
        return true;
    }

    public Object removeFirst() {
        Object x = this.pollFirst();
        if (x == null) {
            throw new NoSuchElementException();
        }
        return x;
    }

    public Object removeLast() {
        Object x = this.pollLast();
        if (x == null) {
            throw new NoSuchElementException();
        }
        return x;
    }

    public Object pollFirst() {
        int h = this.head;
        Object result = this.elements[h];
        if (result == null) {
            return null;
        }
        this.elements[h] = null;
        this.head = h + 1 & this.elements.length - 1;
        return result;
    }

    public Object pollLast() {
        int t = this.tail - 1 & this.elements.length - 1;
        Object result = this.elements[t];
        if (result == null) {
            return null;
        }
        this.elements[t] = null;
        this.tail = t;
        return result;
    }

    public Object getFirst() {
        Object x = this.elements[this.head];
        if (x == null) {
            throw new NoSuchElementException();
        }
        return x;
    }

    public Object getLast() {
        Object x = this.elements[this.tail - 1 & this.elements.length - 1];
        if (x == null) {
            throw new NoSuchElementException();
        }
        return x;
    }

    public Object peekFirst() {
        return this.elements[this.head];
    }

    public Object peekLast() {
        return this.elements[this.tail - 1 & this.elements.length - 1];
    }

    public boolean removeFirstOccurrence(Object o) {
        Object x;
        if (o == null) {
            return false;
        }
        int mask = this.elements.length - 1;
        int i = this.head;
        while ((x = this.elements[i]) != null) {
            if (o.equals(x)) {
                this.delete(i);
                return true;
            }
            i = i + 1 & mask;
        }
        return false;
    }

    public boolean removeLastOccurrence(Object o) {
        Object x;
        if (o == null) {
            return false;
        }
        int mask = this.elements.length - 1;
        int i = this.tail - 1 & mask;
        while ((x = this.elements[i]) != null) {
            if (o.equals(x)) {
                this.delete(i);
                return true;
            }
            i = i - 1 & mask;
        }
        return false;
    }

    public boolean add(Object e) {
        this.addLast(e);
        return true;
    }

    public boolean offer(Object e) {
        return this.offerLast(e);
    }

    public Object remove() {
        return this.removeFirst();
    }

    public Object poll() {
        return this.pollFirst();
    }

    public Object element() {
        return this.getFirst();
    }

    public Object peek() {
        return this.peekFirst();
    }

    public void push(Object e) {
        this.addFirst(e);
    }

    public Object pop() {
        return this.removeFirst();
    }

    private final boolean delete(int i) {
        int mask = this.elements.length - 1;
        if ((i - this.head & mask) >= (this.tail - this.head & mask)) {
            throw new ConcurrentModificationException();
        }
        if (i >= this.head) {
            System.arraycopy(this.elements, this.head, this.elements, this.head + 1, i - this.head);
            this.elements[this.head] = null;
            this.head = this.head + 1 & mask;
            return false;
        }
        --this.tail;
        System.arraycopy(this.elements, i + 1, this.elements, i, this.tail - i);
        this.elements[this.tail] = null;
        return true;
    }

    public int size() {
        return this.tail - this.head & this.elements.length - 1;
    }

    public boolean isEmpty() {
        boolean bl = false;
        if (this.head == this.tail) {
            bl = true;
        }
        return bl;
    }

    public Iterator iterator() {
        return new DeqIterator();
    }

    public boolean contains(Object o) {
        Object x;
        if (o == null) {
            return false;
        }
        int mask = this.elements.length - 1;
        int i = this.head;
        while ((x = this.elements[i]) != null) {
            if (o.equals(x)) {
                return true;
            }
            i = i + 1 & mask;
        }
        return false;
    }

    public boolean remove(Object o) {
        return this.removeFirstOccurrence(o);
    }

    public void clear() {
        int h = this.head;
        int t = this.tail;
        if (h != t) {
            this.tail = 0;
            this.head = 0;
            int i = h;
            int mask = this.elements.length - 1;
            do {
                this.elements[i] = null;
            } while ((i = i + 1 & mask) != t);
        }
    }

    public Object[] toArray() {
        return this.copyElements(new Object[this.size()]);
    }

    public Object[] toArray(Object[] a) {
        int size = this.size();
        if (a.length < size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        }
        this.copyElements(a);
        if (a.length > size) {
            a[size] = null;
        }
        return a;
    }

    /*
     * WARNING - void declaration
     */
    public Object clone() {
        try {
            void e;
            ArrayDeque result = (ArrayDeque)super.clone();
            result.elements = new Object[this.elements.length];
            System.arraycopy(this.elements, 0, result.elements, 0, this.elements.length);
            return e;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    private final void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        int size = this.size();
        s.writeInt(size);
        int i = this.head;
        int mask = this.elements.length - 1;
        int j = 0;
        while (j < size) {
            s.writeObject(this.elements[i]);
            i = i + 1 & mask;
            ++j;
        }
    }

    private final void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int size = s.readInt();
        this.allocateElements(size);
        this.head = 0;
        this.tail = size;
        int i = 0;
        while (i < size) {
            this.elements[i] = s.readObject();
            ++i;
        }
    }

    public ArrayDeque() {
        this.elements = new Object[16];
    }

    public ArrayDeque(int numElements) {
        this.allocateElements(numElements);
    }

    public ArrayDeque(Collection c) {
        this.allocateElements(c.size());
        this.addAll(c);
    }

    static {
        assert = Class.forName("[Ledu.emory.mathcs.backport.java.util.ArrayDeque;").getComponentType().desiredAssertionStatus() ^ true;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class DeqIterator
    implements Iterator {
        private int cursor;
        private int fence;
        private int lastRet;

        public boolean hasNext() {
            boolean bl = false;
            if (this.cursor != this.fence) {
                bl = true;
            }
            return bl;
        }

        public Object next() {
            Object result;
            if (this.cursor == this.fence) {
                throw new NoSuchElementException();
            }
            if (ArrayDeque.this.tail != this.fence || (result = ArrayDeque.this.elements[this.cursor]) == null) {
                throw new ConcurrentModificationException();
            }
            this.lastRet = this.cursor;
            this.cursor = this.cursor + 1 & ArrayDeque.this.elements.length - 1;
            return result;
        }

        public void remove() {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            if (ArrayDeque.this.delete(this.lastRet)) {
                --this.cursor;
            }
            this.lastRet = -1;
            this.fence = ArrayDeque.this.tail;
        }

        private final /* synthetic */ void this() {
            this.cursor = ArrayDeque.this.head;
            this.fence = ArrayDeque.this.tail;
            this.lastRet = -1;
        }

        private DeqIterator() {
            this.this();
        }
    }
}

