/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util.concurrent;

import edu.emory.mathcs.backport.java.util.AbstractMap;
import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentMap;
import edu.emory.mathcs.backport.java.util.concurrent.locks.ReentrantLock;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class ConcurrentHashMap
extends AbstractMap
implements ConcurrentMap,
Serializable {
    private static final long serialVersionUID = 7249069246763182397L;
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    static final int DEFAULT_CONCURRENCY_LEVEL = 16;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final int MAX_SEGMENTS = 65536;
    static final int RETRIES_BEFORE_LOCK = 2;
    final int segmentMask;
    final int segmentShift;
    final Segment[] segments;
    transient Set keySet;
    transient Set entrySet;
    transient Collection values;

    static int hash(Object x) {
        int h = x.hashCode();
        h += ~(h << 9);
        h ^= h >>> 14;
        h += h << 4;
        h ^= h >>> 10;
        return h;
    }

    final Segment segmentFor(int hash) {
        return this.segments[hash >>> this.segmentShift & this.segmentMask];
    }

    public boolean isEmpty() {
        Segment[] segments = this.segments;
        int[] mc = new int[segments.length];
        int mcsum = 0;
        int i = 0;
        while (i < segments.length) {
            if (segments[i].count != 0) {
                return false;
            }
            mc[i] = segments[i].modCount;
            mcsum += mc[i];
            ++i;
        }
        if (mcsum != 0) {
            i = 0;
            while (i < segments.length) {
                if (segments[i].count != 0 || mc[i] != segments[i].modCount) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public int size() {
        Segment[] segments = this.segments;
        long sum = 0L;
        long check = 0L;
        int[] mc = new int[segments.length];
        int k = 0;
        while (k < 2) {
            check = 0L;
            sum = 0L;
            int mcsum = 0;
            int i = 0;
            while (i < segments.length) {
                sum += (long)segments[i].count;
                mc[i] = segments[i].modCount;
                mcsum += mc[i];
                ++i;
            }
            if (mcsum != 0) {
                i = 0;
                while (i < segments.length) {
                    check += (long)segments[i].count;
                    if (mc[i] != segments[i].modCount) {
                        check = -1;
                        break;
                    }
                    ++i;
                }
            }
            if (check == sum) break;
            ++k;
        }
        if (check != sum) {
            sum = 0L;
            int i = 0;
            while (i < segments.length) {
                segments[i].lock();
                ++i;
            }
            i = 0;
            while (i < segments.length) {
                sum += (long)segments[i].count;
                ++i;
            }
            i = 0;
            while (i < segments.length) {
                segments[i].unlock();
                ++i;
            }
        }
        if (sum > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)sum;
    }

    public Object get(Object key) {
        int hash = ConcurrentHashMap.hash(key);
        return this.segmentFor(hash).get(key, hash);
    }

    public boolean containsKey(Object key) {
        int hash = ConcurrentHashMap.hash(key);
        return this.segmentFor(hash).containsKey(key, hash);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean containsValue(Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        segments = this.segments;
        mc = new int[segments.length];
        k = 0;
        while (true) {
            block19: {
                if (k >= 2) break;
                sum = false;
                mcsum = 0;
                i = 0;
                while (true) {
                    if (i >= segments.length) {
                        cleanSweep = true;
                        if (mcsum != 0) {
                            i = 0;
                            break;
                        }
                        break block19;
                    }
                    c = segments[i].count;
                    mc[i] = segments[i].modCount;
                    mcsum += mc[i];
                    if (segments[i].containsValue(value)) {
                        return true;
                    }
                    ++i;
                }
                while (i < segments.length) {
                    c = segments[i].count;
                    if (mc[i] != segments[i].modCount) {
                        cleanSweep = false;
                        break;
                    }
                    ++i;
                }
            }
            if (cleanSweep) {
                return false;
            }
            ++k;
        }
        i = 0;
        while (true) {
            if (i >= segments.length) {
                found = false;
                ** try [egrp 0[TRYBLOCK] [0 : 184->220)] { 
lbl42:
                // 1 sources

                break;
            }
            segments[i].lock();
            ++i;
        }
        {
            i = 0;
            while (i < segments.length) {
                block20: {
                    if (!segments[i].containsValue(value)) break block20;
                    found = true;
                    ** GOTO lbl-1000
                }
                ++i;
            }
            ** GOTO lbl-1000
        }
lbl55:
        // 1 sources

        catch (Throwable var5_6) {
            var6_8 = null;
            i = 0;
        }
        while (true) {
            if (i >= segments.length) {
                throw var5_6;
            }
            segments[i].unlock();
            ++i;
        }
lbl-1000:
        // 2 sources

        {
            var6_9 = null;
            i = 0;
        }
        while (true) {
            if (i >= segments.length) {
                return found;
            }
            segments[i].unlock();
            ++i;
        }
    }

    public boolean contains(Object value) {
        return this.containsValue(value);
    }

    public Object put(Object key, Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        int hash = ConcurrentHashMap.hash(key);
        return this.segmentFor(hash).put(key, hash, value, false);
    }

    public Object putIfAbsent(Object key, Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        int hash = ConcurrentHashMap.hash(key);
        return this.segmentFor(hash).put(key, hash, value, true);
    }

    public void putAll(Map m) {
        Iterator it = m.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e = it.next();
            this.put(e.getKey(), e.getValue());
        }
    }

    public Object remove(Object key) {
        int hash = ConcurrentHashMap.hash(key);
        return this.segmentFor(hash).remove(key, hash, null);
    }

    public boolean remove(Object key, Object value) {
        if (value == null) {
            return false;
        }
        int hash = ConcurrentHashMap.hash(key);
        boolean bl = false;
        if (this.segmentFor(hash).remove(key, hash, value) != null) {
            bl = true;
        }
        return bl;
    }

    public boolean replace(Object key, Object oldValue, Object newValue) {
        if (oldValue == null || newValue == null) {
            throw new NullPointerException();
        }
        int hash = ConcurrentHashMap.hash(key);
        return this.segmentFor(hash).replace(key, hash, oldValue, newValue);
    }

    public Object replace(Object key, Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        int hash = ConcurrentHashMap.hash(key);
        return this.segmentFor(hash).replace(key, hash, value);
    }

    public void clear() {
        int i = 0;
        while (i < this.segments.length) {
            this.segments[i].clear();
            ++i;
        }
    }

    public Set keySet() {
        Set ks = this.keySet;
        return ks != null ? ks : (this.keySet = new KeySet());
    }

    public Collection values() {
        Collection vs = this.values;
        return vs != null ? vs : (this.values = new Values());
    }

    public Set entrySet() {
        Set es = this.entrySet;
        return es != null ? es : (this.entrySet = new EntrySet());
    }

    public Enumeration keys() {
        return new KeyIterator();
    }

    public Enumeration elements() {
        return new ValueIterator();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        int k = 0;
        while (true) {
            Object var5_4;
            if (k >= this.segments.length) {
                s.writeObject(null);
                s.writeObject(null);
                return;
            }
            Segment seg = this.segments[k];
            seg.lock();
            try {
                HashEntry[] tab = seg.table;
                int i = 0;
                block4: while (i < tab.length) {
                    HashEntry e = tab[i];
                    while (true) {
                        if (e == null) {
                            ++i;
                            continue block4;
                        }
                        s.writeObject(e.key);
                        s.writeObject(e.value);
                        e = e.next;
                    }
                }
            }
            catch (Throwable throwable) {
                var5_4 = null;
                seg.unlock();
                throw throwable;
            }
            {
                var5_4 = null;
            }
            seg.unlock();
            ++k;
        }
    }

    private final void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int i = 0;
        while (i < this.segments.length) {
            this.segments[i].setTable(new HashEntry[1]);
            ++i;
        }
        while (true) {
            Object key = s.readObject();
            Object value = s.readObject();
            if (key == null) break;
            this.put(key, value);
        }
    }

    public ConcurrentHashMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
        int c;
        if (!(loadFactor > 0.0f) || initialCapacity < 0 || concurrencyLevel <= 0) {
            throw new IllegalArgumentException();
        }
        if (concurrencyLevel > 65536) {
            concurrencyLevel = 65536;
        }
        int sshift = 0;
        int ssize = 1;
        while (ssize < concurrencyLevel) {
            ++sshift;
            ssize <<= 1;
        }
        this.segmentShift = 32 - sshift;
        this.segmentMask = ssize - 1;
        this.segments = Segment.newArray(ssize);
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if ((c = initialCapacity / ssize) * ssize < initialCapacity) {
            ++c;
        }
        int cap = 1;
        while (cap < c) {
            cap <<= 1;
        }
        int i = 0;
        while (i < this.segments.length) {
            this.segments[i] = new Segment(cap, loadFactor);
            ++i;
        }
    }

    public ConcurrentHashMap(int initialCapacity, float loadFactor) {
        this(initialCapacity, loadFactor, 16);
    }

    public ConcurrentHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f, 16);
    }

    public ConcurrentHashMap() {
        this(16, 0.75f, 16);
    }

    public ConcurrentHashMap(Map m) {
        this(Math.max((int)((float)m.size() / 0.75f) + 1, 16), 0.75f, 16);
        this.putAll(m);
    }

    static final class Segment
    extends ReentrantLock
    implements Serializable {
        private static final long serialVersionUID = 2249069246763182397L;
        volatile transient int count;
        transient int modCount;
        transient int threshold;
        volatile transient HashEntry[] table;
        final float loadFactor;

        static final Segment[] newArray(int i) {
            return new Segment[i];
        }

        final void setTable(HashEntry[] newTable) {
            this.threshold = (int)((float)newTable.length * this.loadFactor);
            this.table = newTable;
        }

        final HashEntry getFirst(int hash) {
            HashEntry[] tab = this.table;
            return tab[hash & tab.length - 1];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final Object readValueUnderLock(HashEntry e) {
            Object object;
            this.lock();
            try {
                object = e.value;
                Object var3_3 = null;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                this.unlock();
                throw throwable;
            }
            this.unlock();
            return object;
        }

        final Object get(Object key, int hash) {
            if (this.count != 0) {
                HashEntry e = this.getFirst(hash);
                while (e != null) {
                    if (e.hash == hash && key.equals(e.key)) {
                        Object v = e.value;
                        if (v != null) {
                            return v;
                        }
                        return this.readValueUnderLock(e);
                    }
                    e = e.next;
                }
            }
            return null;
        }

        final boolean containsKey(Object key, int hash) {
            if (this.count != 0) {
                HashEntry e = this.getFirst(hash);
                while (e != null) {
                    if (e.hash == hash && key.equals(e.key)) {
                        return true;
                    }
                    e = e.next;
                }
            }
            return false;
        }

        final boolean containsValue(Object value) {
            if (this.count != 0) {
                HashEntry[] tab = this.table;
                int len = tab.length;
                int i = 0;
                while (i < len) {
                    HashEntry e = tab[i];
                    while (e != null) {
                        Object v = e.value;
                        if (v == null) {
                            v = this.readValueUnderLock(e);
                        }
                        if (value.equals(v)) {
                            return true;
                        }
                        e = e.next;
                    }
                    ++i;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final boolean replace(Object key, int hash, Object oldValue, Object newValue) {
            boolean bl;
            this.lock();
            try {
                HashEntry e = this.getFirst(hash);
                while (!(e == null || e.hash == hash && key.equals(e.key))) {
                    e = e.next;
                }
                boolean replaced = false;
                if (e != null && oldValue.equals(e.value)) {
                    replaced = true;
                    e.value = newValue;
                }
                bl = replaced;
                Object var6_8 = null;
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                this.unlock();
                throw throwable;
            }
            this.unlock();
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final Object replace(Object key, int hash, Object newValue) {
            Object object;
            this.lock();
            try {
                HashEntry e = this.getFirst(hash);
                while (!(e == null || e.hash == hash && key.equals(e.key))) {
                    e = e.next;
                }
                Object oldValue = null;
                if (e != null) {
                    oldValue = e.value;
                    e.value = newValue;
                }
                object = oldValue;
                Object var5_7 = null;
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                this.unlock();
                throw throwable;
            }
            this.unlock();
            return object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final Object put(Object key, int hash, Object value, boolean onlyIfAbsent) {
            Object object;
            this.lock();
            try {
                Object oldValue;
                HashEntry first;
                int c = this.count;
                if (c++ > this.threshold) {
                    this.rehash();
                }
                HashEntry[] tab = this.table;
                int index = hash & tab.length - 1;
                HashEntry e = first = tab[index];
                while (!(e == null || e.hash == hash && key.equals(e.key))) {
                    e = e.next;
                }
                if (e != null) {
                    oldValue = e.value;
                    if (!onlyIfAbsent) {
                        e.value = value;
                    }
                } else {
                    oldValue = null;
                    ++this.modCount;
                    tab[index] = new HashEntry(key, hash, first, value);
                    this.count = c;
                }
                object = oldValue;
                Object var6_12 = null;
            }
            catch (Throwable throwable) {
                Object var6_13 = null;
                this.unlock();
                throw throwable;
            }
            this.unlock();
            return object;
        }

        final void rehash() {
            HashEntry[] oldTable = this.table;
            int oldCapacity = oldTable.length;
            if (oldCapacity >= 0x40000000) {
                return;
            }
            HashEntry[] newTable = HashEntry.newArray(oldCapacity << 1);
            this.threshold = (int)((float)newTable.length * this.loadFactor);
            int sizeMask = newTable.length - 1;
            int i = 0;
            while (i < oldCapacity) {
                HashEntry e = oldTable[i];
                if (e != null) {
                    HashEntry next = e.next;
                    int idx = e.hash & sizeMask;
                    if (next == null) {
                        newTable[idx] = e;
                    } else {
                        int k;
                        HashEntry lastRun = e;
                        int lastIdx = idx;
                        HashEntry last = next;
                        while (last != null) {
                            k = last.hash & sizeMask;
                            if (k != lastIdx) {
                                lastIdx = k;
                                lastRun = last;
                            }
                            last = last.next;
                        }
                        newTable[lastIdx] = lastRun;
                        HashEntry p = e;
                        while (p != lastRun) {
                            k = p.hash & sizeMask;
                            HashEntry n = newTable[k];
                            newTable[k] = new HashEntry(p.key, p.hash, n, p.value);
                            p = p.next;
                        }
                    }
                }
                ++i;
            }
            this.table = newTable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final Object remove(Object key, int hash, Object value) {
            Object object;
            this.lock();
            try {
                HashEntry first;
                int c = this.count - 1;
                HashEntry[] tab = this.table;
                int index = hash & tab.length - 1;
                HashEntry e = first = tab[index];
                while (!(e == null || e.hash == hash && key.equals(e.key))) {
                    e = e.next;
                }
                Object oldValue = null;
                if (e != null) {
                    Object v = e.value;
                    if (value == null || value.equals(v)) {
                        oldValue = v;
                        ++this.modCount;
                        HashEntry newFirst = e.next;
                        HashEntry p = first;
                        while (p != e) {
                            newFirst = new HashEntry(p.key, p.hash, newFirst, p.value);
                            p = p.next;
                        }
                        tab[index] = newFirst;
                        this.count = c;
                    }
                }
                object = oldValue;
                Object var5_14 = null;
            }
            catch (Throwable throwable) {
                Object var5_15 = null;
                this.unlock();
                throw throwable;
            }
            this.unlock();
            return object;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        final void clear() {
            if (this.count == 0) return;
            this.lock();
            try {
                HashEntry[] tab = this.table;
                int i = 0;
                while (true) {
                    block4: {
                        if (i < tab.length) break block4;
                        ++this.modCount;
                        this.count = 0;
                        break;
                    }
                    tab[i] = null;
                    ++i;
                }
            }
            catch (Throwable throwable) {
                Object var2_4 = null;
                this.unlock();
                throw throwable;
            }
            {
                Object var2_5 = null;
            }
            this.unlock();
        }

        Segment(int initialCapacity, float lf) {
            this.loadFactor = lf;
            this.setTable(HashEntry.newArray(initialCapacity));
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    final class KeySet
    extends AbstractSet {
        public final Iterator iterator() {
            return new KeyIterator();
        }

        public final int size() {
            return ConcurrentHashMap.this.size();
        }

        public final boolean contains(Object o) {
            return ConcurrentHashMap.this.containsKey(o);
        }

        public final boolean remove(Object o) {
            boolean bl = false;
            if (ConcurrentHashMap.this.remove(o) != null) {
                bl = true;
            }
            return bl;
        }

        public final void clear() {
            ConcurrentHashMap.this.clear();
        }

        public final Object[] toArray() {
            ArrayList c = new ArrayList();
            Iterator i = this.iterator();
            while (i.hasNext()) {
                c.add(i.next());
            }
            return c.toArray();
        }

        public final Object[] toArray(Object[] a) {
            ArrayList c = new ArrayList();
            Iterator i = this.iterator();
            while (i.hasNext()) {
                c.add(i.next());
            }
            return c.toArray(a);
        }

        KeySet() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    final class Values
    extends AbstractCollection {
        public final Iterator iterator() {
            return new ValueIterator();
        }

        public final int size() {
            return ConcurrentHashMap.this.size();
        }

        public final boolean contains(Object o) {
            return ConcurrentHashMap.this.containsValue(o);
        }

        public final void clear() {
            ConcurrentHashMap.this.clear();
        }

        public final Object[] toArray() {
            ArrayList c = new ArrayList();
            Iterator i = this.iterator();
            while (i.hasNext()) {
                c.add(i.next());
            }
            return c.toArray();
        }

        public final Object[] toArray(Object[] a) {
            ArrayList c = new ArrayList();
            Iterator i = this.iterator();
            while (i.hasNext()) {
                c.add(i.next());
            }
            return c.toArray(a);
        }

        Values() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    final class EntrySet
    extends AbstractSet {
        public final Iterator iterator() {
            return new EntryIterator();
        }

        public final boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object v = ConcurrentHashMap.this.get(e.getKey());
            boolean bl = false;
            if (v != null && v.equals(e.getValue())) {
                bl = true;
            }
            return bl;
        }

        public final boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return ConcurrentHashMap.this.remove(e.getKey(), e.getValue());
        }

        public final int size() {
            return ConcurrentHashMap.this.size();
        }

        public final void clear() {
            ConcurrentHashMap.this.clear();
        }

        public final Object[] toArray() {
            ArrayList<AbstractMap.SimpleEntry> c = new ArrayList<AbstractMap.SimpleEntry>(this.size());
            Iterator i = this.iterator();
            while (i.hasNext()) {
                c.add(new AbstractMap.SimpleEntry((Map.Entry)i.next()));
            }
            return c.toArray();
        }

        public final Object[] toArray(Object[] a) {
            ArrayList<AbstractMap.SimpleEntry> c = new ArrayList<AbstractMap.SimpleEntry>(this.size());
            Iterator i = this.iterator();
            while (i.hasNext()) {
                c.add(new AbstractMap.SimpleEntry((Map.Entry)i.next()));
            }
            return c.toArray(a);
        }

        EntrySet() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    final class KeyIterator
    extends HashIterator
    implements Iterator,
    Enumeration {
        public final Object next() {
            return super.nextEntry().key;
        }

        public final Object nextElement() {
            return super.nextEntry().key;
        }

        KeyIterator() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    final class ValueIterator
    extends HashIterator
    implements Iterator,
    Enumeration {
        public final Object next() {
            return super.nextEntry().value;
        }

        public final Object nextElement() {
            return super.nextEntry().value;
        }

        ValueIterator() {
        }
    }

    static final class HashEntry {
        final Object key;
        final int hash;
        volatile Object value;
        final HashEntry next;

        static final HashEntry[] newArray(int i) {
            return new HashEntry[i];
        }

        HashEntry(Object key, int hash, HashEntry next, Object value) {
            this.key = key;
            this.hash = hash;
            this.next = next;
            this.value = value;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    final class EntryIterator
    extends HashIterator
    implements Map.Entry,
    Iterator {
        public final Object next() {
            this.nextEntry();
            return this;
        }

        public final Object getKey() {
            if (this.lastReturned == null) {
                throw new IllegalStateException("Entry was removed");
            }
            return this.lastReturned.key;
        }

        public final Object getValue() {
            if (this.lastReturned == null) {
                throw new IllegalStateException("Entry was removed");
            }
            return ConcurrentHashMap.this.get(this.lastReturned.key);
        }

        public final Object setValue(Object value) {
            if (this.lastReturned == null) {
                throw new IllegalStateException("Entry was removed");
            }
            return ConcurrentHashMap.this.put(this.lastReturned.key, value);
        }

        public final boolean equals(Object o) {
            if (this.lastReturned == null) {
                return super.equals(o);
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            boolean bl = false;
            if (this.eq(this.getKey(), e.getKey()) && this.eq(this.getValue(), e.getValue())) {
                bl = true;
            }
            return bl;
        }

        public final int hashCode() {
            if (this.lastReturned == null) {
                return super.hashCode();
            }
            Object k = this.getKey();
            Object v = this.getValue();
            int n = 0;
            if (k != null) {
                n = k.hashCode();
            }
            int n2 = 0;
            if (v != null) {
                n2 = v.hashCode();
            }
            return n ^ n2;
        }

        public final String toString() {
            if (this.lastReturned == null) {
                return super.toString();
            }
            return "" + this.getKey() + '=' + this.getValue();
        }

        final boolean eq(Object o1, Object o2) {
            boolean bl;
            if (o1 == null) {
                bl = false;
                if (o2 == null) {
                    bl = true;
                }
            } else {
                bl = o1.equals(o2);
            }
            return bl;
        }

        EntryIterator() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    abstract class HashIterator {
        int nextSegmentIndex;
        int nextTableIndex;
        HashEntry[] currentTable;
        HashEntry nextEntry;
        HashEntry lastReturned;

        public boolean hasMoreElements() {
            return this.hasNext();
        }

        /*
         * Unable to fully structure code
         */
        final void advance() {
            if (this.nextEntry == null || (this.nextEntry = this.nextEntry.next) == null) ** GOTO lbl5
            return;
lbl-1000:
            // 1 sources

            {
                if ((this.nextEntry = this.currentTable[this.nextTableIndex--]) == null) continue;
                return;
lbl5:
                // 2 sources

                ** while (this.nextTableIndex >= 0)
            }
lbl6:
            // 3 sources

            while (this.nextSegmentIndex >= 0) {
                seg = ConcurrentHashMap.this.segments[this.nextSegmentIndex--];
                if (seg.count == 0) continue;
                this.currentTable = seg.table;
                j = this.currentTable.length - 1;
                while (j >= 0) {
                    this.nextEntry = this.currentTable[j];
                    if (this.nextEntry != null) {
                        this.nextTableIndex = j - 1;
                        return;
                    }
                    --j;
                }
            }
        }

        public boolean hasNext() {
            boolean bl = false;
            if (this.nextEntry != null) {
                bl = true;
            }
            return bl;
        }

        HashEntry nextEntry() {
            if (this.nextEntry == null) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.nextEntry;
            this.advance();
            return this.lastReturned;
        }

        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            ConcurrentHashMap.this.remove(this.lastReturned.key);
            this.lastReturned = null;
        }

        HashIterator() {
            this.nextSegmentIndex = ConcurrentHashMap.this.segments.length - 1;
            this.nextTableIndex = -1;
            this.advance();
        }
    }
}

