/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util.concurrent;

import edu.emory.mathcs.backport.java.util.AbstractQueue;
import edu.emory.mathcs.backport.java.util.concurrent.BlockingDeque;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.helpers.Utils;
import edu.emory.mathcs.backport.java.util.concurrent.locks.Condition;
import edu.emory.mathcs.backport.java.util.concurrent.locks.ReentrantLock;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class LinkedBlockingDeque
extends AbstractQueue
implements BlockingDeque,
Serializable {
    private static final long serialVersionUID = -387911632671998426L;
    private transient Node first;
    private transient Node last;
    private transient int count;
    private final int capacity;
    private final ReentrantLock lock;
    private final Condition notEmpty;
    private final Condition notFull;

    private final boolean linkFirst(Object e) {
        Node x;
        if (this.count >= this.capacity) {
            return false;
        }
        ++this.count;
        Node f = this.first;
        this.first = x = new Node(e, null, f);
        if (this.last == null) {
            this.last = x;
        } else {
            f.prev = x;
        }
        this.notEmpty.signal();
        return true;
    }

    private final boolean linkLast(Object e) {
        Node x;
        if (this.count >= this.capacity) {
            return false;
        }
        ++this.count;
        Node l = this.last;
        this.last = x = new Node(e, l, null);
        if (this.first == null) {
            this.first = x;
        } else {
            l.next = x;
        }
        this.notEmpty.signal();
        return true;
    }

    private final Object unlinkFirst() {
        Node n;
        Node f = this.first;
        if (f == null) {
            return null;
        }
        this.first = n = f.next;
        if (n == null) {
            this.last = null;
        } else {
            n.prev = null;
        }
        --this.count;
        this.notFull.signal();
        return f.item;
    }

    private final Object unlinkLast() {
        Node p;
        Node l = this.last;
        if (l == null) {
            return null;
        }
        this.last = p = l.prev;
        if (p == null) {
            this.first = null;
        } else {
            p.next = null;
        }
        --this.count;
        this.notFull.signal();
        return l.item;
    }

    private final void unlink(Node x) {
        Node p = x.prev;
        Node n = x.next;
        if (p == null) {
            if (n == null) {
                this.last = null;
                this.first = null;
            } else {
                n.prev = null;
                this.first = n;
            }
        } else if (n == null) {
            p.next = null;
            this.last = p;
        } else {
            p.next = n;
            n.prev = p;
        }
        --this.count;
        this.notFull.signalAll();
    }

    public void addFirst(Object e) {
        if (!this.offerFirst(e)) {
            throw new IllegalStateException("Deque full");
        }
    }

    public void addLast(Object e) {
        if (!this.offerLast(e)) {
            throw new IllegalStateException("Deque full");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean offerFirst(Object e) {
        if (e == null) {
            throw new NullPointerException();
        }
        this.lock.lock();
        try {
            boolean bl = this.linkFirst(e);
            Object var3_3 = null;
            this.lock.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean offerLast(Object e) {
        if (e == null) {
            throw new NullPointerException();
        }
        this.lock.lock();
        try {
            boolean bl = this.linkLast(e);
            Object var3_3 = null;
            this.lock.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void putFirst(Object e) throws InterruptedException {
        if (e == null) {
            throw new NullPointerException();
        }
        this.lock.lock();
        try {
            while (!this.linkFirst(e)) {
                this.notFull.await();
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.lock.unlock();
            throw throwable;
        }
        {
            Object var3_4 = null;
            this.lock.unlock();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void putLast(Object e) throws InterruptedException {
        if (e == null) {
            throw new NullPointerException();
        }
        this.lock.lock();
        try {
            while (!this.linkLast(e)) {
                this.notFull.await();
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.lock.unlock();
            throw throwable;
        }
        {
            Object var3_4 = null;
            this.lock.unlock();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean offerFirst(Object e, long timeout, TimeUnit unit) throws InterruptedException {
        boolean bl;
        if (e == null) {
            throw new NullPointerException();
        }
        this.lock.lockInterruptibly();
        try {
            long nanos = unit.toNanos(timeout);
            long deadline = Utils.nanoTime() + nanos;
            while (true) {
                if (this.linkFirst(e)) {
                    boolean bl2 = true;
                    Object var6_8 = null;
                    this.lock.unlock();
                    return bl2;
                }
                if (nanos <= 0L) {
                    bl = false;
                    break;
                }
                this.notFull.await(nanos, TimeUnit.NANOSECONDS);
                nanos = deadline - Utils.nanoTime();
            }
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            this.lock.unlock();
            throw throwable;
        }
        Object var6_9 = null;
        this.lock.unlock();
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean offerLast(Object e, long timeout, TimeUnit unit) throws InterruptedException {
        boolean bl;
        if (e == null) {
            throw new NullPointerException();
        }
        this.lock.lockInterruptibly();
        try {
            long nanos = unit.toNanos(timeout);
            long deadline = Utils.nanoTime() + nanos;
            while (true) {
                if (this.linkLast(e)) {
                    boolean bl2 = true;
                    Object var6_8 = null;
                    this.lock.unlock();
                    return bl2;
                }
                if (nanos <= 0L) {
                    bl = false;
                    break;
                }
                this.notFull.await(nanos, TimeUnit.NANOSECONDS);
                nanos = deadline - Utils.nanoTime();
            }
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            this.lock.unlock();
            throw throwable;
        }
        Object var6_9 = null;
        this.lock.unlock();
        return bl;
    }

    public Object removeFirst() {
        Object x = this.pollFirst();
        if (x == null) {
            throw new NoSuchElementException();
        }
        return x;
    }

    public Object removeLast() {
        Object x = this.pollLast();
        if (x == null) {
            throw new NoSuchElementException();
        }
        return x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object pollFirst() {
        this.lock.lock();
        try {
            Object object = this.unlinkFirst();
            Object var2_2 = null;
            this.lock.unlock();
            return object;
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object pollLast() {
        this.lock.lock();
        try {
            Object object = this.unlinkLast();
            Object var2_2 = null;
            this.lock.unlock();
            return object;
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object takeFirst() throws InterruptedException {
        this.lock.lock();
        try {
            Object x;
            while ((x = this.unlinkFirst()) == null) {
                this.notEmpty.await();
            }
            Object object = x;
            Object var2_3 = null;
            this.lock.unlock();
            return object;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object takeLast() throws InterruptedException {
        this.lock.lock();
        try {
            Object x;
            while ((x = this.unlinkLast()) == null) {
                this.notEmpty.await();
            }
            Object object = x;
            Object var2_3 = null;
            this.lock.unlock();
            return object;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object pollFirst(long timeout, TimeUnit unit) throws InterruptedException {
        Object var6_7;
        this.lock.lockInterruptibly();
        try {
            long nanos = unit.toNanos(timeout);
            long deadline = Utils.nanoTime() + nanos;
            while (true) {
                Object x;
                if ((x = this.unlinkFirst()) != null) {
                    Object object = x;
                    Object var5_8 = null;
                    this.lock.unlock();
                    return object;
                }
                if (nanos <= 0L) {
                    var6_7 = null;
                    break;
                }
                this.notEmpty.await(nanos, TimeUnit.NANOSECONDS);
                nanos = deadline - Utils.nanoTime();
            }
        }
        catch (Throwable throwable) {
            Object var5_10 = null;
            this.lock.unlock();
            throw throwable;
        }
        Object var5_9 = null;
        this.lock.unlock();
        return var6_7;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object pollLast(long timeout, TimeUnit unit) throws InterruptedException {
        Object var6_7;
        this.lock.lockInterruptibly();
        try {
            long nanos = unit.toNanos(timeout);
            long deadline = Utils.nanoTime() + nanos;
            while (true) {
                Object x;
                if ((x = this.unlinkLast()) != null) {
                    Object object = x;
                    Object var5_8 = null;
                    this.lock.unlock();
                    return object;
                }
                if (nanos <= 0L) {
                    var6_7 = null;
                    break;
                }
                this.notEmpty.await(nanos, TimeUnit.NANOSECONDS);
                nanos = deadline - Utils.nanoTime();
            }
        }
        catch (Throwable throwable) {
            Object var5_10 = null;
            this.lock.unlock();
            throw throwable;
        }
        Object var5_9 = null;
        this.lock.unlock();
        return var6_7;
    }

    public Object getFirst() {
        Object x = this.peekFirst();
        if (x == null) {
            throw new NoSuchElementException();
        }
        return x;
    }

    public Object getLast() {
        Object x = this.peekLast();
        if (x == null) {
            throw new NoSuchElementException();
        }
        return x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object peekFirst() {
        this.lock.lock();
        try {
            Object object = this.first == null ? null : this.first.item;
            Object var2_2 = null;
            this.lock.unlock();
            return object;
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object peekLast() {
        this.lock.lock();
        try {
            Object object = this.last == null ? null : this.last.item;
            Object var2_2 = null;
            this.lock.unlock();
            return object;
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean removeFirstOccurrence(Object o) {
        boolean bl;
        if (o == null) {
            return false;
        }
        this.lock.lock();
        try {
            Node p = this.first;
            while (true) {
                if (p == null) {
                    bl = false;
                    break;
                }
                if (o.equals(p.item)) {
                    this.unlink(p);
                    boolean bl2 = true;
                    Object var3_5 = null;
                    this.lock.unlock();
                    return bl2;
                }
                p = p.next;
            }
        }
        catch (Throwable throwable) {
            Object var3_7 = null;
            this.lock.unlock();
            throw throwable;
        }
        Object var3_6 = null;
        this.lock.unlock();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean removeLastOccurrence(Object o) {
        boolean bl;
        if (o == null) {
            return false;
        }
        this.lock.lock();
        try {
            Node p = this.last;
            while (true) {
                if (p == null) {
                    bl = false;
                    break;
                }
                if (o.equals(p.item)) {
                    this.unlink(p);
                    boolean bl2 = true;
                    Object var3_5 = null;
                    this.lock.unlock();
                    return bl2;
                }
                p = p.prev;
            }
        }
        catch (Throwable throwable) {
            Object var3_7 = null;
            this.lock.unlock();
            throw throwable;
        }
        Object var3_6 = null;
        this.lock.unlock();
        return bl;
    }

    public boolean add(Object e) {
        this.addLast(e);
        return true;
    }

    public boolean offer(Object e) {
        return this.offerLast(e);
    }

    public void put(Object e) throws InterruptedException {
        this.putLast(e);
    }

    public boolean offer(Object e, long timeout, TimeUnit unit) throws InterruptedException {
        return this.offerLast(e, timeout, unit);
    }

    public Object remove() {
        return this.removeFirst();
    }

    public Object poll() {
        return this.pollFirst();
    }

    public Object take() throws InterruptedException {
        return this.takeFirst();
    }

    public Object poll(long timeout, TimeUnit unit) throws InterruptedException {
        return this.pollFirst(timeout, unit);
    }

    public Object element() {
        return this.getFirst();
    }

    public Object peek() {
        return this.peekFirst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int remainingCapacity() {
        this.lock.lock();
        try {
            int n = this.capacity - this.count;
            Object var2_2 = null;
            this.lock.unlock();
            return n;
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int drainTo(Collection c) {
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == this) {
            throw new IllegalArgumentException();
        }
        this.lock.lock();
        try {
            Node p = this.first;
            while (p != null) {
                c.add(p.item);
                p = p.next;
            }
            int n = this.count;
            this.count = 0;
            this.last = null;
            this.first = null;
            this.notFull.signalAll();
            int n2 = n;
            Object var3_5 = null;
            this.lock.unlock();
            return n2;
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int drainTo(Collection c, int maxElements) {
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == this) {
            throw new IllegalArgumentException();
        }
        this.lock.lock();
        try {
            int n = 0;
            while (n < maxElements && this.first != null) {
                c.add(this.first.item);
                this.first.prev = null;
                this.first = this.first.next;
                --this.count;
                ++n;
            }
            if (this.first == null) {
                this.last = null;
            }
            this.notFull.signalAll();
            int n2 = n;
            Object var4_5 = null;
            this.lock.unlock();
            return n2;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    public void push(Object e) {
        this.addFirst(e);
    }

    public Object pop() {
        return this.removeFirst();
    }

    public boolean remove(Object o) {
        return this.removeFirstOccurrence(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        this.lock.lock();
        try {
            int n = this.count;
            Object var2_2 = null;
            this.lock.unlock();
            return n;
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean contains(Object o) {
        boolean bl;
        if (o == null) {
            return false;
        }
        this.lock.lock();
        try {
            Node p = this.first;
            while (true) {
                if (p == null) {
                    bl = false;
                    break;
                }
                if (o.equals(p.item)) {
                    boolean bl2 = true;
                    Object var3_5 = null;
                    this.lock.unlock();
                    return bl2;
                }
                p = p.next;
            }
        }
        catch (Throwable throwable) {
            Object var3_7 = null;
            this.lock.unlock();
            throw throwable;
        }
        Object var3_6 = null;
        this.lock.unlock();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean removeNode(Node e) {
        boolean bl;
        this.lock.lock();
        try {
            Node p = this.first;
            while (true) {
                if (p == null) {
                    bl = false;
                    break;
                }
                if (p == e) {
                    this.unlink(p);
                    boolean bl2 = true;
                    Object var3_5 = null;
                    this.lock.unlock();
                    return bl2;
                }
                p = p.next;
            }
        }
        catch (Throwable throwable) {
            Object var3_7 = null;
            this.lock.unlock();
            throw throwable;
        }
        Object var3_6 = null;
        this.lock.unlock();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray() {
        this.lock.lock();
        try {
            Object[] a = new Object[this.count];
            int k = 0;
            Node p = this.first;
            while (p != null) {
                a[k++] = p.item;
                p = p.next;
            }
            Object[] objectArray = a;
            Object var2_5 = null;
            this.lock.unlock();
            return objectArray;
        }
        catch (Throwable throwable) {
            Object var2_6 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray(Object[] a) {
        this.lock.lock();
        try {
            if (a.length < this.count) {
                a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.count);
            }
            int k = 0;
            Node p = this.first;
            while (p != null) {
                a[k++] = p.item;
                p = p.next;
            }
            if (a.length > k) {
                a[k] = null;
            }
            Object[] objectArray = a;
            Object var3_5 = null;
            this.lock.unlock();
            return objectArray;
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        this.lock.lock();
        try {
            String string = super.toString();
            Object var2_2 = null;
            this.lock.unlock();
            return string;
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void clear() {
        this.lock.lock();
        try {
            this.last = null;
            this.first = null;
            this.count = 0;
            this.notFull.signalAll();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.lock.unlock();
            throw throwable;
        }
        {
            Object var2_3 = null;
            this.lock.unlock();
            return;
        }
    }

    public Iterator iterator() {
        return new Itr();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void writeObject(ObjectOutputStream s) throws IOException {
        this.lock.lock();
        try {
            s.defaultWriteObject();
            Node p = this.first;
            while (true) {
                block4: {
                    if (p != null) break block4;
                    s.writeObject(null);
                    break;
                }
                s.writeObject(p.item);
                p = p.next;
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.lock.unlock();
            throw throwable;
        }
        {
            Object var3_5 = null;
            this.lock.unlock();
            return;
        }
    }

    private final void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        Object item;
        s.defaultReadObject();
        this.count = 0;
        this.first = null;
        this.last = null;
        while ((item = s.readObject()) != null) {
            this.add(item);
        }
    }

    private final /* synthetic */ void this() {
        this.lock = new ReentrantLock();
        this.notEmpty = this.lock.newCondition();
        this.notFull = this.lock.newCondition();
    }

    public LinkedBlockingDeque() {
        this(Integer.MAX_VALUE);
    }

    public LinkedBlockingDeque(int capacity) {
        this.this();
        if (capacity <= 0) {
            throw new IllegalArgumentException();
        }
        this.capacity = capacity;
    }

    public LinkedBlockingDeque(Collection c) {
        this(Integer.MAX_VALUE);
        Iterator itr = c.iterator();
        while (itr.hasNext()) {
            Object e = itr.next();
            this.add(e);
        }
    }

    static final class Node {
        Object item;
        Node prev;
        Node next;

        Node(Object x, Node p, Node n) {
            this.item = x;
            this.prev = p;
            this.next = n;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class Itr
    implements Iterator {
        private Node next;
        private Object nextItem;
        private Node last;

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private final void advance() {
            ReentrantLock lock = LinkedBlockingDeque.this.lock;
            lock.lock();
            try {
                this.next = this.next == null ? LinkedBlockingDeque.this.first : this.next.next;
                this.nextItem = this.next == null ? null : this.next.item;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                lock.unlock();
                throw throwable;
            }
            {
                Object var3_4 = null;
                lock.unlock();
                return;
            }
        }

        public boolean hasNext() {
            boolean bl = false;
            if (this.next != null) {
                bl = true;
            }
            return bl;
        }

        public Object next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            this.last = this.next;
            Object x = this.nextItem;
            this.advance();
            return x;
        }

        public void remove() {
            Node n = this.last;
            if (n == null) {
                throw new IllegalStateException();
            }
            this.last = null;
            LinkedBlockingDeque.this.removeNode(n);
        }

        Itr() {
            this.advance();
        }
    }
}

