/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util.concurrent;

import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.helpers.FIFOWaitQueue;
import edu.emory.mathcs.backport.java.util.concurrent.helpers.WaitQueue;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;

public class Semaphore
implements Serializable {
    private static final long serialVersionUID = -3222578661600680210L;
    private final Sync sync;

    public void acquire() throws InterruptedException {
        this.sync.acquire();
    }

    public void acquireUninterruptibly() {
        boolean wasInterrupted = false;
        while (true) {
            try {
                this.sync.acquire();
                if (wasInterrupted) {
                    Thread.currentThread().interrupt();
                }
                return;
            }
            catch (InterruptedException e) {
                wasInterrupted = true;
                continue;
            }
            break;
        }
    }

    public boolean tryAcquire() {
        return this.sync.attempt();
    }

    public boolean tryAcquire(long timeout, TimeUnit unit) throws InterruptedException {
        return this.sync.attempt(unit.toNanos(timeout));
    }

    public void release() {
        this.sync.release(1);
    }

    public void release(int permits) {
        if (permits < 0) {
            throw new IllegalArgumentException();
        }
        this.sync.release(permits);
    }

    public int availablePermits() {
        return this.sync.getPermits();
    }

    public int drainPermits() {
        return this.sync.drain();
    }

    protected void reducePermits(int reduction) {
        if (reduction < 0) {
            throw new IllegalArgumentException();
        }
        this.sync.reduce(reduction);
    }

    public boolean isFair() {
        return this.sync instanceof FairSync;
    }

    public final boolean hasQueuedThreads() {
        return this.sync.hasQueuedThreads();
    }

    public final int getQueueLength() {
        return this.sync.getQueueLength();
    }

    protected Collection getQueuedThreads() {
        return this.sync.getQueuedThreads();
    }

    public String toString() {
        return super.toString() + "[Permits = " + this.sync.getPermits() + ']';
    }

    public Semaphore(int permits) {
        this.sync = new NonfairSync(permits);
    }

    public Semaphore(int permits, boolean fair) {
        this.sync = fair ? new FairSync(permits) : new NonfairSync(permits);
    }

    static abstract class Sync
    implements Serializable {
        private static final long serialVersionUID = 1192457210091910933L;
        int permits_;

        abstract void acquire() throws InterruptedException;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean attempt() {
            Sync sync = this;
            synchronized (sync) {
                if (this.permits_ > 0) {
                    --this.permits_;
                    return true;
                }
                return false;
            }
        }

        abstract boolean attempt(long var1) throws InterruptedException;

        abstract void release(int var1);

        public synchronized int getPermits() {
            return this.permits_;
        }

        public synchronized int drain() {
            int acquired = this.permits_;
            this.permits_ = 0;
            return acquired;
        }

        public synchronized void reduce(int reduction) {
            this.permits_ -= reduction;
        }

        abstract boolean hasQueuedThreads();

        abstract int getQueueLength();

        abstract Collection getQueuedThreads();

        protected Sync(int permits) {
            this.permits_ = permits;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    static final class FairSync
    extends Sync
    implements WaitQueue.QueuedSync {
        private static final long serialVersionUID = 2014338818796000944L;
        private transient WaitQueue wq_;

        public final void acquire() throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (this.precheck()) {
                return;
            }
            WaitQueue.WaitNode w = new WaitQueue.WaitNode();
            w.doWait(this);
        }

        public final boolean attempt(long nanos) throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (this.precheck()) {
                return true;
            }
            if (nanos <= 0L) {
                return false;
            }
            WaitQueue.WaitNode w = new WaitQueue.WaitNode();
            return w.doTimedWait(this, nanos);
        }

        protected final synchronized boolean precheck() {
            boolean pass;
            boolean bl = false;
            if (this.permits_ > 0) {
                bl = true;
            }
            if (pass = bl) {
                --this.permits_;
            }
            return pass;
        }

        public final synchronized boolean recheck(WaitQueue.WaitNode w) {
            boolean pass;
            boolean bl = false;
            if (this.permits_ > 0) {
                bl = true;
            }
            if (pass = bl) {
                --this.permits_;
            } else {
                this.wq_.insert(w);
            }
            return pass;
        }

        public final void takeOver(WaitQueue.WaitNode n) {
        }

        protected final synchronized WaitQueue.WaitNode getSignallee() {
            WaitQueue.WaitNode w = this.wq_.extract();
            if (w == null) {
                ++this.permits_;
            }
            return w;
        }

        public final void release() {
            WaitQueue.WaitNode w;
            do {
                if ((w = this.getSignallee()) != null) continue;
                return;
            } while (!w.signal(this));
        }

        public final void release(int n) {
            if (n < 0) {
                throw new IllegalArgumentException("Negative argument");
            }
            int i = 0;
            while (i < n) {
                this.release();
                ++i;
            }
        }

        public final synchronized boolean hasQueuedThreads() {
            return this.wq_.hasNodes();
        }

        public final synchronized int getQueueLength() {
            return this.wq_.getLength();
        }

        public final synchronized Collection getQueuedThreads() {
            return this.wq_.getWaitingThreads();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private final void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            FairSync fairSync = this;
            synchronized (fairSync) {
                this.wq_ = new FIFOWaitQueue();
                return;
            }
        }

        private final /* synthetic */ void this() {
            this.wq_ = new FIFOWaitQueue();
        }

        FairSync(int initialPermits) {
            super(initialPermits);
            this.this();
        }
    }

    static final class NonfairSync
    extends Sync {
        private static final long serialVersionUID = -2694183684443567898L;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public final void acquire() throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            NonfairSync nonfairSync = this;
            synchronized (nonfairSync) {
                try {
                    while (true) {
                        if (this.permits_ > 0) {
                            --this.permits_;
                            break;
                        }
                        this.wait();
                    }
                }
                catch (InterruptedException ex) {
                    this.notify();
                    throw ex;
                }
                return;
            }
        }

        /*
         * Exception decompiling
         */
        public final boolean attempt(long nanos) throws InterruptedException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 0[TRYBLOCK] [8 : 24->120)] java.lang.Throwable
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public final synchronized void release(int n) {
            if (n < 0) {
                throw new IllegalArgumentException("Negative argument");
            }
            this.permits_ += n;
            int i = 0;
            while (i < n) {
                this.notify();
                ++i;
            }
        }

        public final boolean hasQueuedThreads() {
            throw new UnsupportedOperationException("Use FAIR version");
        }

        public final int getQueueLength() {
            throw new UnsupportedOperationException("Use FAIR version");
        }

        public final Collection getQueuedThreads() {
            throw new UnsupportedOperationException("Use FAIR version");
        }

        protected NonfairSync(int initialPermits) {
            super(initialPermits);
        }
    }
}

