/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util.concurrent;

import edu.emory.mathcs.backport.java.util.concurrent.AbstractExecutorService;
import edu.emory.mathcs.backport.java.util.concurrent.BlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.Executors;
import edu.emory.mathcs.backport.java.util.concurrent.Future;
import edu.emory.mathcs.backport.java.util.concurrent.RejectedExecutionException;
import edu.emory.mathcs.backport.java.util.concurrent.RejectedExecutionHandler;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadFactory;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.helpers.Utils;
import edu.emory.mathcs.backport.java.util.concurrent.locks.ReentrantLock;
import java.security.AccessController;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ThreadPoolExecutor
extends AbstractExecutorService {
    private static final Runnable[] EMPTY_RUNNABLE_ARRAY;
    private static final RuntimePermission shutdownPerm;
    static final int RUNNING = 0;
    static final int SHUTDOWN = 1;
    static final int STOP = 2;
    static final int TERMINATED = 3;
    private static final RejectedExecutionHandler defaultHandler;
    private final BlockingQueue workQueue;
    private final Object mainLock;
    private final HashSet workers;
    private volatile long keepAliveTime;
    private boolean allowCoreThreadTimeOut;
    private volatile int corePoolSize;
    private volatile int maximumPoolSize;
    private volatile int poolSize;
    volatile int runState;
    private volatile RejectedExecutionHandler handler;
    private volatile ThreadFactory threadFactory;
    private int largestPoolSize;
    private long completedTaskCount;
    private static final /* synthetic */ boolean assert;

    void reject(Runnable command) {
        this.handler.rejectedExecution(command, this);
    }

    private final Thread addThread(Runnable firstTask) {
        Worker w = new Worker(firstTask);
        Thread t = this.threadFactory.newThread(w);
        if (t != null) {
            w.thread = t;
            this.workers.add(w);
            int nt = ++this.poolSize;
            if (nt > this.largestPoolSize) {
                this.largestPoolSize = nt;
            }
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean addIfUnderCorePoolSize(Runnable firstTask) {
        Thread t = null;
        Object object = this.mainLock;
        synchronized (object) {
            if (this.poolSize < this.corePoolSize) {
                t = this.addThread(firstTask);
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl7 : MonitorExitStatement: MONITOREXIT : var3_3
            if (t == null) {
                return false;
            }
        }
        t.start();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Runnable addIfUnderMaximumPoolSize(Runnable firstTask) {
        Thread t = null;
        Runnable next = null;
        Object object = this.mainLock;
        synchronized (object) {
            if (this.poolSize < this.maximumPoolSize) {
                next = (Runnable)this.workQueue.poll();
                if (next == null) {
                    next = firstTask;
                }
                t = this.addThread(next);
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl11 : MonitorExitStatement: MONITOREXIT : var4_4
            if (t == null) {
                return null;
            }
        }
        t.start();
        return next;
    }

    /*
     * Exception decompiling
     */
    Runnable getTask() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CASE]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void interruptIdleWorkers() {
        Object object = this.mainLock;
        synchronized (object) {
            Iterator itr = this.workers.iterator();
            while (itr.hasNext()) {
                Worker w = (Worker)itr.next();
                w.interruptIfIdle();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void workerDone(Worker w) {
        block9: {
            Object object = this.mainLock;
            synchronized (object) {
                this.completedTaskCount += w.completedTasks;
                this.workers.remove(w);
                if (--this.poolSize > 0) {
                    return;
                }
                int state = this.runState;
                if (!assert && state == 3) {
                    throw new AssertionError();
                }
                if (state != 2) {
                    if (!this.workQueue.isEmpty()) {
                        Thread t = this.addThread(null);
                        if (t == null) return;
                        t.start();
                        return;
                    }
                    if (state == 0) {
                        return;
                    }
                }
                this.mainLock.notifyAll();
                this.runState = 3;
                // MONITOREXIT @DISABLED, blocks:[0, 1] lbl25 : MonitorExitStatement: MONITOREXIT : var2_2
                if (assert || this.runState == 3) break block9;
                throw new AssertionError();
            }
        }
        this.terminated();
    }

    public void execute(Runnable command) {
        Runnable r;
        if (command == null) {
            throw new NullPointerException();
        }
        do {
            if (this.runState != 0) {
                this.reject(command);
                return;
            }
            if (this.poolSize < this.corePoolSize && this.addIfUnderCorePoolSize(command)) {
                return;
            }
            if (this.workQueue.offer(command)) {
                return;
            }
            r = this.addIfUnderMaximumPoolSize(command);
            if (r != command) continue;
            return;
        } while (r != null);
        this.reject(command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void shutdown() {
        boolean fullyTerminated;
        block9: {
            int state;
            block10: {
                SecurityManager security = System.getSecurityManager();
                if (security != null) {
                    AccessController.checkPermission(shutdownPerm);
                }
                fullyTerminated = false;
                Object object = this.mainLock;
                // MONITORENTER : object
                if (this.workers.size() <= 0) break block9;
                if (security == null) break block10;
                Iterator itr = this.workers.iterator();
                while (itr.hasNext()) {
                    Worker w = (Worker)itr.next();
                    security.checkAccess(w.thread);
                }
            }
            if ((state = this.runState) == 0) {
                this.runState = 1;
            }
            try {
                Iterator itr = this.workers.iterator();
                while (itr.hasNext()) {
                    Worker w = (Worker)itr.next();
                    w.interruptIfIdle();
                }
            }
            catch (SecurityException se) {
                this.runState = state;
                throw se;
            }
        }
        fullyTerminated = true;
        this.runState = 3;
        this.mainLock.notifyAll();
        // MONITOREXIT : object
        if (!fullyTerminated) return;
        this.terminated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public List shutdownNow() {
        boolean fullyTerminated;
        block9: {
            int state;
            block10: {
                SecurityManager security = System.getSecurityManager();
                if (security != null) {
                    AccessController.checkPermission(shutdownPerm);
                }
                fullyTerminated = false;
                Object object = this.mainLock;
                // MONITORENTER : object
                if (this.workers.size() <= 0) break block9;
                if (security == null) break block10;
                Iterator itr = this.workers.iterator();
                while (itr.hasNext()) {
                    Worker w = (Worker)itr.next();
                    security.checkAccess(w.thread);
                }
            }
            if ((state = this.runState) != 3) {
                this.runState = 2;
            }
            try {
                Iterator itr = this.workers.iterator();
                while (itr.hasNext()) {
                    Worker w = (Worker)itr.next();
                    w.interruptNow();
                }
            }
            catch (SecurityException se) {
                this.runState = state;
                throw se;
            }
        }
        fullyTerminated = true;
        this.runState = 3;
        this.mainLock.notifyAll();
        // MONITOREXIT : object
        if (!fullyTerminated) return Arrays.asList(this.workQueue.toArray(EMPTY_RUNNABLE_ARRAY));
        this.terminated();
        return Arrays.asList(this.workQueue.toArray(EMPTY_RUNNABLE_ARRAY));
    }

    public boolean isShutdown() {
        boolean bl = false;
        if (this.runState != 0) {
            bl = true;
        }
        return bl;
    }

    public boolean isTerminating() {
        boolean bl = false;
        if (this.runState == 2) {
            bl = true;
        }
        return bl;
    }

    public boolean isTerminated() {
        boolean bl = false;
        if (this.runState == 3) {
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        long nanos = unit.toNanos(timeout);
        Object object = this.mainLock;
        synchronized (object) {
            long deadline = Utils.nanoTime() + nanos;
            while (this.runState != 3) {
                if (nanos <= 0L) {
                    return false;
                }
                TimeUnit.NANOSECONDS.timedWait(this.mainLock, nanos);
                nanos = deadline - Utils.nanoTime();
            }
            return true;
        }
    }

    protected void finalize() {
        this.shutdown();
    }

    public void setThreadFactory(ThreadFactory threadFactory) {
        if (threadFactory == null) {
            throw new NullPointerException();
        }
        this.threadFactory = threadFactory;
    }

    public ThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    public void setRejectedExecutionHandler(RejectedExecutionHandler handler) {
        if (handler == null) {
            throw new NullPointerException();
        }
        this.handler = handler;
    }

    public RejectedExecutionHandler getRejectedExecutionHandler() {
        return this.handler;
    }

    public BlockingQueue getQueue() {
        return this.workQueue;
    }

    public boolean remove(Runnable task) {
        return this.getQueue().remove(task);
    }

    public void purge() {
        try {
            Iterator it = this.getQueue().iterator();
            while (it.hasNext()) {
                Future c;
                Runnable r = (Runnable)it.next();
                if (!(r instanceof Future) || !(c = (Future)((Object)r)).isCancelled()) continue;
                it.remove();
            }
        }
        catch (ConcurrentModificationException ex) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setCorePoolSize(int corePoolSize) {
        if (corePoolSize < 0) {
            throw new IllegalArgumentException();
        }
        Object object = this.mainLock;
        synchronized (object) {
            block8: {
                int extra;
                block7: {
                    Thread t;
                    extra = this.corePoolSize - corePoolSize;
                    this.corePoolSize = corePoolSize;
                    if (extra >= 0) break block7;
                    int n = this.workQueue.size();
                    while (extra++ < 0 && n-- > 0 && this.poolSize < corePoolSize && (t = this.addThread(null)) != null) {
                        t.start();
                    }
                    break block8;
                }
                if (extra > 0 && this.poolSize > corePoolSize) {
                    Iterator it = this.workers.iterator();
                    while (it.hasNext() && extra-- > 0 && this.poolSize > corePoolSize && this.workQueue.remainingCapacity() == 0) {
                        ((Worker)it.next()).interruptIfIdle();
                    }
                }
            }
            return;
        }
    }

    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    public boolean prestartCoreThread() {
        return this.addIfUnderCorePoolSize(null);
    }

    public int prestartAllCoreThreads() {
        int n = 0;
        while (this.addIfUnderCorePoolSize(null)) {
            ++n;
        }
        return n;
    }

    public boolean allowsCoreThreadTimeOut() {
        return this.allowCoreThreadTimeOut;
    }

    public void allowCoreThreadTimeOut(boolean value) {
        if (value && this.keepAliveTime <= 0L) {
            throw new IllegalArgumentException("Core threads must have nonzero keep alive times");
        }
        this.allowCoreThreadTimeOut = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setMaximumPoolSize(int maximumPoolSize) {
        if (maximumPoolSize <= 0 || maximumPoolSize < this.corePoolSize) {
            throw new IllegalArgumentException();
        }
        Object object = this.mainLock;
        synchronized (object) {
            block5: {
                int extra = this.maximumPoolSize - maximumPoolSize;
                this.maximumPoolSize = maximumPoolSize;
                if (extra <= 0 || this.poolSize <= maximumPoolSize) break block5;
                Iterator it = this.workers.iterator();
                while (it.hasNext() && extra > 0 && this.poolSize > maximumPoolSize) {
                    ((Worker)it.next()).interruptIfIdle();
                    --extra;
                }
            }
            return;
        }
    }

    public int getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    public void setKeepAliveTime(long time, TimeUnit unit) {
        if (time < 0L) {
            throw new IllegalArgumentException();
        }
        if (time == 0L && this.allowsCoreThreadTimeOut()) {
            throw new IllegalArgumentException("Core threads must have nonzero keep alive times");
        }
        this.keepAliveTime = unit.toNanos(time);
    }

    public long getKeepAliveTime(TimeUnit unit) {
        return unit.convert(this.keepAliveTime, TimeUnit.NANOSECONDS);
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getActiveCount() {
        Object object = this.mainLock;
        synchronized (object) {
            int n = 0;
            Iterator itr = this.workers.iterator();
            while (itr.hasNext()) {
                Worker w = (Worker)itr.next();
                if (!w.isActive()) continue;
                ++n;
            }
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getLargestPoolSize() {
        Object object = this.mainLock;
        synchronized (object) {
            return this.largestPoolSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getTaskCount() {
        Object object = this.mainLock;
        synchronized (object) {
            long n = this.completedTaskCount;
            Iterator itr = this.workers.iterator();
            while (itr.hasNext()) {
                Worker w = (Worker)itr.next();
                n += w.completedTasks;
                if (!w.isActive()) continue;
                ++n;
            }
            return n + (long)this.workQueue.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getCompletedTaskCount() {
        Object object = this.mainLock;
        synchronized (object) {
            long n = this.completedTaskCount;
            Iterator itr = this.workers.iterator();
            while (itr.hasNext()) {
                Worker w = (Worker)itr.next();
                n += w.completedTasks;
            }
            return n;
        }
    }

    protected void beforeExecute(Thread t, Runnable r) {
    }

    protected void afterExecute(Runnable r, Throwable t) {
    }

    protected void terminated() {
    }

    private final /* synthetic */ void this() {
        this.mainLock = new Object();
        this.workers = new HashSet();
    }

    public ThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue workQueue) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, Executors.defaultThreadFactory(), defaultHandler);
    }

    public ThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue workQueue, ThreadFactory threadFactory) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, defaultHandler);
    }

    public ThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue workQueue, RejectedExecutionHandler handler) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, Executors.defaultThreadFactory(), handler);
    }

    public ThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        this.this();
        if (corePoolSize < 0 || maximumPoolSize <= 0 || maximumPoolSize < corePoolSize || keepAliveTime < 0L) {
            throw new IllegalArgumentException();
        }
        if (workQueue == null || threadFactory == null || handler == null) {
            throw new NullPointerException();
        }
        this.corePoolSize = corePoolSize;
        this.maximumPoolSize = maximumPoolSize;
        this.workQueue = workQueue;
        this.keepAliveTime = unit.toNanos(keepAliveTime);
        this.threadFactory = threadFactory;
        this.handler = handler;
    }

    static {
        assert = Class.forName("[Ledu.emory.mathcs.backport.java.util.concurrent.ThreadPoolExecutor;").getComponentType().desiredAssertionStatus() ^ true;
        EMPTY_RUNNABLE_ARRAY = new Runnable[0];
        shutdownPerm = new RuntimePermission("modifyThread");
        defaultHandler = new AbortPolicy();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class Worker
    implements Runnable {
        private final ReentrantLock runLock;
        private Runnable firstTask;
        volatile long completedTasks;
        Thread thread;

        boolean isActive() {
            return this.runLock.isLocked();
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void interruptIfIdle() {
            ReentrantLock runLock = this.runLock;
            if (!runLock.tryLock()) return;
            try {
                this.thread.interrupt();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                runLock.unlock();
                throw throwable;
            }
            {
                Object var3_4 = null;
                runLock.unlock();
                return;
            }
        }

        void interruptNow() {
            this.thread.interrupt();
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private final void runTask(Runnable task) {
            ReentrantLock runLock = this.runLock;
            runLock.lock();
            try {
                Thread.interrupted();
                if (ThreadPoolExecutor.this.runState == 2) {
                    Object var4_3 = null;
                    runLock.unlock();
                    return;
                }
                boolean ran = false;
                ThreadPoolExecutor.this.beforeExecute(this.thread, task);
                try {
                    task.run();
                    ran = true;
                    ThreadPoolExecutor.this.afterExecute(task, null);
                    ++this.completedTasks;
                }
                catch (RuntimeException ex) {
                    if (ran) throw ex;
                    ThreadPoolExecutor.this.afterExecute(task, ex);
                    throw ex;
                }
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                runLock.unlock();
                throw throwable;
            }
            {
                Object var4_5 = null;
                runLock.unlock();
                return;
            }
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                Runnable task = this.firstTask;
                this.firstTask = null;
                while (task != null || (task = ThreadPoolExecutor.this.getTask()) != null) {
                    this.runTask(task);
                    task = null;
                }
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                ThreadPoolExecutor.this.workerDone(this);
                throw throwable;
            }
            {
                Object var2_4 = null;
                ThreadPoolExecutor.this.workerDone(this);
                return;
            }
        }

        private final /* synthetic */ void this() {
            this.runLock = new ReentrantLock();
        }

        Worker(Runnable firstTask) {
            this.this();
            this.firstTask = firstTask;
        }
    }

    public static class AbortPolicy
    implements RejectedExecutionHandler {
        public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
            throw new RejectedExecutionException();
        }
    }

    public static class DiscardOldestPolicy
    implements RejectedExecutionHandler {
        public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
            if (!e.isShutdown()) {
                e.getQueue().poll();
                e.execute(r);
            }
        }
    }

    public static class DiscardPolicy
    implements RejectedExecutionHandler {
        public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
        }
    }

    public static class CallerRunsPolicy
    implements RejectedExecutionHandler {
        public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
            if (!e.isShutdown()) {
                r.run();
            }
        }
    }
}

