/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.core.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.portlet.PortalContext;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.portlet.WindowState;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpSession;
import org.apache.pluto.core.InternalPortletRequest;
import org.apache.pluto.core.impl.PortletModeHelper;
import org.apache.pluto.factory.PortletObjectAccess;
import org.apache.pluto.om.common.SecurityRoleRef;
import org.apache.pluto.om.common.SecurityRoleRefSet;
import org.apache.pluto.om.entity.PortletEntity;
import org.apache.pluto.om.portlet.PortletDefinition;
import org.apache.pluto.om.window.PortletWindow;
import org.apache.pluto.services.information.DynamicInformationProvider;
import org.apache.pluto.services.information.InformationProviderAccess;
import org.apache.pluto.services.property.PropertyManager;
import org.apache.pluto.util.Enumerator;
import org.apache.pluto.util.NamespaceMapperAccess;
import org.apache.pluto.util.StringUtils;

public abstract class PortletRequestImpl
extends HttpServletRequestWrapper
implements PortletRequest,
InternalPortletRequest {
    private PortletWindow portletWindow;
    private PortletSession portletSession;
    private DynamicInformationProvider provider;
    private boolean bodyAccessed;
    private boolean included;

    public PortletRequestImpl(PortletWindow portletWindow, HttpServletRequest servletRequest) {
        super(servletRequest);
        this.portletWindow = portletWindow;
        this.provider = InformationProviderAccess.getDynamicProvider(this._getHttpServletRequest());
    }

    public boolean isWindowStateAllowed(WindowState state) {
        return this.provider.isWindowStateAllowed(state);
    }

    public boolean isPortletModeAllowed(PortletMode portletMode) {
        boolean supported = this.provider.isPortletModeAllowed(portletMode);
        if (supported) {
            supported = PortletModeHelper.isPortletModeAllowedByPortlet(this.portletWindow, portletMode);
        }
        return supported;
    }

    public PortletMode getPortletMode() {
        return this.provider.getPortletMode(this.portletWindow);
    }

    public WindowState getWindowState() {
        return this.provider.getWindowState(this.portletWindow);
    }

    public abstract PortletPreferences getPreferences();

    public PortletSession getPortletSession() {
        return this.getPortletSession(true);
    }

    public PortletSession getPortletSession(boolean create) {
        HttpSession httpSession = this._getHttpServletRequest().getSession(false);
        if (this.portletSession != null && httpSession == null) {
            this.portletSession = null;
        } else if (httpSession != null) {
            create = true;
        }
        if (create && this.portletSession == null && (httpSession = this._getHttpServletRequest().getSession(create)) != null) {
            this.portletSession = PortletObjectAccess.getPortletSession(this.portletWindow, httpSession);
        }
        return this.portletSession;
    }

    public String getProperty(String name) {
        String[] properties;
        Map map;
        if (name == null) {
            throw new IllegalArgumentException("Attribute name == null");
        }
        String prop = this._getHttpServletRequest().getHeader(name);
        if (prop == null && (map = PropertyManager.getRequestProperties(this.portletWindow, this._getHttpServletRequest())) != null && (properties = (String[])map.get(name)) != null && properties.length > 0) {
            prop = properties[0];
        }
        return prop;
    }

    public Enumeration getProperties(String name) {
        String[] properties;
        Map map;
        if (name == null) {
            throw new IllegalArgumentException("Property name == null");
        }
        HashSet v = new HashSet();
        Enumeration props = this._getHttpServletRequest().getHeaders(name);
        if (props != null) {
            while (props.hasMoreElements()) {
                v.add(props.nextElement());
            }
        }
        if ((map = PropertyManager.getRequestProperties(this.portletWindow, this._getHttpServletRequest())) != null && (properties = (String[])map.get(name)) != null) {
            for (int i = 0; i < properties.length; ++i) {
                v.add(properties[i]);
            }
        }
        return new Enumerator(v.iterator());
    }

    public Enumeration getPropertyNames() {
        Enumeration props;
        HashSet<Object> v = new HashSet<Object>();
        Map map = PropertyManager.getRequestProperties(this.portletWindow, this._getHttpServletRequest());
        if (map != null) {
            v.addAll(map.keySet());
        }
        if ((props = this._getHttpServletRequest().getHeaderNames()) != null) {
            while (props.hasMoreElements()) {
                v.add(props.nextElement());
            }
        }
        return new Enumerator(v.iterator());
    }

    public PortalContext getPortalContext() {
        return PortletObjectAccess.getPortalContext();
    }

    public String getAuthType() {
        return this._getHttpServletRequest().getAuthType();
    }

    public String getContextPath() {
        return this.portletWindow.getPortletEntity().getPortletDefinition().getPortletApplicationDefinition().getWebApplicationDefinition().getContextRoot();
    }

    public String getRemoteUser() {
        return this._getHttpServletRequest().getRemoteUser();
    }

    public Principal getUserPrincipal() {
        return this._getHttpServletRequest().getUserPrincipal();
    }

    public boolean isUserInRole(String roleName) {
        PortletEntity entity = this.portletWindow.getPortletEntity();
        PortletDefinition def = entity.getPortletDefinition();
        SecurityRoleRefSet set = def.getInitSecurityRoleRefSet();
        SecurityRoleRef ref = set.get(roleName);
        String link = null;
        link = ref != null && ref.getRoleLink() != null ? ref.getRoleLink() : roleName;
        return this._getHttpServletRequest().isUserInRole(link);
    }

    public Object getAttribute(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Attribute name == null");
        }
        Object attribute = this._getHttpServletRequest().getAttribute(NamespaceMapperAccess.getNamespaceMapper().encode(this.portletWindow.getId(), name));
        if (attribute == null) {
            attribute = this._getHttpServletRequest().getAttribute(name);
        }
        return attribute;
    }

    public Enumeration getAttributeNames() {
        Enumeration attributes = this._getHttpServletRequest().getAttributeNames();
        Vector<String> portletAttributes = new Vector<String>();
        while (attributes.hasMoreElements()) {
            String attribute = (String)attributes.nextElement();
            String portletAttribute = NamespaceMapperAccess.getNamespaceMapper().decode(this.portletWindow.getId(), attribute);
            if (portletAttribute == null) continue;
            portletAttributes.add(portletAttribute);
        }
        return portletAttributes.elements();
    }

    public String getParameter(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Parameter name == null");
        }
        this.bodyAccessed = true;
        Map parameters = this._getHttpServletRequest().getParameterMap();
        String[] values = (String[])parameters.get(name);
        if (values != null) {
            return values[0];
        }
        return null;
    }

    public Enumeration getParameterNames() {
        this.bodyAccessed = true;
        Map parameters = this._getHttpServletRequest().getParameterMap();
        return Collections.enumeration(parameters.keySet());
    }

    public String[] getParameterValues(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Parameter name == null");
        }
        this.bodyAccessed = true;
        String[] values = (String[])this._getHttpServletRequest().getParameterMap().get(name);
        if (values != null) {
            values = StringUtils.copy(values);
        }
        return values;
    }

    public Map getParameterMap() {
        this.bodyAccessed = true;
        Map result = StringUtils.copyParameters(this._getHttpServletRequest().getParameterMap());
        return result;
    }

    public boolean isSecure() {
        return this._getHttpServletRequest().isSecure();
    }

    public void setAttribute(String name, Object o) {
        if (name == null) {
            throw new IllegalArgumentException("Attribute name == null");
        }
        if (o == null) {
            this.removeAttribute(name);
        } else if (this.isNameReserved(name)) {
            this._getHttpServletRequest().setAttribute(name, o);
        } else {
            this._getHttpServletRequest().setAttribute(NamespaceMapperAccess.getNamespaceMapper().encode(this.portletWindow.getId(), name), o);
        }
    }

    public void removeAttribute(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Attribute name == null");
        }
        if (this.isNameReserved(name)) {
            this._getHttpServletRequest().removeAttribute(name);
        } else {
            this._getHttpServletRequest().removeAttribute(NamespaceMapperAccess.getNamespaceMapper().encode(this.portletWindow.getId(), name));
        }
    }

    public String getRequestedSessionId() {
        return this._getHttpServletRequest().getRequestedSessionId();
    }

    public boolean isRequestedSessionIdValid() {
        return this._getHttpServletRequest().isRequestedSessionIdValid();
    }

    public String getResponseContentType() {
        String responseContentType = this.provider.getResponseContentType();
        return responseContentType;
    }

    public Enumeration getResponseContentTypes() {
        Iterator responseContentTypes = this.provider.getResponseContentTypes();
        return new Enumerator(responseContentTypes);
    }

    public Locale getLocale() {
        return this._getHttpServletRequest().getLocale();
    }

    public Enumeration getLocales() {
        return this._getHttpServletRequest().getLocales();
    }

    public String getScheme() {
        return this._getHttpServletRequest().getScheme();
    }

    public String getServerName() {
        return this._getHttpServletRequest().getServerName();
    }

    public int getServerPort() {
        return this._getHttpServletRequest().getServerPort();
    }

    public void lateInit(HttpServletRequest webModuleServletRequest) {
        this.setRequest((ServletRequest)webModuleServletRequest);
    }

    public PortletWindow getInternalPortletWindow() {
        return this.portletWindow;
    }

    public void setIncluded(boolean included) {
        this.included = included;
    }

    public boolean isIncluded() {
        return this.included;
    }

    private HttpServletRequest _getHttpServletRequest() {
        return (HttpServletRequest)super.getRequest();
    }

    private boolean isNameReserved(String name) {
        return name.startsWith("java.") || name.startsWith("javax.");
    }

    public String getCharacterEncoding() {
        return this._getHttpServletRequest().getCharacterEncoding();
    }

    public String getContentType() {
        if (this.included) {
            return null;
        }
        return this._getHttpServletRequest().getContentType();
    }

    public int getContentLength() {
        if (this.included) {
            return 0;
        }
        return this._getHttpServletRequest().getContentLength();
    }

    public BufferedReader getReader() throws UnsupportedEncodingException, IOException {
        if (this.included) {
            return null;
        }
        BufferedReader reader = this._getHttpServletRequest().getReader();
        this.bodyAccessed = true;
        return reader;
    }

    public Cookie[] getCookies() {
        return this._getHttpServletRequest().getCookies();
    }

    public long getDateHeader(String name) {
        return this._getHttpServletRequest().getDateHeader(name);
    }

    public String getHeader(String name) {
        return this._getHttpServletRequest().getHeader(name);
    }

    public Enumeration getHeaders(String name) {
        return this._getHttpServletRequest().getHeaders(name);
    }

    public Enumeration getHeaderNames() {
        return this._getHttpServletRequest().getHeaderNames();
    }

    public int getIntHeader(String name) {
        return this._getHttpServletRequest().getIntHeader(name);
    }

    public String getPathInfo() {
        String attr = (String)super.getAttribute("javax.servlet.include.path_info");
        return attr != null ? attr : super.getPathInfo();
    }

    public String getQueryString() {
        String attr = (String)super.getAttribute("javax.servlet.include.query_string");
        return attr != null ? attr : super.getQueryString();
    }

    public String getPathTranslated() {
        return null;
    }

    public String getRequestURI() {
        String attr = (String)super.getAttribute("javax.servlet.include.request_uri");
        return attr != null ? attr : super.getRequestURI();
    }

    public StringBuffer getRequestURL() {
        return null;
    }

    public String getServletPath() {
        String attr = (String)super.getAttribute("javax.servlet.include.servlet_path");
        return attr != null ? attr : super.getServletPath();
    }

    public HttpSession getSession(boolean create) {
        return this._getHttpServletRequest().getSession(true);
    }

    public HttpSession getSession() {
        return this._getHttpServletRequest().getSession();
    }

    public String getMethod() {
        return this._getHttpServletRequest().getMethod();
    }

    public boolean isRequestedSessionIdFromURL() {
        return this._getHttpServletRequest().isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this._getHttpServletRequest().isRequestedSessionIdFromUrl();
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this._getHttpServletRequest().isRequestedSessionIdFromCookie();
    }

    public String getProtocol() {
        return null;
    }

    public String getRemoteAddr() {
        return null;
    }

    public String getRemoteHost() {
        return null;
    }

    public String getRealPath(String path) {
        return null;
    }

    public void setCharacterEncoding(String env) throws UnsupportedEncodingException {
        if (this.bodyAccessed) {
            throw new IllegalStateException("This method must not be called after the HTTP-Body was accessed !");
        }
        this._getHttpServletRequest().setCharacterEncoding(env);
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.included) {
            return null;
        }
        ServletInputStream stream = this._getHttpServletRequest().getInputStream();
        this.bodyAccessed = true;
        return stream;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return this._getHttpServletRequest().getRequestDispatcher(path);
    }
}

