/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.core.impl;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.portlet.ActionResponse;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.pluto.core.InternalActionResponse;
import org.apache.pluto.core.impl.PortletModeHelper;
import org.apache.pluto.core.impl.PortletResponseImpl;
import org.apache.pluto.om.window.PortletWindow;
import org.apache.pluto.services.information.DynamicInformationProvider;
import org.apache.pluto.services.information.InformationProviderAccess;
import org.apache.pluto.services.information.ResourceURLProvider;
import org.apache.pluto.util.StringUtils;

public class ActionResponseImpl
extends PortletResponseImpl
implements ActionResponse,
InternalActionResponse {
    boolean redirectAllowed = true;
    private boolean redirected;
    private String redirectLocation;
    private Map renderParameters = new HashMap();
    private WindowState windowState = null;
    private PortletMode portletMode = null;
    private DynamicInformationProvider provider = InformationProviderAccess.getDynamicProvider(this.getHttpServletRequest());

    public ActionResponseImpl(PortletWindow portletWindow, HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        super(portletWindow, servletRequest, servletResponse);
    }

    public void setWindowState(WindowState windowState) throws WindowStateException {
        if (this.redirected) {
            throw new IllegalStateException("it is not allowed to invoke setWindowState after sendRedirect has been called");
        }
        if (!this.provider.isWindowStateAllowed(windowState)) {
            throw new WindowStateException("Can't set this WindowState", windowState);
        }
        this.windowState = windowState;
        this.redirectAllowed = false;
    }

    public void setPortletMode(PortletMode portletMode) throws PortletModeException {
        if (this.redirected) {
            throw new IllegalStateException("it is not allowed to invoke setPortletMode after sendRedirect has been called");
        }
        boolean supported = this.provider.isPortletModeAllowed(portletMode);
        if (supported) {
            supported = PortletModeHelper.isPortletModeAllowedByPortlet(this.getInternalPortletWindow(), portletMode);
        }
        if (!supported) {
            throw new PortletModeException("Can't set this PortletMode", portletMode);
        }
        this.portletMode = portletMode;
        this.redirectAllowed = false;
    }

    public void sendRedirect(String location) throws IOException {
        if (this.redirectAllowed) {
            if (location != null) {
                HttpServletResponse redirectResponse = this._getHttpServletResponse();
                while (redirectResponse instanceof HttpServletResponseWrapper) {
                    redirectResponse = (HttpServletResponse)((HttpServletResponseWrapper)redirectResponse).getResponse();
                }
                ResourceURLProvider provider = InformationProviderAccess.getDynamicProvider(this.getHttpServletRequest()).getResourceURLProvider(this.getInternalPortletWindow());
                if (location.indexOf("://") != -1) {
                    provider.setAbsoluteURL(location);
                } else {
                    provider.setFullPath(location);
                }
                this.redirectLocation = location = redirectResponse.encodeRedirectURL(((Object)provider).toString());
                this.redirected = true;
            }
        } else {
            throw new IllegalStateException("Can't invoke sendRedirect() after certain methods have been called");
        }
    }

    public void setRenderParameters(Map parameters) {
        if (this.redirected) {
            throw new IllegalStateException("Can't invoke setRenderParameters() after sendRedirect() has been called");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Render parameters must not be null.");
        }
        Iterator iter = parameters.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (!(entry.getKey() instanceof String)) {
                throw new IllegalArgumentException("Key must not be null and of type java.lang.String.");
            }
            if (entry.getValue() instanceof String[]) continue;
            throw new IllegalArgumentException("Value must not be null and of type java.lang.String[].");
        }
        this.renderParameters = StringUtils.copyParameters(parameters);
        this.redirectAllowed = false;
    }

    public void setRenderParameter(String key, String value) {
        if (this.redirected) {
            throw new IllegalStateException("Can't invoke setRenderParameter() after sendRedirect() has been called");
        }
        if (key == null || value == null) {
            throw new IllegalArgumentException("Render parameter key or value must not be null.");
        }
        this.renderParameters.put(key, new String[]{value});
        this.redirectAllowed = false;
    }

    public void setRenderParameter(String key, String[] values) {
        if (this.redirected) {
            throw new IllegalStateException("Can't invoke setRenderParameter() after sendRedirect() has been called");
        }
        if (key == null || values == null || values.length == 0) {
            throw new IllegalArgumentException("Render parameter key or value must not be null or values be an empty array.");
        }
        this.renderParameters.put(key, StringUtils.copy(values));
        this.redirectAllowed = false;
    }

    public Map getRenderParameters() {
        return this.renderParameters;
    }

    public PortletMode getChangedPortletMode() {
        return this.portletMode;
    }

    public WindowState getChangedWindowState() {
        return this.windowState;
    }

    public String getRedirectLocation() {
        return this.redirectLocation;
    }
}

