/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.core.impl;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Set;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequestDispatcher;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import org.apache.pluto.Environment;
import org.apache.pluto.core.InternalPortletContext;
import org.apache.pluto.core.impl.PortletRequestDispatcherImpl;
import org.apache.pluto.om.portlet.PortletApplicationDefinition;

public class PortletContextImpl
implements PortletContext,
InternalPortletContext {
    private PortletApplicationDefinition portletApplicationDefinition;
    private ServletContext servletContext;

    public PortletContextImpl(ServletContext servletContext, PortletApplicationDefinition portletApplicationDefinition) {
        this.servletContext = servletContext;
        this.portletApplicationDefinition = portletApplicationDefinition;
    }

    public String getServerInfo() {
        return Environment.getServerInfo();
    }

    public PortletRequestDispatcher getRequestDispatcher(String path) {
        try {
            RequestDispatcher rd = this.servletContext.getRequestDispatcher(path);
            return new PortletRequestDispatcherImpl(rd);
        }
        catch (Exception e) {
            return null;
        }
    }

    public PortletRequestDispatcher getNamedDispatcher(String name) {
        RequestDispatcher rd = this.servletContext.getNamedDispatcher(name);
        return rd != null ? new PortletRequestDispatcherImpl(rd) : null;
    }

    public InputStream getResourceAsStream(String path) {
        return this.servletContext.getResourceAsStream(path);
    }

    public int getMajorVersion() {
        return Environment.getMajorSpecificationVersion();
    }

    public int getMinorVersion() {
        return Environment.getMinorSpecificationVersion();
    }

    public String getMimeType(String file) {
        return this.servletContext.getMimeType(file);
    }

    public String getRealPath(String path) {
        return this.servletContext.getRealPath(path);
    }

    public Set getResourcePaths(String path) {
        return this.servletContext.getResourcePaths(path);
    }

    public URL getResource(String path) throws MalformedURLException {
        if (path == null || !path.startsWith("/")) {
            throw new MalformedURLException("path must start with a '/'");
        }
        return this.servletContext.getResource(path);
    }

    public Object getAttribute(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Attribute name == null");
        }
        return this.servletContext.getAttribute(name);
    }

    public Enumeration getAttributeNames() {
        return this.servletContext.getAttributeNames();
    }

    public String getInitParameter(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Parameter name == null");
        }
        return this.servletContext.getInitParameter(name);
    }

    public Enumeration getInitParameterNames() {
        return this.servletContext.getInitParameterNames();
    }

    public void log(String msg) {
        this.servletContext.log(msg);
    }

    public void log(String message, Throwable throwable) {
        this.servletContext.log(message, throwable);
    }

    public void removeAttribute(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Attribute name == null");
        }
        this.servletContext.removeAttribute(name);
    }

    public void setAttribute(String name, Object object) {
        if (name == null) {
            throw new IllegalArgumentException("Attribute name == null");
        }
        this.servletContext.setAttribute(name, object);
    }

    public String getPortletContextName() {
        return this.servletContext.getServletContextName();
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public PortletApplicationDefinition getInternalPortletApplicationDefinition() {
        return this.portletApplicationDefinition;
    }
}

