/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.core.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.portlet.PortletPreferences;
import javax.portlet.PreferencesValidator;
import javax.portlet.ReadOnlyException;
import javax.portlet.ValidatorException;
import org.apache.pluto.Constants;
import org.apache.pluto.om.ControllerObjectAccess;
import org.apache.pluto.om.common.Preference;
import org.apache.pluto.om.common.PreferenceCtrl;
import org.apache.pluto.om.common.PreferenceSet;
import org.apache.pluto.om.common.PreferenceSetCtrl;
import org.apache.pluto.om.entity.PortletEntity;
import org.apache.pluto.om.entity.PortletEntityCtrl;
import org.apache.pluto.om.portlet.PortletDefinition;
import org.apache.pluto.om.portlet.PortletDefinitionCtrl;
import org.apache.pluto.util.Enumerator;
import org.apache.pluto.util.StringUtils;

public class PortletPreferencesImpl
implements PortletPreferences {
    private List preferenceSetList = new LinkedList();
    private HashMap changedPreferences = new HashMap();
    private HashSet removedPreferences = new HashSet();
    private Integer methodId = null;
    private PortletEntity portletEntity = null;
    private PortletDefinition portletDefinition = null;

    public PortletPreferencesImpl(Integer methodId, PortletEntity portletEntity) {
        this.methodId = methodId;
        this.portletEntity = portletEntity;
        this.portletDefinition = portletEntity.getPortletDefinition();
        this.preferenceSetList.add(portletEntity.getPreferenceSet());
        this.preferenceSetList.add(this.portletDefinition.getPreferenceSet());
    }

    public PortletPreferencesImpl(Integer methodId, PortletDefinition portletDefinition) {
        this.methodId = methodId;
        this.portletDefinition = portletDefinition;
        this.preferenceSetList.add(portletDefinition.getPreferenceSet());
    }

    public boolean isReadOnly(String key) {
        if (key == null) {
            throw new IllegalArgumentException("key == null");
        }
        boolean isReadOnly = false;
        if (this.preferenceSetList.size() != 1) {
            Preference preference = null;
            ListIterator iter = this.preferenceSetList.listIterator();
            while (preference == null && iter.hasNext()) {
                preference = ((PreferenceSet)iter.next()).get(key);
            }
            if (preference != null) {
                isReadOnly = preference.isReadOnly();
            }
        }
        return isReadOnly;
    }

    public String getValue(String key, String def) {
        if (key == null) {
            throw new IllegalArgumentException("key == null");
        }
        String[] defStr = new String[]{def};
        String[] values = this.getValues(key, defStr);
        if (values == null || values.length == 0) {
            return null;
        }
        return values[0];
    }

    public String[] getValues(String key, String[] def) {
        if (key == null) {
            throw new IllegalArgumentException("key == null");
        }
        if (this.changedPreferences.containsKey(key)) {
            return StringUtils.copy((String[])this.changedPreferences.get(key));
        }
        ListIterator iter = this.preferenceSetList.listIterator();
        if (this.removedPreferences.contains(key)) {
            iter.next();
        }
        Preference preference = null;
        while (preference == null && iter.hasNext()) {
            preference = ((PreferenceSet)iter.next()).get(key);
        }
        if (preference == null || !preference.isValueSet()) {
            return def;
        }
        String[] result = this.getValuesFromPreference(preference);
        if (result != null) {
            result = StringUtils.copy(result);
        }
        return result;
    }

    public void setValue(String key, String value) throws ReadOnlyException {
        if (key == null) {
            throw new IllegalArgumentException("key == null");
        }
        String[] values = new String[]{value};
        this.setValues(key, values);
    }

    public void setValues(String key, String[] values) throws ReadOnlyException {
        if (key == null) {
            throw new IllegalArgumentException("key == null");
        }
        if (this.isReadOnly(key)) {
            throw new ReadOnlyException("Preference attribute called " + key + " may not be modified");
        }
        this.changedPreferences.put(key, StringUtils.copy(values));
        this.removedPreferences.remove(key);
    }

    public Enumeration getNames() {
        String name;
        HashSet<Object> keyset = new HashSet<Object>();
        ListIterator listIter = this.preferenceSetList.listIterator();
        Iterator changedIter = this.changedPreferences.keySet().iterator();
        Iterator removedIter = this.removedPreferences.iterator();
        while (changedIter.hasNext()) {
            keyset.add(changedIter.next());
        }
        Iterator preferencesIter = ((PreferenceSet)listIter.next()).iterator();
        while (preferencesIter.hasNext()) {
            name = ((Preference)preferencesIter.next()).getName();
            keyset.add(name);
        }
        while (removedIter.hasNext()) {
            keyset.remove(removedIter.next());
        }
        while (listIter.hasNext()) {
            preferencesIter = ((PreferenceSet)listIter.next()).iterator();
            while (preferencesIter.hasNext()) {
                name = ((Preference)preferencesIter.next()).getName();
                keyset.add(name);
            }
        }
        return new Enumerator(keyset.iterator());
    }

    public Map getMap() {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        Enumeration enumeration = this.getNames();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            map.put(name, this.getValues(name, null));
        }
        return map;
    }

    public void reset(String key) throws ReadOnlyException {
        if (key == null) {
            throw new IllegalArgumentException("key == null");
        }
        if (this.isReadOnly(key)) {
            throw new ReadOnlyException("preference attribute called " + key + " may not be modified");
        }
        this.changedPreferences.remove(key);
        this.removedPreferences.add(key);
    }

    public void store() throws IOException, ValidatorException {
        String key;
        if (!this.methodId.equals(Constants.METHOD_ACTION)) {
            throw new IllegalStateException("store is only allowed inside a processAction call");
        }
        PreferencesValidator validator = this.portletDefinition.getPreferenceSet().getPreferencesValidator();
        if (validator != null) {
            validator.validate((PortletPreferences)this);
        }
        PreferenceSet preferences = (PreferenceSet)this.preferenceSetList.get(0);
        PreferenceSetCtrl preferencesCtrl = (PreferenceSetCtrl)ControllerObjectAccess.get(preferences);
        Iterator<Object> iter = this.changedPreferences.keySet().iterator();
        while (iter.hasNext()) {
            Preference preference;
            key = (String)iter.next();
            String[] values = (String[])this.changedPreferences.get(key);
            ArrayList<String> newValues = null;
            if (values != null) {
                newValues = new ArrayList<String>(values.length);
                for (int i = 0; i < values.length; ++i) {
                    newValues.add(values[i]);
                }
            }
            if ((preference = preferences.get(key)) != null) {
                PreferenceCtrl preferenceCtrl = (PreferenceCtrl)ControllerObjectAccess.get(preference);
                preferenceCtrl.setValues(newValues);
                continue;
            }
            preferencesCtrl.add(key, newValues);
        }
        this.changedPreferences.clear();
        iter = this.removedPreferences.iterator();
        while (iter.hasNext()) {
            key = (String)iter.next();
            preferencesCtrl.remove(key);
        }
        this.removedPreferences.clear();
        if (this.portletEntity != null) {
            PortletEntityCtrl portletEntityCtrl = (PortletEntityCtrl)ControllerObjectAccess.get(this.portletEntity);
            portletEntityCtrl.store();
        } else {
            PortletDefinitionCtrl portletDefinitionCtrl = (PortletDefinitionCtrl)ControllerObjectAccess.get(this.portletDefinition);
            portletDefinitionCtrl.store();
        }
    }

    private String[] getValuesFromPreference(Preference preference) {
        if (preference == null) {
            return null;
        }
        Iterator values = preference.getValues();
        if (values == null) {
            return null;
        }
        if (!values.hasNext()) {
            return new String[0];
        }
        ArrayList newValues = new ArrayList();
        while (values.hasNext()) {
            newValues.add(values.next());
        }
        return newValues.toArray(new String[newValues.size()]);
    }
}

