/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.core.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Locale;
import javax.portlet.PortletURL;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.pluto.core.impl.PortletResponseImpl;
import org.apache.pluto.factory.PortletObjectAccess;
import org.apache.pluto.om.entity.PortletEntity;
import org.apache.pluto.om.portlet.ContentType;
import org.apache.pluto.om.portlet.ContentTypeSet;
import org.apache.pluto.om.portlet.PortletDefinition;
import org.apache.pluto.om.window.PortletWindow;
import org.apache.pluto.services.title.DynamicTitle;
import org.apache.pluto.util.NamespaceMapperAccess;

public class RenderResponseImpl
extends PortletResponseImpl
implements RenderResponse {
    private static final String illegalStateExceptionText = "No content type set.";
    private String currentContentType = null;

    public RenderResponseImpl(PortletWindow portletWindow, HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        super(portletWindow, servletRequest, servletResponse);
    }

    public String getContentType() {
        return this.currentContentType;
    }

    public PortletURL createRenderURL() {
        PortletURL url = this.createURL(false);
        return url;
    }

    public PortletURL createActionURL() {
        PortletURL url = this.createURL(true);
        return url;
    }

    public String getNamespace() {
        String namespace = NamespaceMapperAccess.getNamespaceMapper().encode(this.getInternalPortletWindow().getId(), "");
        if (namespace.indexOf(45) != -1) {
            namespace = namespace.replace('-', '_');
        }
        return namespace;
    }

    public void setTitle(String title) {
        DynamicTitle.setDynamicTitle(this.getInternalPortletWindow(), this.getHttpServletRequest(), title);
    }

    public void setContentType(String type) {
        String mimeType = this.stripCharacterEncoding(type);
        if (!this.isValidContentType(mimeType)) {
            throw new IllegalArgumentException(mimeType);
        }
        this._getHttpServletResponse().setContentType(mimeType);
        this.currentContentType = mimeType;
    }

    public String getCharacterEncoding() {
        return this._getHttpServletResponse().getCharacterEncoding();
    }

    public PrintWriter getWriter() throws IOException, IllegalStateException {
        if (this.currentContentType == null) {
            throw new IllegalStateException(illegalStateExceptionText);
        }
        return super.getWriter();
    }

    public Locale getLocale() {
        return this.getHttpServletRequest().getLocale();
    }

    public void setBufferSize(int size) {
        throw new IllegalStateException("portlet container does not support buffering");
    }

    public int getBufferSize() {
        return 0;
    }

    public void flushBuffer() throws IOException {
        this._getHttpServletResponse().flushBuffer();
    }

    public void resetBuffer() {
        this._getHttpServletResponse().resetBuffer();
    }

    public boolean isCommitted() {
        return this._getHttpServletResponse().isCommitted();
    }

    public void reset() {
        this._getHttpServletResponse().reset();
    }

    public OutputStream getPortletOutputStream() throws IOException, IllegalStateException {
        if (this.currentContentType == null) {
            throw new IllegalStateException(illegalStateExceptionText);
        }
        return this.getOutputStream();
    }

    private PortletURL createURL(boolean isAction) {
        return PortletObjectAccess.getPortletURL(this.getInternalPortletWindow(), this.getHttpServletRequest(), this._getHttpServletResponse(), isAction);
    }

    private boolean isValidContentType(String type) {
        type = this.stripCharacterEncoding(type);
        PortletEntity entity = this.portletWindow.getPortletEntity();
        PortletDefinition def = entity.getPortletDefinition();
        ContentTypeSet contentTypes = def.getContentTypeSet();
        Iterator it = contentTypes.iterator();
        while (it.hasNext()) {
            ContentType ct = (ContentType)it.next();
            String supportedType = ct.getContentType();
            if (supportedType.equals(type)) {
                return true;
            }
            if (supportedType.indexOf("*") < 0) continue;
            int index = supportedType.indexOf("/");
            String supportedPrefix = supportedType.substring(0, index);
            String supportedSuffix = supportedType.substring(index + 1, supportedType.length());
            index = type.indexOf("/");
            String typePrefix = type.substring(0, index);
            String typeSuffix = type.substring(index + 1, type.length());
            if (!supportedPrefix.equals("*") && !supportedPrefix.equals(typePrefix) || !supportedSuffix.equals("*") && !supportedSuffix.equals(typeSuffix)) continue;
            return true;
        }
        return false;
    }

    private String stripCharacterEncoding(String type) {
        int xs = type.indexOf(59);
        String strippedType = xs == -1 ? type : type.substring(0, xs);
        return strippedType.trim();
    }
}

