/* Copyright 2003 The JA-SIG Collaborative.  All rights reserved.
*  See license distributed with this file and
*  available online at http://www.uportal.org/license.html
*/

package  org.jasig.portal;


/**
 * Internal adapter for a multithreaded privileged channel that is also cacheable and implements IMimeResponse (capable
 * of using DonwloadWorker)
 * @author  <a href="mailto:nbolton@unicon.net">Nick Bolton</a>
 * @version $Revision: 1.7 $
 * @see MultithreadedPrivilegedCacheableChannelAdapter
 */
public class MultithreadedPrivilegedCacheableMimeResponseChannelAdapter
extends MultithreadedCacheableMimeResponseChannelAdapter
implements IPrivilegedChannel {
    public MultithreadedPrivilegedCacheableMimeResponseChannelAdapter (IMultithreadedChannel channel,
    String uid) throws PortalException {
        super(channel, uid);
        if (!(channel instanceof IMultithreadedMimeResponse)) {
            throw  (new PortalException("MultithreadedPrivilegedCacheableMimeResponseChannelAdapter: Cannot adapt "
            + channel.getClass().getName()));
        }
    }
    public void setPortalControlStructures(PortalControlStructures pcs)
    throws PortalException {
        ((IMultithreadedPrivileged)channel).setPortalControlStructures(pcs,uid);
    }
}
