/* Copyright 2005 The JA-SIG Collaborative.  All rights reserved.
*  See license distributed with this file and
*  available online at http://www.uportal.org/license.html
*/

package org.jasig.portal.layout.dlm;


/**
 * Constants used in DLM.
 * 
 * @version $Revision: 1.4 $ $Date: 2005/05/12 15:59:43 $
 * @since uPortal 2.5
 */
public class Constants
{
    public static final String RCS_ID = "@(#) $Header: /home/cvs/jasig/portal/source/org/jasig/portal/layout/dlm/Constants.java,v 1.4 2005/05/12 15:59:43 mboyd Exp $";

    // define the namespace prefixe on dlm elements and attributes.
    public static final String NS = "dlm:";
    public static final String NS_DECL = "xmlns:dlm";
    public static final String NS_URI ="http://www.uportal.org/layout/dlm";
    
    // the following variables are to support backwards compatibility for
    // users of the DLM functionality before it was rolled into the uPortal
    // baseline code. This provides for just-in-time migration of any database
    // values containing the old namespace prefix.
    public static final String LEGACY_NS = "cp:";
    public static final String LEGACY_ATT_ORIGIN      = LEGACY_NS + "origin";

    
    // define the names of attributes that hold layout adjustment permissions
    // LCL refers to the local name without a namespace prefix.
       
    public static final String LCL_DELETE_ALLOWED     = "deleteAllowed";
    public static final String LCL_MOVE_ALLOWED       = "moveAllowed";
    public static final String LCL_EDIT_ALLOWED       = "editAllowed";
    public static final String LCL_ADD_CHILD_ALLOWED  = "addChildAllowed";

    public static final String ATT_DELETE_ALLOWED     = NS+LCL_DELETE_ALLOWED;
    public static final String ATT_MOVE_ALLOWED       = NS+LCL_MOVE_ALLOWED;
    public static final String ATT_EDIT_ALLOWED       = NS+LCL_EDIT_ALLOWED;
    public static final String ATT_ADD_CHILD_ALLOWED  = NS+LCL_ADD_CHILD_ALLOWED;

    public static final String ATT_ID                  = "ID";
    public static final String ATT_TYPE                = "type";
    public static final String ATT_CHANNEL_ID          = "chanID";
    public static final String ATT_HIDDEN              = "hidden";
    public static final String ATT_NAME                = "name";

    public static final String ATT_PLF_ID              = NS+"plfID";
    public static final String ATT_ORIGIN              = NS+"origin";
    public static final String ATT_PRECEDENCE          = NS+"precedence";
    public static final String ATT_FRAGMENT            = NS+"fragment";
    public static final String LCL_FRAGMENT_NAME       =    "fragmentName";
    public static final String ATT_FRAGMENT_NAME       = NS+LCL_FRAGMENT_NAME;
    public static final String LCL_IS_TEMPLATE_USER    =    "isTemplateUser";
    public static final String ATT_IS_TEMPLATE_USER    = NS+LCL_IS_TEMPLATE_USER;
    public static final String ATT_TEMPLATE_LOGIN_ID   = NS+"templateLoginID";
    public static final String ATT_DEBUG_PRINT         = NS+"debugPrint";

    public static final String ELM_POSITION_SET        = NS+"positionSet";
    public static final String ELM_POSITION            = NS+"position";
    public static final String ELM_DELETE_SET          = NS+"deleteSet";
    public static final String ELM_DELETE              = NS+"delete";
    public static final String ELM_EDIT_SET            = NS+"editSet";
    public static final String ELM_EDIT                = NS+"edit";
    public static final String ELM_PREF                = NS+"pref";
    
    public static final String PLF = "RDBMDistributedLayoutStore.PLF";
    public static final String STRUCTURE_PREFS
                                    = "StructureStylesheetUserPreferences";
    public static final String THEME_PREFS = "ThemeStylesheetUserPreferences";

    public static final String DIRECTIVE_PREFIX = "d";
    
}

