/* Copyright 2005 The JA-SIG Collaborative.  All rights reserved.
*  See license distributed with this file and
*  available online at http://www.uportal.org/license.html
*/

package org.jasig.portal.layout.dlm.providers;

import org.w3c.dom.Node;
import org.jasig.portal.layout.dlm.Evaluator;
import org.jasig.portal.layout.dlm.EvaluatorFactory;
import org.jasig.portal.security.IPerson;

/**
 * Used to target a fragment to all users of the system including guest users.
 * 
 * @version $Revision: 1.4 $ $Date: 2005/05/12 15:59:43 $
 * @since uPortal 2.5
 */
public class AllUsersEvaluatorFactory
    implements EvaluatorFactory, Evaluator
{
    public static final String RCS_ID = "@(#) $Header: /home/cvs/jasig/portal/source/org/jasig/portal/layout/dlm/providers/AllUsersEvaluatorFactory.java,v 1.4 2005/05/12 15:59:43 mboyd Exp $";

    public Evaluator getEvaluator( Node audience )
    {
        return this;
    }
    public boolean isApplicable( IPerson p )
    {
        return true;
    }
}
