/* Copyright 2002 The JA-SIG Collaborative.  All rights reserved.
*  See license distributed with this file and
*  available online at http://www.uportal.org/license.html
*/

package org.jasig.portal.services.stats;

import org.jasig.portal.UserProfile;
import org.jasig.portal.layout.LayoutEvent;
import org.jasig.portal.layout.LayoutEventListener;
import org.jasig.portal.layout.LayoutMoveEvent;
import org.jasig.portal.layout.node.IUserLayoutChannelDescription;
import org.jasig.portal.layout.node.IUserLayoutFolderDescription;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.services.StatsRecorder;

/**
 * Listens to events generated by an <code>IUserLayoutManager</code>.
 * The information in the event is passed along to the
 * <code>StatsRecorder</code> service.
 * @author Ken Weiner, kweiner@unicon.net
 * @version $Revision: 1.9 $
 */
public class StatsRecorderLayoutEventListener implements LayoutEventListener {
  
  IPerson person;
  UserProfile profile;

  /**
   * Constructor for <code>StatsRecorderLayoutEventListener</code>.
   * @param person the owner of the layout for which this listener is listening
   * @param profile the profile of the layout for which this listener is listening
   */  
  public StatsRecorderLayoutEventListener(IPerson person, UserProfile profile) {
    this.person = person;
    this.profile = profile;
  }
 
  // Channels...
  public void channelAdded(LayoutEvent ev) {
    IUserLayoutChannelDescription channelDesc = (IUserLayoutChannelDescription)ev.getNodeDescription();
    StatsRecorder.recordChannelAddedToLayout(person, profile, channelDesc);
  }
  
  public void channelUpdated(LayoutEvent ev) {
    IUserLayoutChannelDescription channelDesc = (IUserLayoutChannelDescription)ev.getNodeDescription();
    StatsRecorder.recordChannelUpdatedInLayout(person, profile, channelDesc);
  }
  
  public void channelMoved(LayoutMoveEvent ev) {
    IUserLayoutChannelDescription channelDesc = (IUserLayoutChannelDescription)ev.getNodeDescription();
    StatsRecorder.recordChannelMovedInLayout(person, profile, channelDesc);
  }
  
  public void channelDeleted(LayoutMoveEvent ev) {
    IUserLayoutChannelDescription channelDesc = (IUserLayoutChannelDescription)ev.getNodeDescription();
    StatsRecorder.recordChannelRemovedFromLayout(person, profile, channelDesc);    
  }

  // Folders...
  public void folderAdded(LayoutEvent ev) {
    IUserLayoutFolderDescription folderDesc = (IUserLayoutFolderDescription)ev.getNodeDescription();
    StatsRecorder.recordFolderAddedToLayout(person, profile, folderDesc);    
  }
  
  public void folderUpdated(LayoutEvent ev) {
    IUserLayoutFolderDescription folderDesc = (IUserLayoutFolderDescription)ev.getNodeDescription();
    StatsRecorder.recordFolderUpdatedInLayout(person, profile, folderDesc);    
  }
  
  public void folderMoved(LayoutMoveEvent ev) {
    IUserLayoutFolderDescription folderDesc = (IUserLayoutFolderDescription)ev.getNodeDescription();
    StatsRecorder.recordFolderMovedInLayout(person, profile, folderDesc);    
  }
  
  public void folderDeleted(LayoutMoveEvent ev) {
    IUserLayoutFolderDescription folderDesc = (IUserLayoutFolderDescription)ev.getNodeDescription();
    StatsRecorder.recordFolderRemovedFromLayout(person, profile, folderDesc);    
  }

  // Layout...
  public void layoutLoaded() {
  }
  
  public void layoutSaved() {
  }
}
