/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.imap.protocol;

import com.sun.mail.iap.ParsingException;
import com.sun.mail.iap.Response;
import com.sun.mail.imap.protocol.ENVELOPE;
import com.sun.mail.imap.protocol.FetchResponse;
import com.sun.mail.imap.protocol.Item;
import java.util.Vector;
import javax.mail.internet.ParameterList;

public class BODYSTRUCTURE
implements Item {
    public static char[] name = new char[]{'B', 'O', 'D', 'Y', 'S', 'T', 'R', 'U', 'C', 'T', 'U', 'R', 'E'};
    public int msgno;
    public String type;
    public String subtype;
    public String encoding;
    public int lines = -1;
    public int size = -1;
    public String disposition;
    public String id;
    public String description;
    public String md5;
    public String attachment;
    public ParameterList cParams;
    public ParameterList dParams;
    public String[] language;
    public BODYSTRUCTURE[] bodies;
    public ENVELOPE envelope;
    private static int SINGLE = 1;
    private static int MULTI = 2;
    private static int NESTED = 3;
    private int processedType;

    public BODYSTRUCTURE(FetchResponse fetchResponse) throws ParsingException {
        this.msgno = fetchResponse.getNumber();
        fetchResponse.skipSpaces();
        if (fetchResponse.readByte() != 40) {
            throw new ParsingException("BODYSTRUCTURE parse error: missing ``('' at start");
        }
        if (fetchResponse.peekByte() == 40) {
            this.type = "multipart";
            this.processedType = MULTI;
            Vector<BODYSTRUCTURE> vector = new Vector<BODYSTRUCTURE>(1);
            do {
                vector.addElement(new BODYSTRUCTURE(fetchResponse));
                fetchResponse.skipSpaces();
            } while (fetchResponse.peekByte() == 40);
            this.bodies = new BODYSTRUCTURE[vector.size()];
            vector.copyInto(this.bodies);
            this.subtype = fetchResponse.readString();
            if (fetchResponse.readByte() == 41) {
                return;
            }
            this.cParams = this.parseParameters(fetchResponse);
            if (fetchResponse.readByte() == 41) {
                return;
            }
            byte by = fetchResponse.readByte();
            if (by == 40) {
                this.disposition = fetchResponse.readString();
                this.dParams = this.parseParameters(fetchResponse);
                if (fetchResponse.readByte() != 41) {
                    throw new ParsingException("BODYSTRUCTURE parse error: missing ``)'' at end of disposition in multipart");
                }
            } else if (by == 78 || by == 110) {
                fetchResponse.skip(2);
            }
            if (fetchResponse.readByte() != 32) {
                throw new ParsingException("BODYSTRUCTURE parse error: missing space after disposition");
            }
            if (fetchResponse.peekByte() == 40) {
                this.language = fetchResponse.readStringList();
            } else {
                String string = fetchResponse.readString();
                if (string != null) {
                    String[] stringArray = new String[]{string};
                    this.language = stringArray;
                }
            }
            while (fetchResponse.readByte() == 32) {
                this.parseBodyExtension(fetchResponse);
            }
            return;
        }
        this.type = fetchResponse.readString();
        this.processedType = SINGLE;
        this.subtype = fetchResponse.readString();
        if (this.type == null) {
            this.type = "application";
            this.subtype = "octet-stream";
        }
        this.cParams = this.parseParameters(fetchResponse);
        this.id = fetchResponse.readString();
        this.description = fetchResponse.readString();
        this.encoding = fetchResponse.readString();
        this.size = fetchResponse.readNumber();
        if (this.size < 0) {
            throw new ParsingException("BODYSTRUCTURE parse error: bad ``size'' element");
        }
        if (this.type.equalsIgnoreCase("text")) {
            this.lines = fetchResponse.readNumber();
            if (this.lines < 0) {
                throw new ParsingException("BODYSTRUCTURE parse error: bad ``lines'' element");
            }
        } else if (this.type.equalsIgnoreCase("message") && this.subtype.equalsIgnoreCase("rfc822")) {
            this.processedType = NESTED;
            this.envelope = new ENVELOPE(fetchResponse);
            BODYSTRUCTURE[] bODYSTRUCTUREArray = new BODYSTRUCTURE[]{new BODYSTRUCTURE(fetchResponse)};
            this.bodies = bODYSTRUCTUREArray;
            this.lines = fetchResponse.readNumber();
            if (this.lines < 0) {
                throw new ParsingException("BODYSTRUCTURE parse error: bad ``lines'' element");
            }
        }
        if (fetchResponse.readByte() == 41) {
            return;
        }
        this.md5 = fetchResponse.readString();
        if (fetchResponse.readByte() == 41) {
            return;
        }
        byte by = fetchResponse.readByte();
        if (by == 40) {
            this.disposition = fetchResponse.readString();
            this.dParams = this.parseParameters(fetchResponse);
            if (fetchResponse.readByte() != 41) {
                throw new ParsingException("BODYSTRUCTURE parse error: missing ``)'' at end of disposition");
            }
        } else if (by == 78 || by == 110) {
            fetchResponse.skip(2);
        }
        if (fetchResponse.readByte() == 41) {
            return;
        }
        if (fetchResponse.peekByte() == 40) {
            this.language = fetchResponse.readStringList();
        } else {
            String string = fetchResponse.readString();
            if (string != null) {
                String[] stringArray = new String[]{string};
                this.language = stringArray;
            }
        }
        while (fetchResponse.readByte() == 32) {
            this.parseBodyExtension(fetchResponse);
        }
    }

    public boolean isMulti() {
        return this.processedType == MULTI;
    }

    public boolean isSingle() {
        return this.processedType == SINGLE;
    }

    public boolean isNested() {
        return this.processedType == NESTED;
    }

    private ParameterList parseParameters(Response response) throws ParsingException {
        response.skipSpaces();
        ParameterList parameterList = null;
        byte by = response.readByte();
        if (by == 40) {
            parameterList = new ParameterList();
            do {
                String string = response.readString();
                String string2 = response.readString();
                parameterList.set(string, string2);
            } while (response.readByte() != 41);
        } else if (by == 78 || by == 110) {
            response.skip(2);
        } else {
            throw new ParsingException("Parameter list parse error");
        }
        return parameterList;
    }

    private void parseBodyExtension(Response response) throws ParsingException {
        response.skipSpaces();
        byte by = response.peekByte();
        if (by == 40) {
            response.skip(1);
            do {
                this.parseBodyExtension(response);
            } while (response.readByte() != 41);
            return;
        }
        if (Character.isDigit((char)by)) {
            response.readNumber();
            return;
        }
        response.readString();
    }
}

