/*
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:olivier.ziller@univ-nancy2.fr">Olivier Ziller</a><br>
 * @version 1.0<br>
 */ 
package org.esupportail.portal.utils.channels;

import java.util.ArrayList;
import java.util.List;

/**
 * ActionParams<br>
 * <br>
 * Paramtre ventuellement associ  une action.
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:olivier.ziller@univ-nancy2.fr">Olivier Ziller</a>
 * @version 1.0
 * 
 */
public class ActionParam {
	
	private String name;
	private List values;
	
	/**
	 * @return Returns the name.
	 */
	public String getName() {
		return name;
	}
	
	/**
	 * @param name The name to set.
	 */
	public void setName(String name) {
		this.name = name;
	}
	
	/**
	 * @return Returns the first value.
	 */
	public String getValue() {
		if (values != null)
			return (String) values.get(0);
		return null;
	}
	
	/**
	 * @return Returns the first value.
	 */
	public List getValues() {
		return values;
	}
	
	/**
	 * @param values The values to set.
	 */
	public void setValues(List values) {
		this.values = values;
	}
	
	/**
	 * Ajout d'une valeur au paramtre
	 * @param param
	 */
	public void addParamValue(String value) {
		if (values == null)
			values = new ArrayList();
		values.add(value);
	}
}
