/*
 * (c)Copyright <a href="http://www.univ-nancy2.fr">CRI Nancy 2 2004</a><br>
 * @author <a href="mailto:olivier.ziller@univ-nancy2.fr">Olivier Ziller</a><br>
 * @version 1.0<br>
 */
package org.esupportail.portal.utils.channels;

import java.io.IOException;
import java.net.URL;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;

import org.apache.commons.digester.*;
import org.apache.log4j.Priority;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.jasig.portal.services.*; // pour la classe LogService

import org.esupportail.portal.utils.database.Database;
import org.esupportail.portal.utils.database.IConfigPools;
import org.esupportail.portal.utils.database.Query;

/**
 * ConfigChannel<br>
 * <br>
 * Classe permettant d'accder  la configuration de la channel CAdresses<br> 
 * <br>
 * (c)Copyright <a href="http://www.univ-nancy2.fr">CRI Nancy 2 2004</a><br>
 * @author <a href="mailto:olivier.ziller@univ-nancy2.fr">Olivier Ziller</a>
 * @version 1.0
 * 
 */
public abstract class ConfigChannel implements IConfigActions, IConfigPools, IConfigMail
{ 
	// pool de connexion  utiliser pour les requtes
	private HashMap pools;
	// Listes des actions de la channel
	private HashMap actions = null;
	// Encoding xml pour les actions
	private String xmlencoding;
	// Niveau de log
	private String log;
	private Priority logLevel;
	// Digester
	protected Digester dig = null;
	// URL du fichier de config
	protected URL resourceURL = null;
	// Nom du package en cours
	private String packageName;
	// infos mail d'erreur	
	private String smtp;
	private String from;
	private String to;
	private String subject;
	private String message;
	// message affiche lorsqu'une FrameworkException est capture
	private String displayError;
	/// hashmap des groupmapping
	private HashMap groupmapping;
	
	
	/**
	* Constructeur priv (singleton) de la classe
	* 
	* @throws IOException
	* @throws JspException
	*/
	protected ConfigChannel() {
		// Initialisation variables
		xmlencoding = "ISO-8859-1";
		log = "debug";
		logLevel = Priority.DEBUG;
		// Package en cours
		packageName = getPackageName();
		// initialisation du digester
		initDigester();
		// personnalisation du digester
		customDigester();
		// parsing du digester
		parseDigester();
	}
	
	/**
	 * Initialisation du digester avec paramtrage pour lecture des actions et des pools 
	 *
	 */
	private void initDigester() {
		//	Cration d'une instance Digester 
		dig = new Digester();
		//On rend l'objet disponible  la manipulation en le mettant en haut de la pile
		dig.push(this);
		// Liste des actions
		dig.addCallMethod("config/actions","addActions",2);
		dig.addCallParam("config/actions", 0, "xmlencoding");
		dig.addCallParam("config/actions", 1, "log");
		// Une action
		dig.addObjectCreate("config/actions/action",Action.class);
		dig.addSetProperties( "config/actions/action");
		// Paramtres d'action
		dig.addObjectCreate("config/actions/action/param",ActionParam.class);
		dig.addSetProperties( "config/actions/action/param");
		dig.addSetNext("config/actions/action/param","addActionParam");
		dig.addSetNext("config/actions/action","addAction");
		// Valeurs des paramtres d'action
		dig.addCallMethod("config/actions/action/param/value","addParamValue",1);
		dig.addCallParam("config/actions/action/param/value",0);
		setActions(new HashMap());
		// Pools
		dig.addObjectCreate("config/pools/pool",Database.class);
		dig.addSetProperties("config/pools/pool");
		dig.addSetNext("config/pools/pool","addPool");
		// Message d'errreur affich  l'cran lorsqu'une FrameWorkException est leve
		dig.addCallMethod("config/displayError","addDisplayError",1);
		dig.addCallParam("config/displayError",0);
		// Mail Erreur
		dig.addCallMethod("config/mailError","addMailError",5);
		dig.addCallParam("config/mailError/smtp",0);
		dig.addCallParam("config/mailError/from",1);
		dig.addCallParam("config/mailError/to",2);
		dig.addCallParam("config/mailError/subject",3);
		dig.addCallParam("config/mailError/message",4);
		// Groupmapping
		dig.addObjectCreate("config/groupmapping/group",Group.class);
		dig.addSetProperties("config/groupmapping/group");
		dig.addSetNext("config/groupmapping/group","addGroup");
		
	}
	
	/**
	 * Mthode qui permet d'ajouter une personnalisation sur les rgles que doit prendre en compte
	 * le digester
	 */
	protected void customDigester() {}
	
	/**
	 * Mthode abstraite qui fournit le nom du fichier de configuration de la channel
	 * par exemple return "/properties/channels/fr_univnancy2/CAdresses/CApogeeAdresses.xml";
	 * 
	 * @return
	 */
	protected abstract String getConfigFile ();

	/**
	 * Parsing du fichier de config par le digester
	 *
	 */
	private void parseDigester() {
		//	Emplacement du fichier de config  parser  partir du rpertoire classes
		resourceURL =    ConfigChannel.class.getResource(getConfigFile());
		if (resourceURL != null){
			try {
				// On parse le fichier dont le chemin est pass en paramtre
				dig.parse(new InputSource(resourceURL.toExternalForm()));
			 }
			catch (IOException e) {
				 LogService.log(LogService.ERROR,"ConfigChannel::ConfigChannel() : ERREUR : Impossible d'ouvrir le fichier de config \n" + e.toString());
				 }
			catch (SAXException e) {
				LogService.log(LogService.ERROR,"ConfigChannel::ConfigChannel() : ERREUR : SAXException :\n" + e.toString());
				 //throw new JspException(e);
				 } 
			catch (Exception e) {
				LogService.log(LogService.ERROR,"ConfigChannel::ConfigChannel() : ERREUR : de lecture du fichier de config\n" + e.toString());
			}
		}
		else{
			LogService.log(LogService.ERROR,"ConfigChannel::ConfigChannel() : ERREUR : Le fichier de config n'existe pas.\n");
		}	
	}
	
	/**
	 * Mthode appele par le digester lorsqu'une action a t lue dans le fichier de config 
	 * @param a
	 */
	public void addAction(Action a) {
		// Ajout du nom du package courant  la classe si la classe a t prcise sans package
		if (a.getClassname().indexOf(".") < 0)
			a.setClassname(packageName + "." + a.getClassname());
		// Ajout de l'action  la map
		actions.put(a.getName(), a);
	}
	
	/* (non-Javadoc)
	 * @see org.esupportail.portal.utils.channels.IConfigActions#getActions()
	 */
	public HashMap getActions() {
		return actions;
	}

	/* (non-Javadoc)
	 * @see org.esupportail.portal.utils.channels.IConfigActions#setActions(java.util.HashMap)
	 */
	public void setActions(HashMap map) {
		actions = map;
	}

	/**
	 * Mthode appele par le digester lorsqu'un pool a t lu dans le fichier de config
	 * 
	 * @param db
	 */
	public void addPool(Database db) {
	if (pools == null)
		pools = new HashMap();
	pools.put(db.getName(), db);
	}

	/* (non-Javadoc)
	 * @see fr.univnancy2.portal.utils.database.IConfigPools#getPools()
	 */
	public HashMap getPools() {
		return pools;
	}
	/* (non-Javadoc)
	 * @see fr.univnancy2.portal.utils.database.IConfigPools#setPools(java.util.HashMap)
	 */
	public void setPools(HashMap map) {
		this.pools = map;
	}

	/**
	 * Retourne le nom du package en cours
	 * @return nom du package
	 */
	protected String getPackageName() {
		String fullyQualifiedName = this.getClass().getName();
	    int lastDot = fullyQualifiedName.lastIndexOf ('.');
	    if (lastDot==-1){ return ""; }
	    
	    return fullyQualifiedName.substring (0, lastDot);
	}
	
	/**
	 * 
	 * Rcupre la connexion (JDBC ou JNDI) par dfaut de la channnel si elle est dfinie 
	 */
	public Query getConnexionDefault() {
		MAGQuery query = null;
		Database db = null;
		try {
			if (getPools() != null) 
				db = (Database) getPools().get("default");
			if (db == null) 
				LogService.log(LogService.ERROR ,"ConfigChannel::getConnexionDefault() : Objet Database Default vide");
			query = new MAGQuery(db);
		}
		catch (SQLException e) { 
			LogService.log(LogService.ERROR ,"ConfigChannel::getConnexionDefault() : Erreur SQL " + e);
		}
		
		return query;
	}
	
	/**
	 * 
	 * Rcupre la connexion (JDBC ou JNDI) dont le nom est pass en paramtre 
	 */
	public Query getConnexion(String name) {
		MAGQuery query = null;
		Database db = null;
		try {
			if (getPools() != null) 
				db = (Database) getPools().get(name);
			if (db == null) 
				LogService.log(LogService.ERROR ,"ConfigChannel::getConnexion() : Objet Database " + name + " vide");
			query = new MAGQuery(db);
		}
		catch (SQLException e) { 
			LogService.log(LogService.ERROR ,"ConfigChannel::getConnexion() : Erreur SQL " + e);
		}
		
		return query;
	}
	
	public void addDisplayError(String msg) {
		LogService.log(LogService.INFO ,"displayError "+ msg);
		this.displayError = msg;
	}
	
	/**
	 * Mthode appele par le digester lorsque le mail d'erreur a t lu dans le fichier de config
	 * 
	 */
	public void addMailError(String smtp, String from, String to, String subject, String message){
		this.smtp = smtp;
		this.from = from;
		this.to = to;
		this.subject = subject;
		if (message == null)
			this.message = "";
		else	
			this.message = message;
	}
	
	public String getSubject() {
		return subject;
	}
	
	public String getFrom() {
		return from;
	}
	
	public String getTo() {
		return to;
	}
	
	public String getMessage() {
		return message;
	}
	
	public String getSmtp() {
		return smtp;
	}

	/**
	 * @return
	 */
	public String getDisplayError() {
		return displayError;
	}

	/**
	 * @param string
	 */
	public void setDisplayError(String string) {
		displayError = string;
	}

	/**
	 * @return Returns the encoding.
	 */
	public String getXmlEncoding() {
		return xmlencoding;
	}

	/**
	 * @return Returns the log.
	 */
	public Priority getLogLevel() {
		return logLevel;
	}
	/**
	 * @param log The log to set.
	 */
	public void setLog(String log) {
		this.log = log;
		if (log.equalsIgnoreCase("debug"))
				logLevel = Priority.DEBUG;
		if (log.equalsIgnoreCase("info"))
				logLevel = Priority.INFO;
		if (log.equalsIgnoreCase("error"))
				logLevel = Priority.ERROR;
		if (log.equalsIgnoreCase("fatal"))
				logLevel = Priority.FATAL;
	}
	
	/**
	 * Mthode appele par le digester pour lire les attributs du tag actions
	 * 
	 */
	public void addActions(String xmlencoding, String log){
		this.xmlencoding = xmlencoding;
		setLog(log);
		// Valeur par dfaut pour les logs des actions
		Iterator iter = actions.keySet().iterator();
		while (iter.hasNext()) {
			Action action = (Action)actions.get((String)iter.next());
			if (action.getLog().equals("default")) {
				action.setLog(this.log);
			}
		}
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#clone()
	 */
	public Object clone() throws CloneNotSupportedException {
		ConfigChannel copie = (ConfigChannel)super.clone();
		copie.actions = (HashMap)actions.clone();
		return copie;
	}
	/**
	 * @return Returns the log.
	 */
	public String getLog() {
		return log;
	}
	
	/**
	 * Mthode appele par le digester lorsqu'un groupmapping a t lu dans le fichier de config
	 * 
	 * @param db
	 */
	public void addGroup(Group g) {
		if (groupmapping == null)
			groupmapping = new HashMap();
		groupmapping.put(g.getLocalname(),g.getUportalid());
	}
	
	/**
	 * @return Returns the groupmapping.
	 */
	public HashMap getGroupmapping() {
		return groupmapping;
	}
	/**
	 * @param groupmapping The groupmapping to set.
	 */
	public void setGroupmapping(HashMap groupmapping) {
		this.groupmapping = groupmapping;
	}
}
