package org.esupportail.portal.utils.channels;

import org.jasig.portal.services.LogService;

/** 
 * <p>Titre : FrameWorkException</p>
 * <p>Description : Classe de gestion des erreurs du framework</p>
 * <p>Copyright : Copyright (c) <a href="www.esup-portail.org">ESup-Portail 2004</a></p>
 * <p>Socit : N2</p>
 * @author <a href="mailto:cedric.champmartin@univ-nancy2.fr">Cdric Champmartin</a>
 * @version 1.0
 */
public class FrameWorkException extends Exception {

	// message d'erreur affich dans la channel ( destination de l'utilisateur)	
	private String displayMessage;
	// message d'erreur insr dans le mail ( destination du dveloppeur)
	private String message;
	// message par dfaut fourni  l'utilisateur
	private String msgDefault = "Une erreur est survenue dans l'ex\u00E9cution du canal. Veuillez r\u00E9essayer ult\u00E9rieurement.";
	
	/**
	* Constructeur 
	* 
	* @param <b>IConfigMail</b> conf fichier de configuration
	* @param <b>String</b> msg message insr dans le mail
	*/
	public FrameWorkException (IConfigMail conf, String msg) {
		setMessage(msg);
		if (conf.getDisplayError() != null)
			setDisplayMessage(conf.getDisplayError());
		else
			setDisplayMessage(msgDefault);
		Mail m = new Mail(conf);
		m.setMessage("<b>"+m.getMessage()+"</b><p><blockquote>"+msg+"</blockquote></p>");
		try {
			m.send(null);
		} catch (Exception e) {
			LogService.log(LogService.ERROR,"FrameWorkException::FrameWorkException(IConfigMail,String) : ERREUR : " + e);
		}
	}

	/**
	* Constructeur 
	* 
	* @param <b>IConfigMail</b> conf fichier de configuration
	* @param <b>String</b> msg message insr dans le mail
	* @param <b>String</b> stack tat de la pile au moment de l'erreur
	*/
	public FrameWorkException (IConfigMail conf, String msg, String stack) {
		setMessage(msg);
		if (conf.getDisplayError() != null)
			setDisplayMessage(conf.getDisplayError());
		else
			setDisplayMessage(msgDefault);
		Mail m = new Mail(conf);
		m.setMessage("<b>"+m.getMessage()+"</b><p><blockquote>"+msg+"</blockquote></p>"+
					 "<p><b>StackTrace : </b><br>"+stack+"</p>");
		try {
			m.send(null);
		} catch (Exception e) {
			LogService.log(LogService.ERROR,"FrameWorkException::FrameWorkException(IConfigMail,String,String) : ERREUR : " + e);
		}
	}

	/**
	* Constructeur 
	* 
	*/
	public FrameWorkException (String displayMessage) {
		setDisplayMessage(displayMessage);
	}

	/**
	* Constructeur 
	* 
	*/
	public FrameWorkException () {
		setDisplayMessage(msgDefault);
	}		
		
	/**
	 * @return
	 */
	public String getDisplayMessage() {
		return displayMessage;
	}

	/**
	 * @param string
	 */
	public void setDisplayMessage(String string) {
		displayMessage = string;
	}

	/**
	 * @return
	 */
	public String getMessage() {
		return message;
	}

	/**
	 * @param string
	 */
	public void setMessage(String string) {
		message = string;
	}

	/**
	 * @return
	 */
	public String getMsgDefault() {
		return msgDefault;
	}

	/**
	 * @param string
	 */
	public void setMsgDefault(String string) {
		msgDefault = string;
	}

}
